/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowReformatFileDialog
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            presentation2.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation2.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            presentation2.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation2.setEnabled(false);
            return;
        }
        boolean hasSelection = editor.getSelectionModel().hasSelection();
        LayoutCodeDialog dialog2 = new LayoutCodeDialog(project, file2, hasSelection, HELP_ID);
        dialog2.show();
        if (dialog2.isOK()) {
            new FileInEditorProcessor(file2, editor, dialog2.getRunOptions()).processCode();
        }
    }
}

