/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ReaderModeActionProvider;
import com.intellij.codeInsight.actions.ReaderModeConfigurable;
import com.intellij.codeInsight.actions.ReaderModeFileEditorListener;
import com.intellij.codeInsight.actions.ReaderModeListener;
import com.intellij.codeInsight.actions.ReaderModeListenerKt;
import com.intellij.codeInsight.actions.ReaderModeSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.markup.InspectionWidgetActionProvider;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/actions/ReaderModeActionProvider;", "Lcom/intellij/openapi/editor/markup/InspectionWidgetActionProvider;", "separator", "Lcom/intellij/openapi/actionSystem/Separator;", "(Lcom/intellij/openapi/actionSystem/Separator;)V", "getSeparator", "()Lcom/intellij/openapi/actionSystem/Separator;", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.platform.lang.impl"})
public final class ReaderModeActionProvider
implements InspectionWidgetActionProvider {
    @Nullable
    private final Separator separator;
    @NotNull
    private static final ColorKey FOREGROUND;
    @NotNull
    private static final ColorKey ACTIONS_GREY_COLOR_KEY;
    public static final Companion Companion;

    @NotNull
    public AnAction getAction(@NotNull Editor editor) {
        return (AnAction)new CustomComponentAction(editor, LangBundle.messagePointer((String)"action.ReaderModeProvider.text", (Object[])new Object[0]), LangBundle.messagePointer((String)"action.ReaderModeProvider.description", (Object[])new Object[0]), null){
            final /* synthetic */ Editor $editor;

            @NotNull
            public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
                ActionButtonWithText actionButtonWithText2 = new ActionButtonWithText(this, presentation2, place, (AnAction)this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){
                    final /* synthetic */ getAction.1 this$0;
                    final /* synthetic */ Presentation $presentation;
                    final /* synthetic */ String $place;

                    protected int iconTextSpace() {
                        return JBUI.scale((int)2);
                    }

                    protected void updateToolTipText() {
                        Project project = this.this$0.$editor.getProject();
                        if (Registry.is((String)"ide.helptooltip.enabled") && project != null) {
                            HelpTooltip.dispose((Component)this);
                            new HelpTooltip().setTitle(this.myPresentation.getDescription()).setDescription(LangBundle.message((String)"action.ReaderModeProvider.description", (Object[])new Object[0])).setLink(LangBundle.message((String)"action.ReaderModeProvider.link.configure", (Object[])new Object[0]), new Runnable(project){
                                final /* synthetic */ Project $project;

                                public final void run() {
                                    ShowSettingsUtil.getInstance().showSettingsDialog(this.$project, ReaderModeConfigurable.class);
                                }
                                {
                                    this.$project = project;
                                }
                            }).installOn((JComponent)this);
                        } else {
                            this.setToolTipText(this.myPresentation.getDescription());
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$presentation = $captured_local_variable$1;
                        this.$place = $captured_local_variable$2;
                        super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }
                };
                actionButtonWithText2.setForeground((Color)new JBColor((NotNullProducer)new NotNullProducer<Color>(this){
                    final /* synthetic */ getAction.1 this$0;

                    @NotNull
                    public final Color produce() {
                        Color color = this.this$0.$editor.getColorsScheme().getColor(ReaderModeActionProvider.Companion.getFOREGROUND());
                        if (color == null) {
                            color = ReaderModeActionProvider.Companion.getFOREGROUND().getDefaultColor();
                        }
                        return color;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                if (!SystemInfo.isWindows) {
                    Font font = actionButtonWithText2.getFont();
                    font = new FontUIResource(font.deriveFont(font.getStyle(), (float)font.getSize() - (float)JBUIScale.scale((int)2)));
                    actionButtonWithText2.setFont(font);
                }
                return actionButtonWithText2;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                ReaderModeSettings.Companion.instance(project2).setEnabled(!ReaderModeSettings.Companion.instance(project2).getEnabled());
                ((ReaderModeListener)project2.getMessageBus().syncPublisher(ReaderModeListenerKt.getREADER_MODE_TOPIC())).modeChanged(project2);
            }

            public void update(@NotNull AnActionEvent e) {
                if (!Experiments.getInstance().isFeatureEnabled("editor.reader.mode")) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                VirtualFile file2 = (VirtualFile)PlatformDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
                e.getPresentation().setEnabledAndVisible(ReaderModeFileEditorListener.Companion.matchMode(project2, file2));
                Presentation presentation2 = e.getPresentation();
                if (!ReaderModeSettings.Companion.instance(project2).getEnabled()) {
                    presentation2.setText((String)null);
                    presentation2.setIcon(AllIcons.General.ReaderMode);
                    presentation2.setHoveredIcon((Icon)null);
                    presentation2.setDescription(LangBundle.message((String)"action.ReaderModeProvider.text.enter", (Object[])new Object[0]));
                } else {
                    presentation2.setText(LangBundle.message((String)"action.ReaderModeProvider.text", (Object[])new Object[0]));
                    presentation2.setIcon(EmptyIcon.ICON_16);
                    presentation2.setHoveredIcon(IconUtil.colorize((Icon)AllIcons.Actions.Close, (Color)ReaderModeActionProvider.Companion.getACTIONS_GREY_COLOR_KEY().getDefaultColor()));
                    presentation2.setDescription(LangBundle.message((String)"action.ReaderModeProvider.text.exit", (Object[])new Object[0]));
                }
            }
            {
                this.$editor = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
    }

    @Nullable
    public Separator getSeparator() {
        return this.separator;
    }

    public ReaderModeActionProvider(@Nullable Separator separator) {
        this.separator = separator;
    }

    public /* synthetic */ ReaderModeActionProvider(Separator separator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            separator = Separator.create();
        }
        this(separator);
    }

    public ReaderModeActionProvider() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        FOREGROUND = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
        ACTIONS_GREY_COLOR_KEY = ColorKey.createColorKey((String)"Actions.Grey", (Color)UIUtil.getContextHelpForeground());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/actions/ReaderModeActionProvider$Companion;", "", "()V", "ACTIONS_GREY_COLOR_KEY", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "getACTIONS_GREY_COLOR_KEY", "()Lcom/intellij/openapi/editor/colors/ColorKey;", "FOREGROUND", "getFOREGROUND", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final ColorKey getFOREGROUND() {
            return FOREGROUND;
        }

        @NotNull
        public final ColorKey getACTIONS_GREY_COLOR_KEY() {
            return ACTIONS_GREY_COLOR_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

