/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FileRecursiveIterator;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.core.CoreBundle;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SequentialTask;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(AbstractLayoutCodeProcessor.class);
    @NotNull
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private List<PsiFile> myFiles;
    private boolean myIncludeSubdirs;
    private final String myProgressText;
    private final String myCommandName;
    private Runnable myPostRunnable;
    private boolean myProcessChangedTextOnly;
    protected AbstractLayoutCodeProcessor myPreviousCodeProcessor;
    private List<VirtualFileFilter> myFilters = new ArrayList<VirtualFileFilter>();
    private LayoutCodeInfoCollector myInfoCollector;

    protected AbstractLayoutCodeProcessor(@NotNull Project project, String commandName, String progressText, boolean processChangedTextOnly) {
        this(project, (Module)null, commandName, progressText, processChangedTextOnly);
    }

    protected AbstractLayoutCodeProcessor(@NotNull AbstractLayoutCodeProcessor previous, @NotNull String commandName, @NotNull String progressText) {
        this.myProject = previous.myProject;
        this.myModule = previous.myModule;
        this.myDirectory = previous.myDirectory;
        this.myFile = previous.myFile;
        this.myFiles = previous.myFiles;
        this.myIncludeSubdirs = previous.myIncludeSubdirs;
        this.myProcessChangedTextOnly = previous.myProcessChangedTextOnly;
        this.myPostRunnable = null;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPreviousCodeProcessor = previous;
        this.myFilters = previous.myFilters;
        this.myInfoCollector = previous.myInfoCollector;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @Nullable Module module, String commandName, String progressText, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = module;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @NotNull PsiFile file2, String progressText, String commandName, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myFile = file2;
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, PsiFile @NotNull [] files2, String progressText, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this.myProject = project;
        this.myModule = null;
        this.myFiles = ContainerUtil.filter((Object[])files2, AbstractLayoutCodeProcessor::canBeFormatted);
        this.myProgressText = progressText;
        this.myCommandName = commandName;
        this.myPostRunnable = postRunnable;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    public void setPostRunnable(Runnable postRunnable) {
        this.myPostRunnable = postRunnable;
    }

    public void setCollectInfo(boolean isCollectInfo) {
        this.myInfoCollector = isCollectInfo ? new LayoutCodeInfoCollector() : null;
        AbstractLayoutCodeProcessor current2 = this;
        while (current2.myPreviousCodeProcessor != null) {
            current2 = current2.myPreviousCodeProcessor;
            current2.myInfoCollector = this.myInfoCollector;
        }
    }

    public void addFileFilter(@NotNull VirtualFileFilter filter2) {
        this.myFilters.add(filter2);
    }

    void setProcessChangedTextOnly(boolean value2) {
        this.myProcessChangedTextOnly = value2;
    }

    @NotNull
    protected abstract FutureTask<Boolean> prepareTask(@NotNull PsiFile var1, boolean var2) throws IncorrectOperationException;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public FutureTask<Boolean> preprocessFile(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        FutureTask<Boolean> previousTask = this.myPreviousCodeProcessor != null ? this.myPreviousCodeProcessor.preprocessFile(file2, processChangedTextOnly) : null;
        FutureTask<Boolean> currentTask = this.prepareTask(file2, processChangedTextOnly);
        return new FutureTask<Boolean>(() -> {
            try {
                if (previousTask != null) {
                    previousTask.run();
                    if (!((Boolean)previousTask.get()).booleanValue() || previousTask.isCancelled()) {
                        return false;
                    }
                }
                ApplicationManager.getApplication().runWriteAction((Runnable)currentTask);
                return (Boolean)currentTask.get() != false && !currentTask.isCancelled();
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
                throw e;
            }
        });
    }

    public void run() {
        if (this.myFile != null) {
            this.runProcessFile(this.myFile);
            return;
        }
        this.runProcessFiles();
    }

    @NotNull
    private FileRecursiveIterator build() {
        if (this.myFiles != null) {
            return new FileRecursiveIterator(this.myProject, this.myFiles);
        }
        if (this.myProcessChangedTextOnly) {
            return this.buildChangedFilesIterator();
        }
        if (this.myDirectory != null) {
            return new FileRecursiveIterator(this.myDirectory);
        }
        if (this.myModule != null) {
            return new FileRecursiveIterator(this.myModule);
        }
        return new FileRecursiveIterator(this.myProject);
    }

    @NotNull
    private FileRecursiveIterator buildChangedFilesIterator() {
        List<PsiFile> files2 = this.getChangedFilesFromContext();
        return new FileRecursiveIterator(this.myProject, files2);
    }

    @NotNull
    private List<PsiFile> getChangedFilesFromContext() {
        List<PsiDirectory> dirs = this.getAllSearchableDirsFromContext();
        return VcsFacade.getInstance().getChangedFilesFromDirs(this.myProject, dirs);
    }

    private List<PsiDirectory> getAllSearchableDirsFromContext() {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        if (this.myDirectory != null) {
            dirs.add(this.myDirectory);
        } else if (this.myModule != null) {
            List<PsiDirectory> allModuleDirs = FileRecursiveIterator.collectModuleDirectories(this.myModule);
            dirs.addAll(allModuleDirs);
        } else {
            List<PsiDirectory> allProjectDirs = FileRecursiveIterator.collectProjectDirectories(this.myProject);
            dirs.addAll(allProjectDirs);
        }
        return dirs;
    }

    private void runProcessFile(final @NotNull PsiFile file2) {
        PsiUtilCore.ensureValid((PsiElement)file2);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file2.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myCommandName, true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText(AbstractLayoutCodeProcessor.this.myProgressText);
                try {
                    new ReformatFilesTask(indicator).performFileProcessing(file2);
                }
                catch (IndexNotReadyException e) {
                    LOG.warn((Throwable)e);
                    return;
                }
                if (AbstractLayoutCodeProcessor.this.myPostRunnable != null) {
                    ApplicationManager.getApplication().invokeLater(AbstractLayoutCodeProcessor.this.myPostRunnable);
                }
            }
        });
    }

    private void runProcessFiles() {
        boolean isSuccess = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            return this.processFilesUnderProgress(indicator);
        }, this.myCommandName, true, this.myProject);
        if (isSuccess && this.myPostRunnable != null) {
            this.myPostRunnable.run();
        }
    }

    private static boolean canBeFormatted(@NotNull PsiFile file2) {
        if (!file2.isValid()) {
            return false;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        return !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)file2.getProject());
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        new ReformatFilesTask((ProgressIndicator)new EmptyProgressIndicator()).performFileProcessing(this.myFile);
    }

    public boolean processFilesUnderProgress(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        ReformatFilesTask task2 = new ReformatFilesTask(indicator);
        return task2.process();
    }

    @NotNull
    private List<AbstractLayoutCodeProcessor> getAllProcessors() {
        AbstractLayoutCodeProcessor current2 = this;
        ArrayList<AbstractLayoutCodeProcessor> all = new ArrayList<AbstractLayoutCodeProcessor>();
        while (current2 != null) {
            all.add(current2);
            current2 = current2.myPreviousCodeProcessor;
        }
        Collections.reverse(all);
        return all;
    }

    private boolean acceptedByFilters(@NotNull PsiFile file2) {
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        for (VirtualFileFilter filter2 : this.myFilters) {
            if (filter2.accept(file2.getVirtualFile())) continue;
            return false;
        }
        return true;
    }

    static List<TextRange> getSelectedRanges(@NotNull SelectionModel selectionModel) {
        SmartList ranges = new SmartList();
        if (selectionModel.hasSelection()) {
            TextRange range2 = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            ranges.add(range2);
        }
        return ranges;
    }

    void handleFileTooBigException(Logger logger, FilesTooBigForDiffException e, @NotNull PsiFile file2) {
        logger.info("Error while calculating changed ranges for: " + file2.getVirtualFile(), (Throwable)e);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Reformat changed text", (String)ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.groupId", (Object[])new Object[0])), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.title", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.text", (Object[])new Object[]{file2.getName()}), NotificationType.INFORMATION);
            notification.notify(file2.getProject());
        }
    }

    @Nullable
    public LayoutCodeInfoCollector getInfoCollector() {
        return this.myInfoCollector;
    }

    private class ReformatFilesTask
    implements SequentialTask {
        private final List<AbstractLayoutCodeProcessor> myProcessors;
        private final FileRecursiveIterator myFileTreeIterator = (FileRecursiveIterator)ReadAction.compute(() -> AbstractLayoutCodeProcessor.access$1000(AbstractLayoutCodeProcessor.this));
        private final FileRecursiveIterator myCountingIterator = (FileRecursiveIterator)ReadAction.compute(() -> AbstractLayoutCodeProcessor.access$1000(AbstractLayoutCodeProcessor.this));
        private final ProgressIndicator myProgressIndicator;
        private int myTotalFiles;
        private int myFilesProcessed;
        private boolean myStopFormatting;
        private PsiFile next;

        ReformatFilesTask(ProgressIndicator indicator) {
            this.myProcessors = AbstractLayoutCodeProcessor.this.getAllProcessors();
            this.myProgressIndicator = indicator;
        }

        public boolean isDone() {
            return this.myStopFormatting;
        }

        private void countingIteration() {
            ++this.myTotalFiles;
        }

        public boolean iteration() {
            if (this.myStopFormatting) {
                return true;
            }
            this.updateIndicatorFraction(this.myFilesProcessed);
            if (this.next != null) {
                PsiFile file2 = this.next;
                ++this.myFilesProcessed;
                if (this.shouldProcessFile(file2).booleanValue()) {
                    this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.process.progress.text", (Object[])new Object[0]), this.getPresentablePath(file2));
                    DumbService.getInstance((Project)AbstractLayoutCodeProcessor.this.myProject).withAlternativeResolveEnabled(() -> this.performFileProcessing(file2));
                }
            }
            return true;
        }

        private Boolean shouldProcessFile(PsiFile file2) {
            return (Boolean)ReadAction.compute(() -> file2.isWritable() && AbstractLayoutCodeProcessor.canBeFormatted(file2) && AbstractLayoutCodeProcessor.this.acceptedByFilters(file2));
        }

        private void performFileProcessing(@NotNull PsiFile file2) {
            String groupId2 = AbstractLayoutCodeProcessor.this.toString();
            for (AbstractLayoutCodeProcessor processor2 : this.myProcessors) {
                FutureTask writeTask = (FutureTask)ReadAction.compute(() -> processor2.prepareTask(file2, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly));
                ProgressIndicatorProvider.checkCanceled();
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.runWriteCommandAction((Project)AbstractLayoutCodeProcessor.this.myProject, (String)AbstractLayoutCodeProcessor.this.myCommandName, (String)groupId2, (Runnable)writeTask, (PsiFile[])new PsiFile[0]));
                this.checkStop(writeTask, file2);
            }
        }

        private void checkStop(FutureTask<Boolean> task2, PsiFile file2) {
            try {
                if (!task2.get().booleanValue() || task2.isCancelled()) {
                    this.myStopFormatting = true;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IndexNotReadyException) {
                    LOG.warn(cause);
                    return;
                }
                LOG.error("Got unexpected exception during formatting " + file2, (Throwable)e);
            }
        }

        private void updateIndicatorText(@NotNull String upperLabel, @NotNull String downLabel) {
            this.myProgressIndicator.setText(upperLabel);
            this.myProgressIndicator.setText2(downLabel);
        }

        private String getPresentablePath(@NotNull PsiFile file2) {
            VirtualFile vFile = file2.getVirtualFile();
            return vFile != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)AbstractLayoutCodeProcessor.this.myProject) : file2.getName();
        }

        private void updateIndicatorFraction(int processed2) {
            this.myProgressIndicator.setFraction((double)processed2 / (double)this.myTotalFiles);
        }

        public void stop() {
            this.myStopFormatting = true;
        }

        private boolean process() {
            this.myCountingIterator.processAll((Processor<? super PsiFile>)((Processor)file2 -> {
                this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.prepare.progress.text", (Object[])new Object[0]), "");
                this.countingIteration();
                return !this.isDone();
            }));
            return this.myFileTreeIterator.processAll((Processor<? super PsiFile>)((Processor)file2 -> {
                this.next = file2;
                this.iteration();
                return !this.isDone();
            }));
        }
    }
}

