/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    static final LanguageExtension<TargetElementEvaluator> TARGET_ELEMENT_EVALUATOR = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static int adjustOffset(@Nullable PsiFile file2, @NotNull Document document, int offset) {
        char charAt;
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtilBase.isIdentifierPart(file2, text, offset)) {
            --correctedOffset;
        }
        if (correctedOffset >= 0 && ((charAt = text.charAt(correctedOffset)) == '\'' || charAt == '\"' || charAt == ')' || charAt == ']' || TargetElementUtilBase.isIdentifierPart(file2, text, correctedOffset))) {
            return correctedOffset;
        }
        return offset;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file2, @NotNull CharSequence text, int offset) {
        TargetElementEvaluatorEx evaluator;
        if (file2 != null && (evaluator = TargetElementUtilBase.getElementEvaluatorsEx(file2.getLanguage())) != null && evaluator.isIdentifierPart(file2, text, offset)) {
            return true;
        }
        return Character.isJavaIdentifierPart(text.charAt(offset));
    }

    @Nullable
    private static TargetElementEvaluatorEx getElementEvaluatorsEx(@NotNull Language language) {
        TargetElementEvaluator result2 = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language);
        return result2 instanceof TargetElementEvaluatorEx ? (TargetElementEvaluatorEx)result2 : null;
    }

    @Nullable
    static TargetElementEvaluatorEx2 getElementEvaluatorsEx2(@NotNull Language language) {
        TargetElementEvaluator result2 = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language);
        return result2 instanceof TargetElementEvaluatorEx2 ? (TargetElementEvaluatorEx2)result2 : null;
    }

    @ApiStatus.Internal
    static PsiElement getNamedElement(@Nullable PsiElement element2) {
        PsiElement result2;
        if (element2 == null) {
            return null;
        }
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(element2.getLanguage());
        if (evaluator != null && (result2 = evaluator.getNamedElement(element2)) != null) {
            return result2;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element2, PsiNamedElement.class, (boolean)false);
        if (parent != null && !(parent instanceof PsiFile) && parent.getTextOffset() == element2.getTextRange().getStartOffset() && (evaluator == null || evaluator.isAcceptableNamedParent(parent))) {
            return parent;
        }
        return null;
    }

    public static PsiElement getNamedElement(@Nullable PsiElement element2, int offsetInElement) {
        if (element2 == null) {
            return null;
        }
        PsiUtilCore.ensureValid((PsiElement)element2);
        ArrayList targets2 = new ArrayList();
        Consumer consumer = target2 -> {
            if (target2 instanceof PsiDeclaredTarget) {
                PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target2;
                PsiElement navigationElement = declaredTarget.getNavigationElement();
                TextRange range2 = declaredTarget.getNameIdentifierRange();
                if (range2 != null && !range2.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element2.getTextRange().getStartOffset() + offsetInElement)) {
                    return;
                }
            }
            targets2.add(target2);
        };
        int offset = offsetInElement;
        for (PsiElement parent = element2; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, consumer);
                if (targets2.isEmpty()) continue;
                PomTarget target3 = (PomTarget)targets2.get(0);
                return target3 == null ? null : PomService.convertToPsi((Project)element2.getProject(), (PomTarget)target3);
            }
            offset += parent.getStartOffsetInParent();
        }
        return TargetElementUtilBase.getNamedElement(element2);
    }

    @Nullable
    private static PsiElement doGetReferenceOrReferencedElement(@NotNull Editor editor, int flags, int offset) {
        PsiReference ref = TargetElementUtilBase.findReference(editor, offset);
        if (ref == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        return TargetElementUtilBase.getReferencedElement(ref, flags);
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiReference ref, int flags) {
        PsiElement element2;
        Language language = ref.getElement().getLanguage();
        TargetElementEvaluator evaluator = (TargetElementEvaluator)TARGET_ELEMENT_EVALUATOR.forLanguage(language);
        if (evaluator != null && (element2 = evaluator.getElementByReference(ref, flags)) != null) {
            return element2;
        }
        return ref.resolve();
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor, int offset) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        PsiReference ref = file2.findReferenceAt(TargetElementUtilBase.adjustOffset(file2, document, offset));
        if (ref == null) {
            return null;
        }
        int elementOffset = ref.getElement().getTextRange().getStartOffset();
        for (TextRange range2 : ReferenceRange.getRanges((PsiReference)ref)) {
            if (!range2.shiftRight(elementOffset).containsOffset(offset)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferenceOrReferencedElement(@NotNull PsiFile file2, @NotNull Editor editor, int flags, int offset) {
        PsiElement result2 = TargetElementUtilBase.doGetReferenceOrReferencedElement(editor, flags, offset);
        PsiElement languageElement = file2.findElementAt(offset);
        Language language = languageElement != null ? languageElement.getLanguage() : file2.getLanguage();
        TargetElementEvaluatorEx2 evaluator = TargetElementUtilBase.getElementEvaluatorsEx2(language);
        if (evaluator != null) {
            result2 = evaluator.adjustReferenceOrReferencedElement(file2, editor, offset, flags, result2);
        }
        return result2;
    }

    @Nullable
    private static PsiElement doFindTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement referencedElement;
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        int adjusted = TargetElementUtilBase.adjustOffset(file2, document, offset);
        PsiElement element2 = file2.findElementAt(adjusted);
        if (BitUtil.isSet((int)flags, (int)1) && (referencedElement = TargetElementUtilBase.getReferencedElement(file2, offset, flags, editor, element2)) != null) {
            return referencedElement;
        }
        if (element2 == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            if (element2 instanceof PsiNamedElement) {
                return element2;
            }
            return TargetElementUtilBase.getNamedElement(element2, adjusted - element2.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getReferencedElement(@NotNull PsiFile file2, int offset, int flags, @NotNull Editor editor, @Nullable PsiElement leafElement) {
        PsiElement referenceOrReferencedElement = TargetElementUtilBase.getReferenceOrReferencedElement(file2, editor, flags, offset);
        if (TargetElementUtilBase.isAcceptableReferencedElement(leafElement, referenceOrReferencedElement)) {
            return referenceOrReferencedElement;
        }
        return null;
    }

    static boolean isAcceptableReferencedElement(@Nullable PsiElement element2, @Nullable PsiElement referenceOrReferencedElement) {
        TargetElementEvaluatorEx2 evaluator;
        if (referenceOrReferencedElement == null || !referenceOrReferencedElement.isValid()) {
            return false;
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = element2 != null ? TargetElementUtilBase.getElementEvaluatorsEx2(element2.getLanguage()) : null;
        if (evaluator != null) {
            ThreeState answer = evaluator.isAcceptableReferencedElement(element2, referenceOrReferencedElement);
            if (answer == ThreeState.YES) {
                return true;
            }
            if (answer == ThreeState.NO) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor, int flags) {
        int offset = editor.getCaretModel().getOffset();
        return TargetElementUtilBase.findTargetElement(editor, flags, offset);
    }

    @Nullable
    public static PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        TargetElementEvaluatorEx2 evaluator;
        PsiElement result2 = TargetElementUtilBase.doFindTargetElement(editor, flags, offset);
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator = result2 != null ? TargetElementUtilBase.getElementEvaluatorsEx2(result2.getLanguage()) : null;
        if (evaluator != null) {
            result2 = evaluator.adjustTargetElement(editor, offset, flags, result2);
        }
        return result2;
    }
}

