/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.xmlb.annotations.OptionTag;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="CodeInsightWorkspaceSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class CodeInsightWorkspaceSettings
extends SimpleModificationTracker
implements PersistentStateComponent<CodeInsightWorkspaceSettings> {
    @OptionTag
    @Deprecated
    public boolean optimizeImportsOnTheFly;

    public static CodeInsightWorkspaceSettings getInstance(@NotNull Project project) {
        return (CodeInsightWorkspaceSettings)((Object)project.getService(CodeInsightWorkspaceSettings.class));
    }

    public boolean isOptimizeImportsOnTheFly() {
        return this.optimizeImportsOnTheFly;
    }

    public void setOptimizeImportsOnTheFly(boolean value2) {
        if (this.optimizeImportsOnTheFly != value2) {
            this.optimizeImportsOnTheFly = value2;
            this.incModificationCount();
        }
    }

    public void setOptimizeImportsOnTheFly(boolean optimizeImportsOnTheFly, Disposable parentDisposable) {
        boolean prev = this.optimizeImportsOnTheFly;
        this.optimizeImportsOnTheFly = optimizeImportsOnTheFly;
        Disposer.register((Disposable)parentDisposable, () -> {
            this.optimizeImportsOnTheFly = prev;
        });
    }

    public void noStateLoaded() {
        this.optimizeImportsOnTheFly = CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY;
        this.incModificationCount();
    }

    public void loadState(@NotNull CodeInsightWorkspaceSettings state) {
        this.optimizeImportsOnTheFly = state.optimizeImportsOnTheFly;
    }

    @NotNull
    public CodeInsightWorkspaceSettings getState() {
        return this;
    }
}

