/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoPopupControllerImpl
extends AutoPopupController {
    private final Project myProject;
    private final Alarm myAlarm;

    public AutoPopupControllerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myAlarm = new Alarm((Disposable)this.myProject);
        this.setupListeners();
    }

    private void setupListeners() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                AutoPopupControllerImpl.this.cancelAllRequests();
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                AutoPopupControllerImpl.this.cancelAllRequests();
            }
        });
        IdeEventQueue.getInstance().addActivityListener(this::cancelAllRequests, (Disposable)this.myProject);
    }

    @Override
    public void autoPopupMemberLookup(Editor editor, @Nullable Condition<? super PsiFile> condition) {
        this.autoPopupMemberLookup(editor, CompletionType.BASIC, condition);
    }

    @Override
    public void autoPopupMemberLookup(Editor editor, CompletionType completionType, @Nullable Condition<? super PsiFile> condition) {
        this.scheduleAutoPopup(editor, completionType, condition);
    }

    @Override
    public void scheduleAutoPopup(@NotNull Editor editor, @NotNull CompletionType completionType, @Nullable Condition<? super PsiFile> condition) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            return;
        }
        boolean alwaysAutoPopup = Boolean.TRUE.equals(editor.getUserData(ALWAYS_AUTO_POPUP));
        if (!CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && !alwaysAutoPopup) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        if (!CompletionServiceImpl.isPhase(CompletionPhase.CommittingDocuments.class, CompletionPhase.NoCompletion.getClass(), CompletionPhase.EmptyAutoPopup.class)) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (currentCompletion != null) {
            currentCompletion.closeAndFinish(true);
        }
        CompletionPhase.CommittingDocuments.scheduleAsyncCompletion(editor, completionType, condition, this.myProject, null);
    }

    @Override
    public void scheduleAutoPopup(Editor editor) {
        this.scheduleAutoPopup(editor, CompletionType.BASIC, null);
    }

    private void addRequest(Runnable request2, int delay) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myAlarm.isDisposed()) {
                this.myAlarm.addRequest(request2, delay);
            }
        });
    }

    @Override
    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    @Override
    public void autoPopupParameterInfo(@NotNull Editor editor, @Nullable PsiElement highlightedMethod) {
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_PARAMETER_INFO) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file2 = documentManager.getPsiFile(editor.getDocument());
            if (file2 == null) {
                return;
            }
            if (!documentManager.isUncommited(editor.getDocument()) && (file2 = documentManager.getPsiFile(InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file2).getDocument())) == null) {
                return;
            }
            Runnable request2 = () -> {
                if (!this.myProject.isDisposed() && !DumbService.isDumb((Project)this.myProject) && !editor.isDisposed() && EditorActivityManager.getInstance().isVisible(editor)) {
                    int lbraceOffset = editor.getCaretModel().getOffset() - 1;
                    try {
                        PsiFile file1 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                        if (file1 != null) {
                            ShowParameterInfoHandler.invoke(this.myProject, editor, file1, lbraceOffset, highlightedMethod, false, true, null, e -> {});
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            };
            this.addRequest(() -> documentManager.performLaterWhenAllCommitted(request2), settings.PARAMETER_INFO_DELAY);
        }
    }

    @Override
    public void waitForDelayedActions(long timeout, @NotNull TimeUnit unit) throws TimeoutException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < deadline) {
            UIUtil.dispatchAllInvocationEvents();
            if (this.myAlarm.isEmpty()) {
                return;
            }
            LockSupport.parkNanos(10000000L);
        }
        throw new TimeoutException();
    }
}

