/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorHighlightingPass
implements HighlightingPass {
    public static final TextEditorHighlightingPass[] EMPTY_ARRAY = new TextEditorHighlightingPass[0];
    @NotNull
    protected final Document myDocument;
    @NotNull
    protected final Project myProject;
    private final boolean myRunIntentionPassAfter;
    private final long myInitialDocStamp;
    private final long myInitialPsiStamp;
    private volatile int[] myCompletionPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
    private volatile int[] myStartingPredecessorIds = ArrayUtilRt.EMPTY_INT_ARRAY;
    private volatile int myId;
    private volatile boolean myDumb;
    private EditorColorsScheme myColorsScheme;

    protected TextEditorHighlightingPass(@NotNull Project project, @NotNull Document document, boolean runIntentionPassAfter) {
        this.myDocument = document;
        this.myProject = project;
        this.myRunIntentionPassAfter = runIntentionPassAfter;
        this.myInitialDocStamp = document.getModificationStamp();
        this.myInitialPsiStamp = PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount();
    }

    protected TextEditorHighlightingPass(@NotNull Project project, @NotNull Document document) {
        this(project, document, true);
    }

    public final void collectInformation(@NotNull ProgressIndicator progress2) {
        if (!this.isValid()) {
            return;
        }
        GlobalInspectionContextBase.assertUnderDaemonProgress();
        this.myDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.doCollectInformation(progress2);
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    public void setColorsScheme(@Nullable EditorColorsScheme colorsScheme) {
        this.myColorsScheme = colorsScheme;
    }

    protected boolean isDumbMode() {
        return this.myDumb;
    }

    protected boolean isValid() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.isDumbMode() && !DumbService.isDumbAware((Object)this)) {
            return false;
        }
        if (PsiModificationTracker.SERVICE.getInstance((Project)this.myProject).getModificationCount() != this.myInitialPsiStamp) {
            return false;
        }
        if (this.myDocument.getModificationStamp() != this.myInitialDocStamp) {
            return false;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        return file2 != null && file2.isValid();
    }

    public final void applyInformationToEditor() {
        if (!this.isValid()) {
            return;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !DumbService.isDumbAware((Object)this)) {
            Document document = this.getDocument();
            PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (file2 != null) {
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.getDocument(), this.getId());
            }
            return;
        }
        this.doApplyInformationToEditor();
    }

    public abstract void doCollectInformation(@NotNull ProgressIndicator var1);

    public abstract void doApplyInformationToEditor();

    public final int getId() {
        return this.myId;
    }

    public final void setId(int id2) {
        this.myId = id2;
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        return Collections.emptyList();
    }

    public final int @NotNull [] getCompletionPredecessorIds() {
        return this.myCompletionPredecessorIds;
    }

    public final void setCompletionPredecessorIds(int @NotNull [] completionPredecessorIds) {
        this.myCompletionPredecessorIds = completionPredecessorIds;
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    public final int @NotNull [] getStartingPredecessorIds() {
        return this.myStartingPredecessorIds;
    }

    public final void setStartingPredecessorIds(int @NotNull [] startingPredecessorIds) {
        this.myStartingPredecessorIds = startingPredecessorIds;
    }

    @NonNls
    public String toString() {
        return (this.getClass().isAnonymousClass() ? this.getClass().getSuperclass() : this.getClass()).getSimpleName() + "; id=" + this.getId();
    }

    public boolean isRunIntentionPassAfter() {
        return this.myRunIntentionPassAfter;
    }
}

