/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLDialog;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExportToHTMLManager {
    private static final Logger LOG = Logger.getInstance(ExportToHTMLManager.class);
    private FileNotFoundException myLastException;

    ExportToHTMLManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void executeExport(@NotNull DataContext dataContext) throws FileNotFoundException {
        block21: {
            block20: {
                psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
                psiDirectory = null;
                if (psiFile != null) {
                    psiDirectory = psiFile.getContainingDirectory();
                } else {
                    psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                    if (psiElement instanceof PsiDirectory) {
                        psiDirectory = (PsiDirectory)psiElement;
                    }
                }
                editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                v0 = psiDirectory != null ? psiDirectory.getProject() : (project = editor != null ? editor.getProject() : (Project)CommonDataKeys.PROJECT.getData(dataContext));
                if (project == null) {
                    return;
                }
                shortFileName = null;
                directoryName = null;
                if (psiFile != null || psiDirectory != null) {
                    if (psiFile != null) {
                        shortFileName = psiFile.getVirtualFile().getName();
                        if (psiDirectory == null) {
                            psiDirectory = psiFile.getContainingDirectory();
                        }
                    }
                    if (psiDirectory != null) {
                        directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
                    }
                }
                isSelectedTextEnabled = editor != null && editor.getSelectionModel().hasSelection() != false;
                exportToHTMLDialog = new ExportToHTMLDialog(shortFileName, directoryName, isSelectedTextEnabled, project);
                exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
                if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
                    baseDir = Objects.requireNonNull(project).getBasePath();
                    exportToHTMLSettings.OUTPUT_DIRECTORY = baseDir != null ? baseDir + File.separator + "exportToHTML" : "";
                }
                exportToHTMLDialog.reset();
                if (!exportToHTMLDialog.showAndGet()) {
                    return;
                }
                try {
                    exportToHTMLDialog.apply();
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
                try {
                    if (exportToHTMLSettings.getPrintScope() == 4) ** GOTO lbl62
                    if (psiFile != null && psiFile.getText() != null) break block20;
                }
                catch (Throwable var15_19) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(outputDirectoryName)});
                    throw var15_19;
                }
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(outputDirectoryName)});
                return;
            }
            dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            textPainter = new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS);
            if (exportToHTMLSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine);
            }
            try {
                htmlFile = ExportToHTMLManager.doPaint(dirName, textPainter, null);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((String)htmlFile);
                }
                break block21;
            }
            catch (IOException e) {
                ExportToHTMLManager.LOG.error((Throwable)e);
            }
            break block21;
lbl62:
            // 1 sources

            this.myLastException = null;
            exportRunnable = new ExportRunnable(exportToHTMLSettings, psiDirectory, outputDirectoryName, project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)exportRunnable, EditorBundle.message((String)"export.to.html.title", (Object[])new Object[0]), true, project);
            if (this.myLastException != null) {
                throw this.myLastException;
            }
        }
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (File[])new File[]{new File(outputDirectoryName)});
    }

    @NotNull
    protected static String doPaint(@NotNull String dirName, @NotNull HTMLTextPainter textPainter, @Nullable Int2ObjectRBTreeMap<PsiReference> refMap) throws IOException {
        String htmlFile = dirName + File.separator + ExportToHTMLManager.getHTMLFileName(textPainter.getPsiFile());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), StandardCharsets.UTF_8);){
            textPainter.paint(refMap, writer, true);
        }
        return htmlFile;
    }

    private boolean exportPsiFile(PsiFile psiFile, String outputDirectoryName, Project project, HashMap<PsiFile, PsiFile> filesMap) {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            Int2ObjectRBTreeMap refMap = null;
            for (PrintOption printOption : PrintOption.EP_NAME.getExtensionList()) {
                TreeMap<Integer, PsiReference> map2 = printOption.collectReferences(psiFile, filesMap);
                if (map2 == null) continue;
                refMap = new Int2ObjectRBTreeMap(map2);
            }
            String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            try {
                ExportToHTMLManager.doPaint(dirName, new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS), refMap);
            }
            catch (FileNotFoundException e) {
                this.myLastException = e;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
        return this.myLastException == null;
    }

    private static String constructOutputDirectory(PsiFile psiFile, String outputDirectoryName) {
        return ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outputDirectoryName);
    }

    private static String constructOutputDirectory(@NotNull PsiDirectory directory, String outputDirectoryName) {
        String qualifiedName = PsiDirectoryFactory.getInstance(directory.getProject()).getQualifiedName(directory, false);
        String dirName = outputDirectoryName;
        if (!qualifiedName.isEmpty()) {
            dirName = dirName + File.separator + qualifiedName.replace('.', File.separatorChar);
        }
        File dir = new File(dirName);
        dir.mkdirs();
        return dirName;
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, List<? super PsiFile> filesList, boolean isRecursive, String outputDirectoryName) throws FileNotFoundException {
        if (!psiDirectory.isValid()) {
            return;
        }
        PsiFile[] files2 = psiDirectory.getFiles();
        Collections.addAll(filesList, files2);
        ExportToHTMLManager.generateIndexHtml(psiDirectory, isRecursive, outputDirectoryName);
        if (isRecursive) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = psiDirectory.getSubdirectories()) {
                ExportToHTMLManager.addToPsiFileList(directory, filesList, true, outputDirectoryName);
            }
        }
    }

    private static void generateIndexHtml(PsiDirectory psiDirectory, boolean recursive, String outputDirectoryName) throws FileNotFoundException {
        String indexHtmlName = ExportToHTMLManager.constructOutputDirectory(psiDirectory, outputDirectoryName) + File.separator + "index.html";
        String title = PsiDirectoryFactory.getInstance(psiDirectory.getProject()).getQualifiedName(psiDirectory, true);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexHtmlName), StandardCharsets.UTF_8);){
            writer.write("<html><head><title>" + title + "</title></head><body>");
            if (recursive) {
                PsiDirectory[] directories;
                for (PsiDirectory psiDirectory2 : directories = psiDirectory.getSubdirectories()) {
                    writer.write("<a href=\"" + psiDirectory2.getName() + "/index.html\"><b>" + psiDirectory2.getName() + "</b></a><br />");
                }
            }
            PsiFile[] files2 = psiDirectory.getFiles();
            for (PsiDirectory psiDirectory3 : files2) {
                if (psiDirectory3 instanceof PsiBinaryFile) continue;
                writer.write("<a href=\"" + ExportToHTMLManager.getHTMLFileName((PsiFile)psiDirectory3) + "\">" + psiDirectory3.getVirtualFile().getName() + "</a><br />");
            }
            writer.write("</body></html>");
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    static String getHTMLFileName(PsiFile psiFile) {
        return psiFile.getVirtualFile().getName() + ".html";
    }

    private class ExportRunnable
    implements Runnable {
        private final ExportToHTMLSettings myExportToHTMLSettings;
        private final PsiDirectory myPsiDirectory;
        private final String myOutputDirectoryName;
        private final Project myProject;

        ExportRunnable(ExportToHTMLSettings exportToHTMLSettings, PsiDirectory psiDirectory, String outputDirectoryName, Project project) {
            this.myExportToHTMLSettings = exportToHTMLSettings;
            this.myPsiDirectory = psiDirectory;
            this.myOutputDirectoryName = outputDirectoryName;
            this.myProject = project;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
            ArrayList filesList = new ArrayList();
            boolean isRecursive = this.myExportToHTMLSettings.isIncludeSubdirectories();
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    ExportToHTMLManager.addToPsiFileList(this.myPsiDirectory, filesList, isRecursive, this.myOutputDirectoryName);
                }
                catch (FileNotFoundException e) {
                    ExportToHTMLManager.this.myLastException = e;
                }
            });
            if (ExportToHTMLManager.this.myLastException != null) {
                return;
            }
            HashMap<PsiFile, PsiFile> filesMap = new HashMap<PsiFile, PsiFile>();
            for (PsiFile psiFile : filesList) {
                filesMap.put(psiFile, psiFile);
            }
            for (int i2 = 0; i2 < filesList.size(); ++i2) {
                PsiFile psiFile;
                psiFile = (PsiFile)filesList.get(i2);
                if (progressIndicator2.isCanceled()) {
                    return;
                }
                progressIndicator2.setText(EditorBundle.message((String)"export.to.html.generating.file.progress", (Object[])new Object[]{ExportToHTMLManager.getHTMLFileName(psiFile)}));
                progressIndicator2.setFraction((double)i2 / (double)filesList.size());
                if (ExportToHTMLManager.this.exportPsiFile(psiFile, this.myOutputDirectoryName, this.myProject, filesMap)) continue;
                return;
            }
            if (this.myExportToHTMLSettings.OPEN_IN_BROWSER) {
                String dirToShow = this.myExportToHTMLSettings.OUTPUT_DIRECTORY;
                if (!dirToShow.endsWith(File.separator)) {
                    dirToShow = dirToShow + File.separatorChar;
                }
                dirToShow = dirToShow + PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiDirectory, false).replace('.', File.separatorChar);
                BrowserUtil.browse((String)dirToShow);
            }
        }
    }
}

