/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.progress;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.build.progress.BuildProgressImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class BuildRootProgressImpl
extends BuildProgressImpl {
    private final BuildProgressListener myListener;

    public BuildRootProgressImpl(BuildProgressListener buildProgressListener) {
        super(buildProgressListener, null);
        this.myListener = buildProgressListener;
    }

    @Override
    @NotNull
    public Object getId() {
        return this.getBuildId();
    }

    @Override
    @NotNull
    protected StartEvent createStartEvent(BuildProgressDescriptor descriptor2) {
        return new StartBuildEventImpl(descriptor2.getBuildDescriptor(), BuildBundle.message("build.status.running", new Object[0]));
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish() {
        return this.finish(System.currentTimeMillis(), false, BuildBundle.message("build.status.finished", new Object[0]));
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(long timeStamp, boolean isUpToDate, @NotNull @BuildEventsNls.Message String message) {
        this.assertStarted();
        FinishBuildEventImpl event = new FinishBuildEventImpl(this.getId(), null, timeStamp, message, (EventResult)new SuccessResultImpl(isUpToDate));
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fail() {
        return this.fail(System.currentTimeMillis(), BuildBundle.message("build.status.failed", new Object[0]));
    }

    @NotNull
    public BuildRootProgressImpl fail(long timeStamp, @NotNull @BuildEventsNls.Message String message) {
        this.assertStarted();
        FinishBuildEventImpl event = new FinishBuildEventImpl(this.getId(), null, timeStamp, message, (EventResult)new FailureResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> cancel() {
        return this.cancel(System.currentTimeMillis(), BuildBundle.message("build.status.cancelled", new Object[0]));
    }

    @NotNull
    public BuildRootProgressImpl cancel(long timeStamp, @NotNull String message) {
        this.assertStarted();
        FinishBuildEventImpl event = new FinishBuildEventImpl(this.getId(), null, timeStamp, message, (EventResult)new SkippedResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }
}

