/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(ViewManager.class);
    private static final Key<Boolean> PINNED_EXTRACTED_CONTENT = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> myBuildsViewValue;
    private final Set<MultipleBuildsView> myPinnedViews;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    private final Map<Object, Object> idsMap = new ConcurrentHashMap<Object, Object>();
    private final DisposableWrapperList<BuildProgressListener> myListeners = new DisposableWrapperList();

    public AbstractViewManager(Project project) {
        this.myProject = project;
        this.myBuildContentManager = (BuildContentManager)project.getService(BuildContentManager.class);
        this.myBuildsViewValue = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView buildsView = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                Disposer.register((Disposable)AbstractViewManager.this, (Disposable)buildsView);
                return buildsView;
            }
        };
        this.myPinnedViews = ContainerUtil.newConcurrentSet();
    }

    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    public boolean isBuildContentView() {
        return true;
    }

    @ApiStatus.Experimental
    public void addListener(@NotNull BuildProgressListener listener2, @NotNull Disposable disposable2) {
        this.myListeners.add((Object)listener2, disposable2);
    }

    @NotNull
    protected abstract @NlsContexts.TabTitle String getViewName();

    protected Map<BuildDescriptor, BuildView> getBuildsMap() {
        return ((MultipleBuildsView)this.myBuildsViewValue.getValue()).getBuildsMap();
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        MultipleBuildsView buildsView;
        if (this.isDisposed.get()) {
            return;
        }
        if (buildId == UNKNOWN_BUILD_ID) {
            Object buildIdCandidate;
            Object object = buildIdCandidate = event instanceof StartBuildEvent ? event.getId() : this.idsMap.get(ObjectUtils.notNull((Object)event.getParentId(), (Object)event.getId()));
            if (buildIdCandidate == null) {
                return;
            }
            buildId = buildIdCandidate;
            if (event instanceof StartEvent) {
                this.idsMap.put(event.getId(), buildId);
            }
        }
        if (event instanceof StartBuildEvent) {
            this.configurePinnedContent();
            buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        } else {
            buildsView = this.getMultipleBuildsView(buildId);
        }
        if (buildsView != null) {
            buildsView.onEvent(buildId, event);
        }
        for (BuildProgressListener listener2 : this.myListeners) {
            try {
                listener2.onEvent(buildId, event);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @Nullable
    private MultipleBuildsView getMultipleBuildsView(@NotNull Object buildId) {
        MultipleBuildsView buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        if (!buildsView.shouldConsume(buildId)) {
            buildsView = this.myPinnedViews.stream().filter(pinnedView -> pinnedView.shouldConsume(buildId)).findFirst().orElse(null);
        }
        return buildsView;
    }

    @ApiStatus.Internal
    @Nullable
    public BuildView getBuildView(@NotNull Object buildId) {
        MultipleBuildsView buildsView = this.getMultipleBuildsView(buildId);
        if (buildsView == null) {
            return null;
        }
        return buildsView.getBuildView(buildId);
    }

    void configureToolbar(@NotNull DefaultActionGroup toolbarActions, @NotNull MultipleBuildsView buildsView, @NotNull BuildView view) {
        toolbarActions.removeAll();
        toolbarActions.addAll(view.createConsoleActions());
        toolbarActions.add((AnAction)new PinBuildViewAction(buildsView));
        toolbarActions.add((AnAction)BuildTreeFilters.createFilteringActionsGroup(view));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        this.clearIdsOf(Collections.singleton(buildDescriptor));
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean activate2 = buildInfo.isActivateToolWindowWhenFailed();
            this.myBuildContentManager.setSelectedContent(buildInfo.content, false, false, activate2, null);
            List failures = ((FailureResult)buildInfo.result).getFailures();
            if (failures.isEmpty()) {
                return;
            }
            Failure failure = (Failure)failures.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String title = notification.getTitle();
                String content2 = notification.getContent();
                SystemNotifications.getInstance().notify(UIBundle.message((String)"tool.window.name.build", (Object[])new Object[0]), title, content2);
            }
        }
    }

    public void dispose() {
        this.isDisposed.set(true);
        this.myPinnedViews.clear();
        this.myBuildsViewValue.drop();
        this.idsMap.clear();
    }

    void onBuildsViewRemove(@NotNull MultipleBuildsView buildsView) {
        if (this.isDisposed.get()) {
            return;
        }
        if (this.myBuildsViewValue.getValue() == buildsView) {
            this.myBuildsViewValue.drop();
        } else {
            this.myPinnedViews.remove(buildsView);
        }
        this.clearIdsOf(buildsView.getBuildsMap().keySet());
    }

    private void clearIdsOf(@NotNull Collection<? extends BuildDescriptor> builds) {
        if (this.idsMap.isEmpty()) {
            return;
        }
        Set ids = builds.stream().map(BuildDescriptor::getId).collect(Collectors.toSet());
        this.idsMap.values().removeIf(val -> ids.contains(val));
    }

    private void configurePinnedContent() {
        MultipleBuildsView buildsView = (MultipleBuildsView)this.myBuildsViewValue.getValue();
        Content content2 = buildsView.getContent();
        if (content2 != null && content2.isPinned()) {
            String tabName = this.getPinnedTabName(buildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content2.setPinnable(false);
                if (content2.getIcon() == null) {
                    content2.setIcon(EmptyIcon.ICON_8);
                }
                content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content2, tabName);
            });
            this.myPinnedViews.add(buildsView);
            this.myBuildsViewValue.drop();
            content2.putUserData(PINNED_EXTRACTED_CONTENT, (Object)Boolean.TRUE);
        }
    }

    private String getPinnedTabName(MultipleBuildsView buildsView) {
        Map<BuildDescriptor, BuildView> buildsMap = buildsView.getBuildsMap();
        BuildDescriptor buildInfo = buildsMap.keySet().stream().reduce((b1, b2) -> b1.getStartTime() <= b2.getStartTime() ? b1 : b2).orElse(null);
        if (buildInfo != null) {
            String title = buildInfo.getTitle();
            String viewName = this.getViewName().split(" ")[0];
            String tabName = viewName + ": " + StringUtil.trimStart((String)title, (String)viewName);
            if (buildsMap.size() > 1) {
                tabName = tabName + String.format(" and %d more", buildsMap.size() - 1);
            }
            return tabName;
        }
        return this.getViewName();
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content myContent;

        PinBuildViewAction(MultipleBuildsView buildsView) {
            this.myContent = buildsView.getContent();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean selected2;
            boolean bl = selected2 = !this.myContent.isPinned();
            if (selected2) {
                this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
            }
            this.myContent.setPinned(selected2);
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (!this.myContent.isValid()) {
                return;
            }
            Boolean isPinnedAndExtracted = (Boolean)this.myContent.getUserData(PINNED_EXTRACTED_CONTENT);
            if (isPinnedAndExtracted == Boolean.TRUE) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ContentManager contentManager2 = this.myContent.getManager();
            boolean isActiveTab = contentManager2 != null && contentManager2.getSelectedContent() == this.myContent;
            boolean selected2 = this.myContent.isPinned();
            e.getPresentation().setIcon(AllIcons.General.Pin_tab);
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)selected2);
            String text = !isActiveTab ? (selected2 ? IdeBundle.message((String)"action.unpin.active.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.active.tab", (Object[])new Object[0])) : (selected2 ? IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]) : IdeBundle.message((String)"action.pin.tab", (Object[])new Object[0]));
            e.getPresentation().setText(text);
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @ApiStatus.Internal
    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime = -1L;
        EventResult result;
        Content content;

        BuildInfo(@NotNull BuildDescriptor descriptor2) {
            super(descriptor2);
        }

        public Icon getIcon() {
            return ExecutionNode.getEventResultIcon(this.result);
        }

        public boolean isRunning() {
            return this.endTime == -1L;
        }
    }
}

