/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginExportData {
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String VENDOR_NAME_PROPERTY = "vendorName";
    private static final String VENDOR_MAIL_PROPERTY = "vendorMail";
    private static final String VENDOR_URL_PROPERTY = "vendorUrl";
    private static final String VERSION_PROPERTY = "version";
    private String myDescription;
    private String myVendorName;
    private String myVendorMail;
    private String myVendorUrl;
    private String myPluginVersion;
    private String myChangeNotes;

    public PluginExportData(@NotNull Properties info) {
        this.initData(info);
    }

    private void initData(@NotNull Properties info) {
        this.myDescription = info.getProperty(DESCRIPTION_PROPERTY);
        this.myVendorName = info.getProperty(VENDOR_NAME_PROPERTY);
        this.myVendorMail = info.getProperty(VENDOR_MAIL_PROPERTY);
        this.myVendorUrl = info.getProperty(VENDOR_URL_PROPERTY);
        this.myPluginVersion = info.getProperty(VERSION_PROPERTY);
    }

    public String getDescription() {
        return PluginExportData.normalize(this.myDescription, "");
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getVendorName() {
        return PluginExportData.normalize(this.myVendorName, "");
    }

    public void setVendorName(String vendorName) {
        this.myVendorName = vendorName;
    }

    public String getVendorMail() {
        return PluginExportData.normalize(this.myVendorMail, "");
    }

    public void setVendorMail(String vendorMail) {
        this.myVendorMail = vendorMail;
    }

    public String getVendorUrl() {
        return PluginExportData.normalize(this.myVendorUrl, "http://");
    }

    public void setVendorUrl(String vendorUrl) {
        this.myVendorUrl = vendorUrl;
    }

    public String getPluginVersion() {
        return PluginExportData.normalize(this.myPluginVersion, "0.1");
    }

    public void setPluginVersion(String pluginVersion) {
        this.myPluginVersion = pluginVersion;
    }

    public String getChangeNotes() {
        return PluginExportData.normalize(this.myChangeNotes, "");
    }

    public void setChangeNotes(String changeNotes) {
        this.myChangeNotes = changeNotes;
    }

    public String getSinceBuild() {
        return "142.0";
    }

    private static String normalize(@Nullable String value2, @NotNull String defaultValue) {
        return value2 == null || StringUtil.isEmptyOrSpaces((String)value2) ? defaultValue : value2.trim();
    }

    public boolean isEmpty() {
        return this.myDescription == null && this.myPluginVersion == null && this.myVendorUrl == null && this.myVendorMail == null && this.myVendorName == null;
    }

    public void saveToProperties(@NotNull Properties properties) {
        properties.setProperty(DESCRIPTION_PROPERTY, this.getDescription());
        properties.setProperty(VERSION_PROPERTY, this.getPluginVersion());
        properties.setProperty(VENDOR_URL_PROPERTY, this.getVendorUrl());
        properties.setProperty(VENDOR_MAIL_PROPERTY, this.getVendorMail());
        properties.setProperty(VENDOR_NAME_PROPERTY, this.getVendorName());
    }
}

