/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.application.options.colors.pluginExport.PluginExportData;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import org.jetbrains.annotations.NotNull;

public class ColorSchemePluginTemplate {
    public static final String PLUGIN_ID = "%PLUGIN_ID%";
    public static final String DISPLAY_NAME = "%DISPLAY_NAME%";
    public static final String VENDOR_NAME = "%VENDOR_NAME%";
    public static final String VENDOR_MAIL = "%VENDOR_MAIL%";
    public static final String VENDOR_URL = "%VENDOR_URL%";
    public static final String PLUGIN_VERSION = "%VERSION%";
    public static final String PLUGIN_DESCRIPTION = "%DESCRIPTION%";
    public static final String CHANGE_NOTES = "%NOTES%";
    public static final String SINCE_BUILD = "%SINCE_BUILD%";
    public static final String SCHEME_NAME = "$SCHEME_NAME";
    private static final String TEMPLATE_TEXT = "<idea-plugin>\n  <id>%PLUGIN_ID%</id>\n  <name>%DISPLAY_NAME%</name>\n  <version>%VERSION%</version>\n  <vendor email=\"%VENDOR_MAIL%\" url=\"%VENDOR_URL%\">%VENDOR_NAME%</vendor>\n\n  <description><![CDATA[\n      %DESCRIPTION%\n    ]]></description>\n\n  <change-notes><![CDATA[\n      %NOTES%\n    ]]>\n  </change-notes>\n\n  <idea-version since-build=\"%SINCE_BUILD%\"/>\n\n  <depends>com.intellij.modules.lang</depends>\n\n  <extensions defaultExtensionNs=\"com.intellij\">\n    <bundledColorScheme path=\"/colors/$SCHEME_NAME\"/>\n  </extensions>\n</idea-plugin>";
    private String myText = "<idea-plugin>\n  <id>%PLUGIN_ID%</id>\n  <name>%DISPLAY_NAME%</name>\n  <version>%VERSION%</version>\n  <vendor email=\"%VENDOR_MAIL%\" url=\"%VENDOR_URL%\">%VENDOR_NAME%</vendor>\n\n  <description><![CDATA[\n      %DESCRIPTION%\n    ]]></description>\n\n  <change-notes><![CDATA[\n      %NOTES%\n    ]]>\n  </change-notes>\n\n  <idea-version since-build=\"%SINCE_BUILD%\"/>\n\n  <depends>com.intellij.modules.lang</depends>\n\n  <extensions defaultExtensionNs=\"com.intellij\">\n    <bundledColorScheme path=\"/colors/$SCHEME_NAME\"/>\n  </extensions>\n</idea-plugin>";

    public ColorSchemePluginTemplate(@NotNull EditorColorsScheme scheme, @NotNull PluginExportData exportData) {
        this.initTemplate(scheme, exportData);
    }

    private void initTemplate(@NotNull EditorColorsScheme scheme, @NotNull PluginExportData exportData) {
        this.myText = this.myText.replace(PLUGIN_ID, "color.scheme." + scheme.getName());
        this.myText = this.myText.replace(DISPLAY_NAME, scheme.getName() + " Color Scheme");
        this.myText = this.myText.replace(VENDOR_NAME, exportData.getVendorName());
        this.myText = this.myText.replace(VENDOR_MAIL, exportData.getVendorMail());
        this.myText = this.myText.replace(VENDOR_URL, exportData.getVendorUrl());
        this.myText = this.myText.replace(PLUGIN_VERSION, exportData.getPluginVersion());
        this.myText = this.myText.replace(PLUGIN_DESCRIPTION, exportData.getDescription());
        this.myText = this.myText.replace(CHANGE_NOTES, exportData.getChangeNotes());
        this.myText = this.myText.replace(SINCE_BUILD, exportData.getSinceBuild());
        this.myText = this.myText.replace(SCHEME_NAME, scheme.getName());
    }

    public String getText() {
        return this.myText;
    }
}

