/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.pluginExport;

import com.intellij.application.options.colors.pluginExport.ColorSchemePluginTemplate;
import com.intellij.application.options.colors.pluginExport.PluginExportData;
import com.intellij.application.options.colors.pluginExport.PluginInfoDialog;
import com.intellij.application.options.schemes.SerializableSchemeExporter;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.options.ConfigurableSchemeExporter;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSchemePluginExporter
extends ConfigurableSchemeExporter<PluginExportData, EditorColorsScheme> {
    public void exportScheme(@NotNull EditorColorsScheme scheme, @NotNull OutputStream outputStream, @Nullable PluginExportData exportData) throws Exception {
        if (exportData != null) {
            try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
                zipStream.putNextEntry(new ZipEntry("META-INF/plugin.xml"));
                ColorSchemePluginExporter.writePluginXml(scheme, zipStream, exportData);
                zipStream.putNextEntry(new ZipEntry("colors/" + scheme.getName() + ".xml"));
                SerializableSchemeExporter.writeToStream((SerializableScheme)scheme, zipStream);
            }
        }
    }

    public String getExtension() {
        return "jar";
    }

    @Nullable
    public PluginExportData getConfiguration(@NotNull Component parent, @NotNull EditorColorsScheme scheme) {
        PluginExportData exportData = ColorSchemePluginExporter.getPluginExportData(scheme);
        EditorColorsScheme schemeToUpdate = ColorSchemePluginExporter.getSchemeToUpdate(scheme);
        PluginInfoDialog infoDialog = new PluginInfoDialog(parent, exportData);
        if (infoDialog.showAndGet()) {
            infoDialog.apply();
            exportData.saveToProperties(schemeToUpdate.getMetaProperties());
            if (schemeToUpdate instanceof AbstractColorsScheme) {
                ((AbstractColorsScheme)schemeToUpdate).setSaveNeeded(true);
            }
            return exportData;
        }
        return null;
    }

    private static void writePluginXml(@NotNull EditorColorsScheme scheme, @NotNull OutputStream outputStream, @NotNull PluginExportData exportData) throws IOException {
        ColorSchemePluginTemplate template = new ColorSchemePluginTemplate(scheme, exportData);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        writer.write(template.getText());
        writer.flush();
    }

    @NotNull
    private static EditorColorsScheme getSchemeToUpdate(@NotNull EditorColorsScheme scheme) {
        AbstractColorsScheme original;
        if (scheme instanceof AbstractColorsScheme && (original = ((AbstractColorsScheme)scheme).getOriginal()) != null) {
            return original;
        }
        return scheme;
    }

    @NotNull
    private static PluginExportData getPluginExportData(@NotNull EditorColorsScheme scheme) {
        AbstractColorsScheme original;
        PluginExportData data2 = new PluginExportData(scheme.getMetaProperties());
        if (data2.isEmpty() && scheme instanceof AbstractColorsScheme && !(scheme instanceof ReadOnlyColorsScheme) && (original = ((AbstractColorsScheme)scheme).getOriginal()) != null) {
            return ColorSchemePluginExporter.getPluginExportData(original);
        }
        return data2;
    }
}

