/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactoryEx;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class ScopeColorsPageFactory
implements ColorAndFontPanelFactoryEx {
    ScopeColorsPageFactory() {
    }

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options2) {
        final JPanel scopePanel = ScopeColorsPageFactory.createChooseScopePanel();
        return NewColorAndFontPanel.create(new PreviewPanel.Empty(){

            @Override
            public Component getPanel() {
                return scopePanel;
            }
        }, ColorAndFontOptions.getScopesGroup(), options2, null, null);
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        return ColorAndFontOptions.getScopesGroup();
    }

    private static JPanel createChooseScopePanel() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        final JPanel panel2 = new JPanel(new GridBagLayout());
        if (projects.length == 0) {
            return panel2;
        }
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        JButton button2 = new JButton(LangBundle.message((String)"manage.scopes", (Object[])new Object[0]));
        button2.setPreferredSize(new Dimension(230, button2.getPreferredSize().height));
        panel2.add((Component)button2, gc);
        gc.gridx = 0;
        gc.weightx = 1.0;
        panel2.add((Component)new JPanel(), gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weighty = 1.0;
        panel2.add((Component)new JPanel(), gc);
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                DataContext context = DataManager.getInstance().getDataContext((Component)panel2);
                Settings settings = (Settings)Settings.KEY.getData(context);
                Project project = (Project)CommonDataKeys.PROJECT.getData(context);
                if (settings != null) {
                    try {
                        if (settings.select(settings.find("project.scopes")).isRejected()) {
                            EditScopesDialog.showDialog(project, null);
                        }
                    }
                    catch (IllegalStateException ex) {
                        EditScopesDialog.showDialog(project, null);
                    }
                }
            }
        });
        return panel2;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.OTHER_SETTINGS;
    }
}

