/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FontEditorPreview
implements PreviewPanel {
    private static final String PREVIEW_TEXT_KEY = "FontPreviewText";
    private final EditorEx myEditor;
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public FontEditorPreview(Supplier<? extends EditorColorsScheme> schemeSupplier, boolean editable) {
        this.mySchemeSupplier = schemeSupplier;
        @Nls String text = PropertiesComponent.getInstance().getValue(PREVIEW_TEXT_KEY, FontEditorPreview.getIDEDemoText());
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text, this.mySchemeSupplier.get(), editable);
        FontEditorPreview.registerRestoreAction(this.myEditor);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    private static void registerRestoreAction(EditorEx editor) {
        editor.putUserData(RestorePreviewTextAction.OUR_EDITOR, Boolean.TRUE);
        AnAction restoreAction = ActionManager.getInstance().getAction("RestoreFontPreviewTextAction");
        if (restoreAction != null) {
            String originalGroupId = editor.getContextMenuGroupId();
            AnAction originalGroup = originalGroupId == null ? null : ActionManager.getInstance().getAction(originalGroupId);
            DefaultActionGroup group = new DefaultActionGroup();
            if (originalGroup instanceof ActionGroup) {
                group.addAll(((ActionGroup)originalGroup).getChildren(null));
            }
            group.add(restoreAction);
            editor.installPopupHandler(new ContextMenuPopupHandler.Simple((ActionGroup)group));
        }
    }

    private static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is a full-featured IDE\nwith a high level of usability and outstanding\nadvanced code editing and refactoring support.\n\nabcdefghijklmnopqrstuvwxyz 0123456789 (){}[]\nABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/= .,;:!? #&$%@|^\n\n<!-- -- != := === >= >- >=> |-> -> <$> </> #[ |||> |= ~@\n\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        EditorMarkupModel markupModel = (EditorMarkupModel)((Object)editor.getMarkupModel());
        markupModel.setErrorStripeRenderer(new DumbTrafficLightRenderer());
        markupModel.setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text, EditorColorsScheme scheme, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text);
        FileDocumentManagerImpl.registerDocument(editorDocument, (VirtualFile)new LightVirtualFile());
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        return editor;
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.updateOptionsScheme(this.mySchemeSupplier.get());
        this.myEditor.setColorsScheme(scheme);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        String previewText = this.myEditor.getDocument().getText();
        if (previewText.equals(FontEditorPreview.getIDEDemoText())) {
            PropertiesComponent.getInstance().unsetValue(PREVIEW_TEXT_KEY);
        } else {
            PropertiesComponent.getInstance().setValue(PREVIEW_TEXT_KEY, previewText);
        }
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    public static class RestorePreviewTextAction
    extends DumbAwareAction {
        private static final Key<Boolean> OUR_EDITOR = Key.create((String)"RestorePreviewTextAction.editor");

        public void update(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabledAndVisible(editor != null && editor.getUserData(OUR_EDITOR) != null && !editor.getDocument().getText().equals(FontEditorPreview.getIDEDemoText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), null, null, () -> editor.getDocument().setText((CharSequence)FontEditorPreview.getIDEDemoText()), (PsiFile[])new PsiFile[0]);
            }
        }
    }

    private static class DumbTrafficLightRenderer
    implements ErrorStripeRenderer {
        private DumbTrafficLightRenderer() {
        }

        public void paint(@NotNull Component c, Graphics g, @NotNull Rectangle r) {
            Icon icon2 = AllIcons.General.InspectionsOK;
            icon2.paintIcon(c, g, r.x, r.y);
        }
    }
}

