/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.group;

import com.intellij.ConfigurableFactory;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleGroupProvider
extends CodeStyleSettingsProvider {
    private final CodeStyleGroup myGroup;
    private final CodeStyleSchemesModel myModel;
    private final CodeStyleSchemesConfigurable mySchemesConfigurable;
    private final List<CodeStyleSettingsProvider> myChildProviders = new ArrayList<CodeStyleSettingsProvider>();

    public CodeStyleGroupProvider(@NotNull CodeStyleGroup group, CodeStyleSchemesModel model, CodeStyleSchemesConfigurable configurable2) {
        this.myGroup = group;
        this.myModel = model;
        this.mySchemesConfigurable = configurable2;
    }

    public Configurable createConfigurable() {
        return new CodeStyleGroupConfigurable();
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings modelSettings) {
        return new CodeStyleGroupConfigurable();
    }

    public void addChildProvider(@NotNull CodeStyleSettingsProvider provider) {
        this.myChildProviders.add(provider);
    }

    public class CodeStyleGroupConfigurable
    extends SearchableConfigurable.Parent.Abstract {
        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return CodeStyleGroupProvider.this.myGroup.getDisplayName();
        }

        public void reset() {
            CodeStyleGroupProvider.this.myModel.reset();
            for (Configurable child2 : this.getConfigurables()) {
                if (!(child2 instanceof CodeStyleConfigurableWrapper)) continue;
                ((CodeStyleConfigurableWrapper)child2).resetPanel();
            }
        }

        public void apply() throws ConfigurationException {
            CodeStyleGroupProvider.this.myModel.apply();
            for (Configurable child2 : this.getConfigurables()) {
                if (!(child2 instanceof CodeStyleConfigurableWrapper)) continue;
                ((CodeStyleConfigurableWrapper)child2).applyPanel();
            }
        }

        public Configurable @NotNull [] buildConfigurables() {
            ArrayList<CodeStyleConfigurableWrapper> childConfigurables = new ArrayList<CodeStyleConfigurableWrapper>();
            for (CodeStyleSettingsProvider childProvider : CodeStyleGroupProvider.this.myChildProviders) {
                CodeStyleConfigurableWrapper wrapper2 = ConfigurableFactory.Companion.getInstance().createCodeStyleConfigurable(childProvider, CodeStyleGroupProvider.this.myModel, CodeStyleGroupProvider.this.mySchemesConfigurable);
                childConfigurables.add(wrapper2);
            }
            return childConfigurables.toArray(new Configurable[0]);
        }

        @NotNull
        public String getId() {
            return CodeStyleGroupProvider.this.myGroup.getId();
        }

        @Nullable
        public String getHelpTopic() {
            return CodeStyleGroupProvider.this.myGroup.getHelpTopic();
        }
    }
}

