/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ArrangementComboBoxUiComponent
extends AbstractArrangementUiComponent {
    private final JComboBox<ArrangementSettingsToken> myComboBox;

    public ArrangementComboBoxUiComponent(@NotNull List<? extends ArrangementSettingsToken> tokens) {
        super(tokens);
        Object[] tokensArray = tokens.toArray(new ArrangementSettingsToken[0]);
        Arrays.sort(tokensArray, Comparator.comparing(ArrangementSettingsToken::getRepresentationValue));
        this.myComboBox = new ComboBox(tokensArray);
        this.myComboBox.setRenderer((ListCellRenderer<ArrangementSettingsToken>)SimpleListCellRenderer.create((String)"", ArrangementSettingsToken::getRepresentationValue));
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ArrangementComboBoxUiComponent.this.fireStateChanged();
                }
            }
        });
        int minWidth = 0;
        JBList dummyList = new JBList();
        int max = this.myComboBox.getItemCount();
        for (int i2 = 0; i2 < max; ++i2) {
            Component rendererComponent = this.myComboBox.getRenderer().getListCellRendererComponent((JList<ArrangementSettingsToken>)dummyList, this.myComboBox.getItemAt(i2), i2, false, true);
            minWidth = Math.max(minWidth, rendererComponent.getPreferredSize().width);
        }
        this.myComboBox.setPreferredSize(new Dimension(minWidth * 5 / 3, this.myComboBox.getPreferredSize().height));
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        return (ArrangementSettingsToken)this.myComboBox.getSelectedItem();
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data2) throws IllegalArgumentException {
        this.myComboBox.setSelectedItem(data2);
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        ArrangementSettingsToken token = this.getToken();
        return new ArrangementAtomMatchCondition(token, (Object)token);
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myComboBox;
    }

    public boolean isSelected() {
        return true;
    }

    public void setSelected(boolean selected2) {
    }

    @Override
    public boolean isEnabled() {
        return this.myComboBox.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myComboBox.setEnabled(enabled);
    }

    @Override
    protected void doReset() {
    }

    public int getBaselineToUse(int width, int height) {
        return -1;
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }
}

