/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.LoadedModuleDescription;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDescriptionsComboBox
extends ComboBox<ModuleDescription> {
    private final SortedComboBoxModel<ModuleDescription> myModel = new SortedComboBoxModel(Comparator.comparing(description -> description != null ? description.getName() : "", String.CASE_INSENSITIVE_ORDER));
    private boolean myAllowEmptySelection;

    public ModuleDescriptionsComboBox() {
        this.setModel((ComboBoxModel)this.myModel);
        this.setSwingPopup(false);
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer()));
    }

    public void allowEmptySelection(@NotNull String emptySelectionText) {
        this.myAllowEmptySelection = true;
        this.myModel.add(null);
        this.setRenderer((ListCellRenderer)((Object)new ModuleDescriptionListCellRenderer(emptySelectionText)));
    }

    public void setModules(@NotNull Collection<? extends Module> modules2) {
        this.myModel.clear();
        for (Module module : modules2) {
            this.myModel.add((Object)new LoadedModuleDescriptionImpl(module));
        }
        if (this.myAllowEmptySelection) {
            this.myModel.add(null);
        }
    }

    public void setAllModulesFromProject(@NotNull Project project) {
        this.setModules(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
    }

    public void setSelectedModule(@Nullable Module module) {
        this.myModel.setSelectedItem((Object)(module != null ? new LoadedModuleDescriptionImpl(module) : null));
    }

    public void setSelectedModule(@NotNull Project project, @NotNull String moduleName) {
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module != null) {
            this.setSelectedModule(module);
        } else {
            UnloadedModuleDescription description = ModuleManager.getInstance((Project)project).getUnloadedModuleDescription(moduleName);
            if (description != null) {
                if (this.myModel.indexOf((Object)description) < 0) {
                    this.myModel.add((Object)description);
                }
                this.myModel.setSelectedItem((Object)description);
            } else {
                this.myModel.setSelectedItem(null);
            }
        }
    }

    @Nullable
    public Module getSelectedModule() {
        ModuleDescription selected2 = (ModuleDescription)this.myModel.getSelectedItem();
        if (selected2 instanceof LoadedModuleDescription) {
            return ((LoadedModuleDescription)selected2).getModule();
        }
        return null;
    }

    @Nullable
    public String getSelectedModuleName() {
        ModuleDescription selected2 = (ModuleDescription)this.myModel.getSelectedItem();
        return selected2 != null ? selected2.getName() : null;
    }

    private static class ModuleDescriptionListCellRenderer
    extends SimpleListCellRenderer<ModuleDescription> {
        private final String myEmptySelectionText;

        ModuleDescriptionListCellRenderer() {
            this("[none]");
        }

        ModuleDescriptionListCellRenderer(@NotNull String emptySelectionText) {
            this.myEmptySelectionText = emptySelectionText;
        }

        public void customize(@NotNull JList<? extends ModuleDescription> list2, ModuleDescription value2, int index, boolean selected2, boolean hasFocus) {
            this.setText(value2 == null ? this.myEmptySelectionText : value2.getName());
            this.setIcon(value2 instanceof LoadedModuleDescription ? ModuleType.get((Module)((LoadedModuleDescription)value2).getModule()).getIcon() : (value2 != null ? AllIcons.Modules.UnloadedModule : null));
        }
    }
}

