/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.FileNode;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\t\u0010\u0010\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/NodeComparator;", "Ljava/util/Comparator;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "Lkotlin/Comparator;", "sortFoldersFirst", "", "sortBySeverity", "sortByName", "(ZZZ)V", "compare", "", "node1", "node2", "problem1", "Lcom/intellij/analysis/problemsView/toolWindow/ProblemNode;", "problem2", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "intellij.platform.lang.impl"})
public final class NodeComparator
implements Comparator<Node> {
    private final boolean sortFoldersFirst;
    private final boolean sortBySeverity;
    private final boolean sortByName;

    @Override
    public int compare(@Nullable Node node1, @Nullable Node node2) {
        if (node1 == node2) {
            return 0;
        }
        if (node1 == null) {
            return 1;
        }
        if (node2 == null) {
            return -1;
        }
        if (node1 instanceof ProblemNode && node2 instanceof ProblemNode) {
            return this.compare((ProblemNode)node1, (ProblemNode)node2);
        }
        if (node1 instanceof ProblemNode) {
            return -1;
        }
        if (node2 instanceof ProblemNode) {
            return 1;
        }
        if (this.sortFoldersFirst && node1 instanceof FileNode && node2 instanceof FileNode) {
            if (((FileNode)node1).getFile().isDirectory() && !((FileNode)node2).getFile().isDirectory()) {
                return -1;
            }
            if (!((FileNode)node1).getFile().isDirectory() && ((FileNode)node2).getFile().isDirectory()) {
                return 1;
            }
        }
        return StringUtil.naturalCompare((String)node1.getName(), (String)node2.getName());
    }

    @Override
    private final int compare(ProblemNode problem1, ProblemNode problem2) {
        int result2;
        if (this.sortBySeverity && (result2 = Intrinsics.compare((int)problem2.getSeverity(), (int)problem1.getSeverity())) != 0) {
            return result2;
        }
        return this.sortByName ? ((result2 = StringUtil.naturalCompare((String)problem1.getDescription(), (String)problem2.getDescription())) != 0 ? result2 : Intrinsics.compare((int)problem1.getOffset(), (int)problem2.getOffset())) : ((result2 = Intrinsics.compare((int)problem1.getOffset(), (int)problem2.getOffset())) != 0 ? result2 : StringUtil.naturalCompare((String)problem1.getDescription(), (String)problem2.getDescription()));
    }

    public NodeComparator(boolean sortFoldersFirst, boolean sortBySeverity, boolean sortByName) {
        this.sortFoldersFirst = sortFoldersFirst;
        this.sortBySeverity = sortBySeverity;
        this.sortByName = sortByName;
    }

    private final boolean component1() {
        return this.sortFoldersFirst;
    }

    private final boolean component2() {
        return this.sortBySeverity;
    }

    private final boolean component3() {
        return this.sortByName;
    }

    @NotNull
    public final NodeComparator copy(boolean sortFoldersFirst, boolean sortBySeverity, boolean sortByName) {
        return new NodeComparator(sortFoldersFirst, sortBySeverity, sortByName);
    }

    public static /* synthetic */ NodeComparator copy$default(NodeComparator nodeComparator, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = nodeComparator.sortFoldersFirst;
        }
        if ((n & 2) != 0) {
            bl2 = nodeComparator.sortBySeverity;
        }
        if ((n & 4) != 0) {
            bl3 = nodeComparator.sortByName;
        }
        return nodeComparator.copy(bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "NodeComparator(sortFoldersFirst=" + this.sortFoldersFirst + ", sortBySeverity=" + this.sortBySeverity + ", sortByName=" + this.sortByName + ")";
    }

    public int hashCode() {
        int n = this.sortFoldersFirst ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int n2 = n * 31;
        int n3 = this.sortBySeverity ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        int n4 = (n2 + n3) * 31;
        int n5 = this.sortByName ? 1 : 0;
        if (n5 != 0) {
            n5 = 1;
        }
        return n4 + n5;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof NodeComparator)) break block3;
                NodeComparator nodeComparator = (NodeComparator)object;
                if (this.sortFoldersFirst != nodeComparator.sortFoldersFirst || this.sortBySeverity != nodeComparator.sortBySeverity || this.sortByName != nodeComparator.sortByName) break block3;
            }
            return true;
        }
        return false;
    }
}

