/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/FileNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "parent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/analysis/problemsView/toolWindow/Node;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class FileNode
extends Node {
    @NotNull
    private final VirtualFile file;

    @NotNull
    public LeafState getLeafState() {
        return this.getParentDescriptor() instanceof Root ? LeafState.NEVER : LeafState.DEFAULT;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.file.getPresentableName();
        if (string == null) {
            string = this.file.getName();
        }
        return string;
    }

    @Override
    protected void update(@NotNull Project project, @NotNull PresentationData presentation2) {
        int count;
        Root root;
        presentation2.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = CompoundIconProvider.findIcon((PsiElement)PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)this.file), 0);
        if (icon2 == null) {
            boolean bl = this.file.isDirectory();
            icon2 = bl ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type;
        }
        presentation2.setIcon(icon2);
        if (!(this.getParentDescriptor() instanceof FileNode)) {
            Object object = this.file.getParent();
            if (object == null || (object = object.getPresentableUrl()) == null) {
                return;
            }
            Object url = object;
            presentation2.addText("  " + FileUtil.getLocationRelativeToUserHome((String)url), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        Root root2 = root = this.findAncestor(Root.class);
        int n = count = root2 != null ? root2.getProblemsCount(this.file) : 0;
        if (count > 0) {
            String text = ProblemsViewBundle.message("problems.view.file.problems", count);
            presentation2.addText("  " + text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    @NotNull
    public Collection<Node> getChildren() {
        Root root = this.findAncestor(Root.class);
        Object object = root;
        if (object == null || (object = object.getChildren(this.file)) == null) {
            object = super.getChildren();
        }
        return object;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public FileNode(@NotNull Node parent, @NotNull VirtualFile file2) {
        super(parent);
        this.file = file2;
    }
}

