/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.dialog;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.analysis.dialog.ModelScopeItemPresenter;
import com.intellij.analysis.dialog.OtherScopeItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OtherScopeItemPresenter
implements ModelScopeItemPresenter {
    @Override
    public int getScopeId() {
        return 3;
    }

    @Override
    @NotNull
    public JRadioButton getButton(ModelScopeItem m) {
        OtherScopeItem model = (OtherScopeItem)m;
        AnalysisScope scope = model.getScope();
        JRadioButton button2 = new JRadioButton();
        String name = scope.getShortenName();
        button2.setText(name);
        button2.setMnemonic(name.charAt(OtherScopeItemPresenter.getSelectedScopeMnemonic(name)));
        return button2;
    }

    @Override
    @NotNull
    public List<JComponent> getAdditionalComponents(JRadioButton b, ModelScopeItem m, Disposable dialogDisposable) {
        return Collections.emptyList();
    }

    @Override
    public boolean isApplicable(ModelScopeItem model) {
        return model instanceof OtherScopeItem;
    }

    private static int getSelectedScopeMnemonic(String name) {
        int fileIdx = StringUtil.indexOfIgnoreCase((String)name, (String)"file", (int)0);
        if (fileIdx > -1) {
            return fileIdx;
        }
        int dirIdx = StringUtil.indexOfIgnoreCase((String)name, (String)"directory", (int)0);
        if (dirIdx > -1) {
            return dirIdx;
        }
        return 0;
    }

    @Override
    @Nullable
    public ModelScopeItem tryCreate(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable Module module, @Nullable PsiElement context) {
        return OtherScopeItem.tryCreate(scope);
    }
}

