/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeUtil;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnalysisActionUtils {
    private static AnalysisScope getFileScopeFromInspectionView(DataContext dataContext) {
        AnalysisScope scope;
        int type;
        InspectionResultsView inspectionView = (InspectionResultsView)dataContext.getData(InspectionResultsView.DATA_KEY);
        if (inspectionView != null && (type = (scope = inspectionView.getScope()).getScopeType()) != 4 && type != 1 && scope.isValid()) {
            return scope;
        }
        return null;
    }

    @Nullable
    public static AnalysisScope getInspectionScope(@NotNull DataContext dataContext, @NotNull Project project, Boolean acceptNonProjectDirectories) {
        AnalysisScope scope = AnalysisActionUtils.getFileScopeFromInspectionView(dataContext);
        if (scope != null) {
            return scope;
        }
        scope = AnalysisActionUtils.getInspectionScopeImpl(dataContext, project, acceptNonProjectDirectories);
        return scope.getScopeType() != 6 ? scope : null;
    }

    @NotNull
    private static AnalysisScope getInspectionScopeImpl(@NotNull DataContext dataContext, @NotNull Project project, Boolean acceptNonProjectDirectories) {
        Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        if (projectContext != null) {
            return new AnalysisScope(projectContext);
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScopeUtil.KEY.getData(dataContext);
        if (analysisScope != null) {
            return analysisScope;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && psiFile.getManager().isInProject((PsiElement)psiFile)) {
            PsiDirectory psiDirectory;
            VirtualFile jarRoot;
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType && acceptNonProjectDirectories.booleanValue() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null && (psiDirectory = psiFile.getManager().findDirectory(jarRoot)) != null) {
                return new AnalysisScope(psiDirectory);
            }
            return new AnalysisScope(psiFile);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (virtualFiles != null) {
            PsiDirectory psiDirectory;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (virtualFiles.length == 1 && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null && (acceptNonProjectDirectories.booleanValue() || psiDirectory.getManager().isInProject((PsiElement)psiDirectory))) {
                return new AnalysisScope(psiDirectory);
            }
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                files2.add(vFile);
            }
            return new AnalysisScope(project, files2);
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            return new AnalysisScope(moduleContext);
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            return new AnalysisScope(modulesArray);
        }
        return new AnalysisScope(project);
    }
}

