/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import java.util.ArrayList;

public class TimeZoneDataFiles {
    private static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    private static final String ANDROID_I18N_ROOT_ENV = "ANDROID_I18N_ROOT";
    private static final String ANDROID_TZDATA_ROOT_ENV = "ANDROID_TZDATA_ROOT";
    private static final String ANDROID_DATA_ENV = "ANDROID_DATA";

    private TimeZoneDataFiles() {
    }

    public static String[] getTimeZoneFilePaths(String fileName) {
        return new String[]{TimeZoneDataFiles.getDataTimeZoneFile(fileName), TimeZoneDataFiles.getTimeZoneModuleTzFile(fileName)};
    }

    public static String getDataTimeZoneRootDir() {
        return System.getenv(ANDROID_DATA_ENV) + "/misc/zoneinfo/";
    }

    public static String getDataTimeZoneFile(String fileName) {
        return TimeZoneDataFiles.getDataTimeZoneRootDir() + "current/" + fileName;
    }

    public static String getTimeZoneModuleTzFile(String fileName) {
        return TimeZoneDataFiles.getTimeZoneModuleFile("tz/" + fileName);
    }

    public static String getTimeZoneModuleIcuFile(String fileName) {
        return TimeZoneDataFiles.getTimeZoneModuleFile("icu/" + fileName);
    }

    public static String getTimeZoneModuleTzVersionFile() {
        return TimeZoneDataFiles.getTimeZoneModuleTzFile("tz_version");
    }

    public static String getTimeZoneModuleFile(String fileName) {
        return System.getenv(ANDROID_TZDATA_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String getI18nModuleIcuFile(String fileName) {
        return TimeZoneDataFiles.getI18nModuleFile("icu/" + fileName);
    }

    private static String getI18nModuleFile(String fileName) {
        return System.getenv(ANDROID_I18N_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String getSystemTzFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/share/zoneinfo/" + fileName);
    }

    public static String getSystemIcuFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/icu/" + fileName);
    }

    public static String generateIcuDataPath() {
        ArrayList<String> paths = new ArrayList<String>(3);
        String dataIcuDataPath = TimeZoneDataFiles.getEnvironmentPath(ANDROID_DATA_ENV, "/misc/zoneinfo/current/icu/");
        if (dataIcuDataPath != null) {
            paths.add(dataIcuDataPath);
        }
        String timeZoneModuleIcuDataPath = TimeZoneDataFiles.getTimeZoneModuleIcuFile("");
        paths.add(timeZoneModuleIcuDataPath);
        String i18nModuleIcuDataPath = TimeZoneDataFiles.getI18nModuleIcuFile("");
        paths.add(i18nModuleIcuDataPath);
        return String.join((CharSequence)":", paths);
    }

    private static String getEnvironmentPath(String environmentVariable, String path) {
        String variable = System.getenv(environmentVariable);
        if (variable == null) {
            return null;
        }
        return variable + path;
    }
}

