/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.graphics.Rect;
import android.os.Parcel;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ParcelUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElement;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WindowHierarchyElementAndroid
extends WindowHierarchyElement {
    private static final String TAG = "WindowHierarchyElementA";
    private final List<ViewHierarchyElementAndroid> viewHierarchyElements;
    private @MonotonicNonNull AccessibilityHierarchyAndroid accessibilityHierarchy;

    private WindowHierarchyElementAndroid(int id2, @Nullable Integer parentId, List<Integer> childIds, @Nullable Integer windowId, @Nullable Integer layer, @Nullable Integer type, @Nullable Boolean focused, @Nullable Boolean accessibilityFocused, @Nullable Boolean active, @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen, List<ViewHierarchyElementAndroid> viewHierarchyElements) {
        super(id2, parentId, childIds, windowId, layer, type, focused, accessibilityFocused, active, boundsInScreen);
        this.viewHierarchyElements = viewHierarchyElements;
    }

    @Override
    public @Nullable ViewHierarchyElementAndroid getRootView() {
        if (this.viewHierarchyElements.isEmpty()) {
            return null;
        }
        return this.viewHierarchyElements.get(0);
    }

    public List<ViewHierarchyElementAndroid> getAllViews() {
        return Collections.unmodifiableList(this.viewHierarchyElements);
    }

    @Override
    public @Nullable WindowHierarchyElementAndroid getParentWindow() {
        Integer parentIdTmp = this.parentId;
        return parentIdTmp != null ? this.getAccessibilityHierarchy().getWindowById(parentIdTmp) : null;
    }

    @Override
    public WindowHierarchyElementAndroid getChildWindow(int atIndex) {
        if (atIndex < 0 || atIndex >= this.childIds.size()) {
            throw new NoSuchElementException();
        }
        return this.getAccessibilityHierarchy().getWindowById((Integer)this.childIds.get(atIndex));
    }

    @Override
    public ViewHierarchyElementAndroid getViewById(int id2) {
        if (id2 < 0 || id2 >= this.viewHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return this.viewHierarchyElements.get(id2);
    }

    @Override
    public AccessibilityHierarchyAndroid getAccessibilityHierarchy() {
        return (AccessibilityHierarchyAndroid)Preconditions.checkNotNull((Object)this.accessibilityHierarchy);
    }

    public void getBoundsInScreen(Rect outBounds) {
        if (this.boundsInScreen != null) {
            outBounds.set(new Rect(this.boundsInScreen.getLeft(), this.boundsInScreen.getTop(), this.boundsInScreen.getRight(), this.boundsInScreen.getBottom()));
        } else {
            outBounds.setEmpty();
        }
    }

    void writeToParcel(Parcel out) {
        ParcelUtils.writeNullableInteger(out, this.windowId);
        ParcelUtils.writeNullableInteger(out, this.layer);
        ParcelUtils.writeNullableInteger(out, this.type);
        ParcelUtils.writeNullableBoolean(out, this.focused);
        ParcelUtils.writeNullableBoolean(out, this.accessibilityFocused);
        ParcelUtils.writeNullableBoolean(out, this.active);
        com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreenTmp = this.boundsInScreen;
        if (boundsInScreenTmp != null) {
            out.writeInt(1);
            out.writeInt(boundsInScreenTmp.getLeft());
            out.writeInt(boundsInScreenTmp.getTop());
            out.writeInt(boundsInScreenTmp.getRight());
            out.writeInt(boundsInScreenTmp.getBottom());
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.viewHierarchyElements.size());
        if (!this.viewHierarchyElements.isEmpty()) {
            this.writeViewHierarchyToParcel((ViewHierarchyElementAndroid)Preconditions.checkNotNull((Object)this.getRootView()), out);
        }
    }

    private void writeViewHierarchyToParcel(ViewHierarchyElementAndroid element, Parcel out) {
        element.writeToParcel(out);
        int children = element.getChildViewCount();
        out.writeInt(children);
        for (int i = 0; i < children; ++i) {
            this.writeViewHierarchyToParcel(element.getChildView(i), out);
        }
    }

    void setAccessibilityHierarchy(AccessibilityHierarchyAndroid accessibilityHierarchy) {
        this.accessibilityHierarchy = accessibilityHierarchy;
    }

    @Override
    AccessibilityHierarchyProtos.WindowHierarchyElementProto toProto() {
        AccessibilityHierarchyProtos.WindowHierarchyElementProto.Builder builder = AccessibilityHierarchyProtos.WindowHierarchyElementProto.newBuilder();
        builder.setId(this.id);
        if (this.parentId != null) {
            builder.setParentId(this.parentId);
        }
        if (!this.childIds.isEmpty()) {
            builder.addAllChildIds(this.childIds);
        }
        if (this.windowId != null) {
            builder.setWindowId(this.windowId);
        }
        if (this.layer != null) {
            builder.setLayer(this.layer);
        }
        if (this.type != null) {
            builder.setType(this.type);
        }
        if (this.focused != null) {
            builder.setFocused(this.focused);
        }
        if (this.accessibilityFocused != null) {
            builder.setFocused(this.accessibilityFocused);
        }
        if (this.active != null) {
            builder.setActive(this.active);
        }
        if (this.boundsInScreen != null) {
            builder.setBoundsInScreen(this.boundsInScreen.toProto());
        }
        for (ViewHierarchyElementAndroid view : this.viewHierarchyElements) {
            builder.addViews(view.toProto());
        }
        return (AccessibilityHierarchyProtos.WindowHierarchyElementProto)builder.build();
    }

    void addChild(WindowHierarchyElementAndroid child) {
        this.childIds.add(child.id);
    }

    private static ViewHierarchyElementAndroid buildViewHierarchy(AccessibilityNodeInfo forInfo, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap) {
        Preconditions.checkNotNull((Object)forInfo, (Object)"Attempted to build hierarchy from null root node");
        ViewHierarchyElementAndroid element = ViewHierarchyElementAndroid.newBuilder(elementList.size(), parent, forInfo).build();
        elementList.add(element);
        elementToNodeInfoMap.put(element, AccessibilityNodeInfo.obtain(forInfo));
        for (int i = 0; i < forInfo.getChildCount(); ++i) {
            AccessibilityNodeInfo child = forInfo.getChild(i);
            if (child == null) continue;
            element.addChild(WindowHierarchyElementAndroid.buildViewHierarchy(child, elementList, element, elementToNodeInfoMap));
            child.recycle();
        }
        return element;
    }

    private static ViewHierarchyElementAndroid buildViewHierarchy(View forView, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent, Map<ViewHierarchyElementAndroid, View> elementToViewMap) {
        ViewHierarchyElementAndroid element = ViewHierarchyElementAndroid.newBuilder(elementList.size(), parent, forView).build();
        elementList.add(element);
        elementToViewMap.put(element, forView);
        if (forView instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)forView;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                element.addChild(WindowHierarchyElementAndroid.buildViewHierarchy(viewGroup.getChildAt(i), elementList, element, elementToViewMap));
            }
        }
        return element;
    }

    private static ViewHierarchyElementAndroid buildViewHierarchy(Parcel fromParcel, List<ViewHierarchyElementAndroid> elementList, @Nullable ViewHierarchyElementAndroid parent) {
        ViewHierarchyElementAndroid element = ViewHierarchyElementAndroid.newBuilder(elementList.size(), parent, fromParcel).build();
        elementList.add(element);
        int childElementCount = fromParcel.readInt();
        for (int i = 0; i < childElementCount; ++i) {
            element.addChild(WindowHierarchyElementAndroid.buildViewHierarchy(fromParcel, elementList, element));
        }
        return element;
    }

    static BuilderAndroid newBuilder(int id2, View view) {
        BuilderAndroid builder = new BuilderAndroid(id2);
        builder.fromRootView = (View)Preconditions.checkNotNull((Object)view);
        return builder;
    }

    static BuilderAndroid newBuilder(int id2, AccessibilityWindowInfo window) {
        BuilderAndroid builder = new BuilderAndroid(id2);
        builder.fromWindowInfo = (AccessibilityWindowInfo)Preconditions.checkNotNull((Object)window);
        return builder;
    }

    static BuilderAndroid newBuilder(int id2, AccessibilityNodeInfo nodeInfo) {
        BuilderAndroid builder = new BuilderAndroid(id2);
        builder.fromNodeInfo = (AccessibilityNodeInfo)Preconditions.checkNotNull((Object)nodeInfo);
        return builder;
    }

    static BuilderAndroid newBuilder(AccessibilityHierarchyProtos.WindowHierarchyElementProto proto) {
        int id2 = proto.getId();
        BuilderAndroid builder = new BuilderAndroid(id2);
        builder.proto = (AccessibilityHierarchyProtos.WindowHierarchyElementProto)Preconditions.checkNotNull((Object)proto);
        return builder;
    }

    static BuilderAndroid newBuilder(int id2, Parcel in) {
        BuilderAndroid builder = new BuilderAndroid(id2);
        builder.in = (Parcel)Preconditions.checkNotNull((Object)in);
        return builder;
    }

    public static class BuilderAndroid
    extends WindowHierarchyElement.Builder {
        private final int id;
        private @Nullable View fromRootView;
        private @Nullable AccessibilityWindowInfo fromWindowInfo;
        private @Nullable AccessibilityNodeInfo fromNodeInfo;
        private @Nullable Parcel in;
        private @Nullable WindowHierarchyElementAndroid parent;
        private @MonotonicNonNull Map<Long, AccessibilityNodeInfo> nodeInfoOriginMap;
        private @MonotonicNonNull Map<Long, View> viewOriginMap;
        private @Nullable Integer parentId;
        private final List<Integer> childIds = new ArrayList<Integer>();
        private @Nullable Integer windowId;
        private @Nullable Integer layer;
        private @Nullable Integer type;
        private @Nullable Boolean focused;
        private @Nullable Boolean accessibilityFocused;
        private @Nullable Boolean active;
        private @Nullable com.google.android.apps.common.testing.accessibility.framework.replacements.Rect boundsInScreen;
        private List<ViewHierarchyElementAndroid> viewHierarchyElements;

        BuilderAndroid(int id2) {
            this.id = id2;
        }

        public BuilderAndroid setParent(@Nullable WindowHierarchyElementAndroid parent) {
            this.parent = parent;
            return this;
        }

        public BuilderAndroid setNodeInfoOriginMap(Map<Long, AccessibilityNodeInfo> originMap) {
            this.nodeInfoOriginMap = originMap;
            return this;
        }

        public BuilderAndroid setViewOriginMap(Map<Long, View> originMap) {
            this.viewOriginMap = originMap;
            return this;
        }

        @Override
        public WindowHierarchyElementAndroid build() {
            WindowHierarchyElementAndroid result;
            HashMap<ViewHierarchyElementAndroid, View> elementToViewMap = null;
            HashMap<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap = null;
            if (this.fromRootView != null) {
                elementToViewMap = new HashMap<ViewHierarchyElementAndroid, View>();
                result = this.construct(this.id, this.parent, this.fromRootView, elementToViewMap);
            } else if (this.fromWindowInfo != null) {
                elementToNodeInfoMap = new HashMap<ViewHierarchyElementAndroid, AccessibilityNodeInfo>();
                result = this.construct(this.id, this.parent, this.fromWindowInfo, elementToNodeInfoMap);
            } else if (this.fromNodeInfo != null) {
                elementToNodeInfoMap = new HashMap();
                result = this.construct(this.id, this.parent, this.fromNodeInfo, elementToNodeInfoMap);
            } else if (this.in != null) {
                result = this.construct(this.id, this.parent, this.in);
            } else if (this.proto != null) {
                result = this.construct(this.proto);
            } else {
                throw new IllegalStateException("Nothing from which to build");
            }
            this.setWindow(result);
            this.populateOriginMaps(elementToViewMap, elementToNodeInfoMap);
            return result;
        }

        private WindowHierarchyElementAndroid construct(int id2, @Nullable WindowHierarchyElementAndroid parent, AccessibilityWindowInfo fromWindow, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = fromWindow.getId();
            this.layer = fromWindow.getLayer();
            this.type = fromWindow.getType();
            this.focused = fromWindow.isFocused();
            this.accessibilityFocused = fromWindow.isAccessibilityFocused();
            this.active = fromWindow.isActive();
            Rect tempRect = new Rect();
            fromWindow.getBoundsInScreen(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            AccessibilityNodeInfo rootInfo = fromWindow.getRoot();
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            if (rootInfo != null) {
                WindowHierarchyElementAndroid.buildViewHierarchy(rootInfo, (List<ViewHierarchyElementAndroid>)this.viewHierarchyElements, null, elementToNodeInfoMap);
                rootInfo.recycle();
            } else {
                LogUtils.w(WindowHierarchyElementAndroid.TAG, "Constructed WindowHierarchyElement with no valid root.", new Object[0]);
            }
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid construct(int id2, @Nullable WindowHierarchyElementAndroid parent, AccessibilityNodeInfo fromRootNode, Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = fromRootNode.getWindowId();
            Rect tempRect = new Rect();
            fromRootNode.getBoundsInScreen(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            this.active = true;
            this.type = 1;
            this.layer = null;
            this.focused = null;
            this.accessibilityFocused = null;
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            WindowHierarchyElementAndroid.buildViewHierarchy(fromRootNode, (List<ViewHierarchyElementAndroid>)this.viewHierarchyElements, null, elementToNodeInfoMap);
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid construct(int id2, @Nullable WindowHierarchyElementAndroid parent, View fromRootView, Map<ViewHierarchyElementAndroid, View> elementToViewMap) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            Rect tempRect = new Rect();
            fromRootView.getWindowVisibleDisplayFrame(tempRect);
            this.boundsInScreen = new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(tempRect.left, tempRect.top, tempRect.right, tempRect.bottom);
            this.active = true;
            this.type = 1;
            this.windowId = null;
            this.layer = null;
            this.focused = null;
            this.accessibilityFocused = null;
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>();
            WindowHierarchyElementAndroid.buildViewHierarchy(fromRootView, (List<ViewHierarchyElementAndroid>)this.viewHierarchyElements, null, elementToViewMap);
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid construct(int id2, @Nullable WindowHierarchyElementAndroid parent, Parcel in) {
            this.parentId = parent != null ? Integer.valueOf(parent.getId()) : null;
            this.windowId = ParcelUtils.readNullableInteger(in);
            this.layer = ParcelUtils.readNullableInteger(in);
            this.type = ParcelUtils.readNullableInteger(in);
            this.focused = ParcelUtils.readNullableBoolean(in);
            this.accessibilityFocused = ParcelUtils.readNullableBoolean(in);
            this.active = ParcelUtils.readNullableBoolean(in);
            this.boundsInScreen = in.readInt() == 1 ? new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(in.readInt(), in.readInt(), in.readInt(), in.readInt()) : null;
            int totalExpectedNodes = in.readInt();
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>(totalExpectedNodes);
            if (totalExpectedNodes > 0) {
                WindowHierarchyElementAndroid.buildViewHierarchy(in, this.viewHierarchyElements, null);
                Preconditions.checkState((totalExpectedNodes == this.viewHierarchyElements.size() ? 1 : 0) != 0, (Object)"View hierarchy failed consistency check.");
            }
            return new WindowHierarchyElementAndroid(id2, this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private WindowHierarchyElementAndroid construct(AccessibilityHierarchyProtos.WindowHierarchyElementProto proto) {
            this.parentId = proto.getParentId() != -1 ? Integer.valueOf(proto.getParentId()) : null;
            this.childIds.addAll(proto.getChildIdsList());
            this.windowId = proto.hasWindowId() ? Integer.valueOf(proto.getWindowId()) : null;
            this.layer = proto.hasLayer() ? Integer.valueOf(proto.getLayer()) : null;
            this.type = proto.hasType() ? Integer.valueOf(proto.getType()) : null;
            this.focused = proto.hasFocused() ? Boolean.valueOf(proto.getFocused()) : null;
            this.accessibilityFocused = proto.hasAccessibilityFocused() ? Boolean.valueOf(proto.getAccessibilityFocused()) : null;
            this.active = proto.hasActive() ? Boolean.valueOf(proto.getActive()) : null;
            this.boundsInScreen = proto.hasBoundsInScreen() ? new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(proto.getBoundsInScreen()) : null;
            int totalNodes = proto.getViewsCount();
            this.viewHierarchyElements = new ArrayList<ViewHierarchyElementAndroid>(totalNodes);
            for (AccessibilityHierarchyProtos.ViewHierarchyElementProto view : proto.getViewsList()) {
                this.viewHierarchyElements.add(ViewHierarchyElementAndroid.newBuilder(view).build());
            }
            return new WindowHierarchyElementAndroid(proto.getId(), this.parentId, this.childIds, this.windowId, this.layer, this.type, this.focused, this.accessibilityFocused, this.active, this.boundsInScreen, this.viewHierarchyElements);
        }

        private void populateOriginMaps(@Nullable Map<ViewHierarchyElementAndroid, View> elementToViewMap, @Nullable Map<ViewHierarchyElementAndroid, AccessibilityNodeInfo> elementToNodeInfoMap) {
            if (this.viewOriginMap != null) {
                for (Map.Entry entry : ((Map)Preconditions.checkNotNull(elementToViewMap)).entrySet()) {
                    this.viewOriginMap.put(((ViewHierarchyElementAndroid)entry.getKey()).getCondensedUniqueId(), (View)entry.getValue());
                }
            }
            if (this.nodeInfoOriginMap != null) {
                for (Map.Entry entry : ((Map)Preconditions.checkNotNull(elementToNodeInfoMap)).entrySet()) {
                    this.nodeInfoOriginMap.put(((ViewHierarchyElementAndroid)entry.getKey()).getCondensedUniqueId(), (AccessibilityNodeInfo)entry.getValue());
                }
            }
        }

        private void setWindow(WindowHierarchyElementAndroid window) {
            if (window.viewHierarchyElements != null) {
                for (ViewHierarchyElementAndroid view : window.viewHierarchyElements) {
                    view.setWindow(window);
                }
            }
        }
    }
}

