/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.os._Original_Build;
import android.view.View;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.base.Preconditions;

class Screenshotter {
    private static final String TAG = "Screenshotter";

    Screenshotter() {
    }

    public Bitmap getScreenshot(View view) {
        Preconditions.checkArgument((view.getWidth() > 0 ? 1 : 0) != 0, (Object)"View width must be >0");
        Preconditions.checkArgument((view.getHeight() > 0 ? 1 : 0) != 0, (Object)"View height must be >0");
        if (_Original_Build.VERSION.SDK_INT >= 28) {
            return Screenshotter.getScreenShotPPlus(view);
        }
        return Screenshotter.getScreenshotPreP(view);
    }

    private static Bitmap getScreenShotPPlus(View view) {
        LogUtils.i(TAG, ">= P", new Object[0]);
        Picture picture = new Picture();
        int[] windowOffset = Screenshotter.getWindowOffset(view);
        Canvas canvas = picture.beginRecording(windowOffset[0] + view.getWidth(), windowOffset[1] + view.getHeight());
        view.computeScroll();
        canvas.translate(windowOffset[0] - view.getScrollX(), windowOffset[1] - view.getScrollY());
        view.draw(canvas);
        picture.endRecording();
        Bitmap bitmap = Bitmap.createBitmap(picture, picture.getWidth(), picture.getHeight(), Bitmap.Config.ARGB_8888);
        return bitmap;
    }

    private static Bitmap getScreenshotPreP(View view) {
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        if (bitmap == null) {
            LogUtils.i(TAG, "PreP without drawing cache", new Object[0]);
            bitmap = Bitmap.createBitmap(view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888);
            bitmap.setDensity(view.getResources().getDisplayMetrics().densityDpi);
            view.computeScroll();
            Canvas canvas = new Canvas(bitmap);
            canvas.translate(-view.getScrollX(), -view.getScrollY());
            view.draw(canvas);
        } else {
            LogUtils.i(TAG, "PreP from drawing cache", new Object[0]);
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
            view.destroyDrawingCache();
        }
        return Screenshotter.expandBitmapIfWindowOffset(bitmap, view);
    }

    private static Bitmap expandBitmapIfWindowOffset(Bitmap bitmap, View view) {
        Rect destRect;
        int[] windowOffset = Screenshotter.getWindowOffset(view);
        if ((windowOffset[0] != 0 || windowOffset[1] != 0) && view.getGlobalVisibleRect(destRect = new Rect())) {
            LogUtils.i(TAG, "Resizing " + destRect, new Object[0]);
            Bitmap biggerBitmap = Bitmap.createBitmap(view.getWidth() + windowOffset[0], view.getHeight() + windowOffset[1], Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(biggerBitmap);
            destRect.offset(windowOffset[0], windowOffset[1]);
            canvas.drawBitmap(bitmap, null, destRect, null);
            return biggerBitmap;
        }
        return bitmap;
    }

    private static int[] getWindowOffset(View view) {
        int[] locationOnScreen = new int[2];
        int[] locationInWindow = new int[2];
        view.getLocationOnScreen(locationOnScreen);
        view.getLocationInWindow(locationInWindow);
        int xOffset = locationOnScreen[0] - locationInWindow[0];
        int yOffset = locationOnScreen[1] - locationInWindow[1];
        return new int[]{xOffset, yOffset};
    }
}

