/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.HardwareRenderer;
import android.graphics.LayoutlibRenderer;
import android.graphics.RenderNode;
import android.graphics.drawable.AnimatedVectorDrawable_VectorDrawableAnimatorUI_Delegate;
import android.media.Image;
import android.media.ImageReader;
import android.preference.Preference_Delegate;
import android.view.AttachInfo_Accessor;
import android.view.BridgeInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AbsSpinner;
import android.widget.ActionMenuView;
import android.widget.AdapterView;
import android.widget.ExpandableListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TabHost;
import android.widget.TabWidget;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.rendering.api.ViewType;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BridgeMenuItemImpl;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.ListMenuItemView;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.android.graphics.NopCanvas;
import com.android.layoutlib.bridge.android.support.DesignLibUtil;
import com.android.layoutlib.bridge.android.support.FragmentTabHostUtil;
import com.android.layoutlib.bridge.android.support.SupportPreferencesUtil;
import com.android.layoutlib.bridge.impl.Layout;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.SystemViewInfo;
import com.android.layoutlib.bridge.impl.binding.FakeAdapter;
import com.android.layoutlib.bridge.impl.binding.FakeExpandableAdapter;
import com.android.layoutlib.common.util.ReflectionUtils;
import com.android.tools.idea.validator.LayoutValidator;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.idea.validator.ValidatorHierarchy;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.utils.Pair;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchyAndroid_ViewElementClassNamesAndroid_Delegate;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;

public class RenderSessionImpl
extends RenderAction<SessionParams> {
    private static final Canvas NOP_CANVAS = new NopCanvas();
    private RenderSession mScene;
    private BridgeXmlBlockParser mBlockParser;
    private BridgeInflater mInflater;
    private ViewGroup mViewRoot;
    private FrameLayout mContentRoot;
    private int mMeasuredScreenWidth = -1;
    private int mMeasuredScreenHeight = -1;
    private long mElapsedFrameTimeNanos = -1L;
    private boolean mFirstFrameExecuted = false;
    private BufferedImage mImage;
    private List<ViewInfo> mViewInfoList;
    private List<ViewInfo> mSystemViewInfoList;
    private Layout.Builder mLayoutBuilder;
    private boolean mNewRenderSize;
    private ImageReader mImageReader;
    private Image mNativeImage;
    private LayoutlibRenderer mRenderer = new LayoutlibRenderer();
    private long mLastActionDownTimeNanos = -1L;
    private ValidatorResult mValidatorResult = null;
    private ValidatorHierarchy mValidatorHierarchy = null;

    public RenderSessionImpl(SessionParams params) {
        super(new SessionParams(params));
    }

    @Override
    public Result init(long timeout) {
        Result result = super.init(timeout);
        if (!result.isSuccess()) {
            return result;
        }
        SessionParams params = (SessionParams)this.getParams();
        BridgeContext context = this.getContext();
        this.mLayoutBuilder = new Layout.Builder(params, context);
        this.mInflater = new BridgeInflater(context, params.getLayoutlibCallback());
        context.setBridgeInflater(this.mInflater);
        ILayoutPullParser layoutParser = params.getLayoutDescription();
        this.mBlockParser = new BridgeXmlBlockParser((XmlPullParser)layoutParser, context, layoutParser.getLayoutNamespace());
        Bitmap.setDefaultDensity(params.getHardwareConfig().getDensity().getDpiValue());
        ImageReader.nativeClassInit();
        return Result.Status.SUCCESS.createResult();
    }

    private void measureLayout(SessionParams params) {
        SessionParams.RenderingMode renderingMode;
        int previousWidth = this.mMeasuredScreenWidth;
        int previousHeight = this.mMeasuredScreenHeight;
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        if (this.mMeasuredScreenWidth == -1) {
            this.mMeasuredScreenWidth = hardwareConfig.getScreenWidth();
            this.mMeasuredScreenHeight = hardwareConfig.getScreenHeight();
        }
        if ((renderingMode = params.getRenderingMode()) != SessionParams.RenderingMode.NORMAL) {
            int widthMeasureSpecMode = renderingMode.getHorizAction() == SessionParams.RenderingMode.SizeAction.EXPAND ? 0 : 0x40000000;
            int heightMeasureSpecMode = renderingMode.getVertAction() == SessionParams.RenderingMode.SizeAction.EXPAND ? 0 : 0x40000000;
            View measuredView = this.mContentRoot.getChildAt(0);
            if (measuredView == null) {
                return;
            }
            int maxWidth = hardwareConfig.getScreenWidth();
            int maxHeight = hardwareConfig.getScreenHeight();
            Pair<Integer, Integer> exactMeasure = RenderSessionImpl.measureView(this.mViewRoot, measuredView, maxWidth, 0x40000000, maxHeight, 0x40000000);
            Pair<Integer, Integer> neededMeasure = RenderSessionImpl.measureView(this.mContentRoot, measuredView, maxWidth, widthMeasureSpecMode, maxHeight, heightMeasureSpecMode);
            assert (exactMeasure != null && neededMeasure != null);
            this.mMeasuredScreenWidth = RenderSessionImpl.calcSize(this.mMeasuredScreenWidth, (Integer)neededMeasure.getFirst(), (Integer)exactMeasure.getFirst(), renderingMode.getHorizAction());
            this.mMeasuredScreenHeight = RenderSessionImpl.calcSize(this.mMeasuredScreenHeight, (Integer)neededMeasure.getSecond(), (Integer)exactMeasure.getSecond(), renderingMode.getVertAction());
        }
        this.mNewRenderSize = this.mMeasuredScreenWidth != previousWidth || this.mMeasuredScreenHeight != previousHeight;
    }

    private static int calcSize(int currentSize, int neededSize, int measuredSize, SessionParams.RenderingMode.SizeAction action) {
        if (action == SessionParams.RenderingMode.SizeAction.EXPAND) {
            if (neededSize > measuredSize) {
                currentSize += neededSize - measuredSize;
            }
            if (currentSize < measuredSize) {
                currentSize = measuredSize;
            }
        } else if (action == SessionParams.RenderingMode.SizeAction.SHRINK) {
            currentSize = neededSize;
        }
        return currentSize;
    }

    public Result inflate() {
        this.checkLock();
        try {
            View view;
            String rootTag;
            boolean isPreference;
            this.mViewRoot = new Layout(this.mLayoutBuilder);
            this.mLayoutBuilder = null;
            this.mContentRoot = ((Layout)this.mViewRoot).getContentRoot();
            SessionParams params = (SessionParams)this.getParams();
            BridgeContext context = this.getContext();
            if (Bridge.isLocaleRtl(params.getLocale())) {
                if (!params.isRtlSupported()) {
                    Bridge.getLog().warning("rtl-not-enabled", "You are using a right-to-left (RTL) locale but RTL is not enabled", null, null);
                } else if (params.getSimulatedPlatformVersion() != 0 && params.getSimulatedPlatformVersion() < 17) {
                    Bridge.getLog().warning("rtl-not-supported", "You are using a right-to-left (RTL) locale but RTL is not supported for API level < 17", null, null);
                }
            }
            boolean bl = isPreference = "PreferenceScreen".equals(rootTag = (String)params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG)) || SupportPreferencesUtil.isSupportRootTag(rootTag);
            if (isPreference) {
                view = SupportPreferencesUtil.inflatePreference(context, this.mBlockParser, this.mContentRoot);
                if (view == null) {
                    view = Preference_Delegate.inflatePreference(context, this.mBlockParser, this.mContentRoot);
                }
            } else {
                view = this.mInflater.inflate(this.mBlockParser, (ViewGroup)this.mContentRoot);
            }
            context.popParser();
            AttachInfo_Accessor.setAttachInfo(this.mViewRoot);
            this.postInflateProcess(view, params.getLayoutlibCallback(), isPreference ? view : null);
            this.mInflater.onDoneInflation();
            this.setActiveToolbar(view, context, params);
            this.measureLayout(params);
            RenderSessionImpl.measureView(this.mViewRoot, null, this.mMeasuredScreenWidth, 0x40000000, this.mMeasuredScreenHeight, 0x40000000);
            this.mViewRoot.layout(0, 0, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params.getExtendedViewInfoMode(), false);
            return Result.Status.SUCCESS.createResult();
        }
        catch (PostInflateException e) {
            return Result.Status.ERROR_INFLATION.createResult(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_INFLATION.createResult(t.getMessage(), t);
        }
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        this.mElapsedFrameTimeNanos = nanos;
    }

    private static void doLayout(BridgeContext context, ViewGroup viewRoot, int width, int height) {
        RenderSessionImpl.measureView(viewRoot, null, width, 0x40000000, height, 0x40000000);
        viewRoot.layout(0, 0, width, height);
        RenderSessionImpl.handleScrolling(context, viewRoot);
    }

    private static Result renderAndBuildResult(ViewGroup viewRoot, HardwareRenderer renderer) {
        AttachInfo_Accessor.dispatchOnPreDraw(viewRoot);
        RenderNode node = viewRoot.updateDisplayListIfDirty();
        renderer.setContentRoot(node);
        renderer.createRenderRequest().syncAndDraw();
        return Result.Status.SUCCESS.createResult();
    }

    public Result render(boolean freshRender) {
        return this.renderAndBuildResult(freshRender, false);
    }

    public Result measure() {
        return this.renderAndBuildResult(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result renderAndBuildResult(boolean freshRender, boolean onlyMeasure) {
        this.checkLock();
        SessionParams params = (SessionParams)this.getParams();
        try {
            if (this.mViewRoot == null) {
                return Result.Status.ERROR_NOT_INFLATED.createResult();
            }
            this.measureLayout(params);
            HardwareConfig hardwareConfig = params.getHardwareConfig();
            Result renderResult = Result.Status.SUCCESS.createResult();
            if (onlyMeasure) {
                this.mImage = null;
                this.disposeImageSurface();
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
            } else {
                boolean disableBitmapCaching = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING));
                if (this.mNewRenderSize || this.mImageReader == null || disableBitmapCaching) {
                    boolean enableImageResizing;
                    this.mImage = params.getImageFactory() != null ? params.getImageFactory().getImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight) : new BufferedImage(this.mMeasuredScreenWidth, this.mMeasuredScreenHeight, 2);
                    boolean bl = enableImageResizing = this.mImage.getWidth() != this.mMeasuredScreenWidth && this.mImage.getHeight() != this.mMeasuredScreenHeight && Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_KEY_RESULT_IMAGE_AUTO_SCALE));
                    if (enableImageResizing || this.mNewRenderSize) {
                        this.disposeImageSurface();
                    }
                    if (enableImageResizing) {
                        this.mRenderer.setScale((float)this.mImage.getWidth() * 1.0f / (float)this.mMeasuredScreenWidth, (float)this.mImage.getHeight() * 1.0f / (float)this.mMeasuredScreenHeight);
                    } else {
                        this.mRenderer.setScale(1.0f, 1.0f);
                    }
                    if (this.mImageReader == null) {
                        this.mImageReader = ImageReader.newInstance(this.mImage.getWidth(), this.mImage.getHeight(), 1, 1);
                        this.mRenderer.setSurface(this.mImageReader.getSurface());
                        this.mNativeImage = this.mImageReader.acquireNextImage();
                    }
                    this.mNewRenderSize = false;
                }
                RenderSessionImpl.doLayout(this.getContext(), this.mViewRoot, this.mMeasuredScreenWidth, this.mMeasuredScreenHeight);
                if (this.mElapsedFrameTimeNanos >= 0L) {
                    if (!this.mFirstFrameExecuted) {
                        AttachInfo_Accessor.dispatchOnPreDraw(this.mViewRoot);
                        this.mViewRoot.draw(NOP_CANVAS);
                        this.mFirstFrameExecuted = true;
                    }
                    AnimatedVectorDrawable_VectorDrawableAnimatorUI_Delegate.sFrameTime = this.mElapsedFrameTimeNanos / 1000000L;
                }
                TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
                float lightY = a.getDimension(3, 0.0f);
                float lightZ = a.getDimension(4, 0.0f);
                float lightRadius = a.getDimension(2, 0.0f);
                float ambientShadowAlpha = a.getFloat(0, 0.0f);
                float spotShadowAlpha = a.getFloat(1, 0.0f);
                a.recycle();
                this.mRenderer.setLightSourceGeometry(this.mMeasuredScreenWidth / 2, lightY, lightZ, lightRadius);
                this.mRenderer.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
                renderResult = RenderSessionImpl.renderAndBuildResult(this.mViewRoot, this.mRenderer);
                int[] imageData = ((DataBufferInt)this.mImage.getRaster().getDataBuffer()).getData();
                Image.Plane[] planes = this.mNativeImage.getPlanes();
                IntBuffer buff = planes[0].getBuffer().asIntBuffer();
                int len = buff.remaining();
                buff.get(imageData, 0, len);
            }
            this.mSystemViewInfoList = this.visitAllChildren(this.mViewRoot, 0, 0, params.getExtendedViewInfoMode(), false);
            boolean enableOptimization = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR_OPTIMIZATION));
            boolean enableLayoutValidation = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR));
            boolean enableLayoutValidationImageCheck = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR_IMAGE_CHECK));
            try {
                if (enableLayoutValidation && !this.getViewInfos().isEmpty()) {
                    BufferedImage imageToPass;
                    AccessibilityHierarchyAndroid_ViewElementClassNamesAndroid_Delegate.sLayoutlibCallback = this.getContext().getLayoutlibCallback();
                    BufferedImage bufferedImage = imageToPass = enableLayoutValidationImageCheck ? this.getImage() : null;
                    if (enableOptimization) {
                        ValidatorHierarchy hierarchy = LayoutValidator.buildHierarchy((View)this.getViewInfos().get(0).getViewObject(), imageToPass);
                        this.setValidatorHierarchy(hierarchy);
                    } else {
                        ValidatorResult validatorResult = LayoutValidator.validate((View)this.getViewInfos().get(0).getViewObject(), imageToPass);
                        this.setValidatorResult(validatorResult);
                    }
                }
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                if (enableOptimization) {
                    ValidatorHierarchy hierarchy = new ValidatorHierarchy();
                    hierarchy.mErrorMessage = sw.toString();
                    this.setValidatorHierarchy(hierarchy);
                } else {
                    ValidatorResult.Builder builder = new ValidatorResult.Builder();
                    builder.mIssues.add(new ValidatorData.Issue.IssueBuilder().setCategory("Unknown").setType(ValidatorData.Type.INTERNAL_ERROR).setMsg(sw.toString()).setLevel(ValidatorData.Level.ERROR).setSourceClass("RenderSessionImpl").build());
                    this.setValidatorResult(builder.build());
                }
            }
            finally {
                AccessibilityHierarchyAndroid_ViewElementClassNamesAndroid_Delegate.sLayoutlibCallback = null;
            }
            return renderResult;
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t.getMessage(), t);
        }
    }

    private static Pair<Integer, Integer> measureView(ViewGroup viewToMeasure, View measuredView, int width, int widthMode, int height, int heightMode) {
        int w_spec = View.MeasureSpec.makeMeasureSpec(width, widthMode);
        int h_spec = View.MeasureSpec.makeMeasureSpec(height, heightMode);
        viewToMeasure.measure(w_spec, h_spec);
        if (measuredView != null) {
            return Pair.of((Object)measuredView.getMeasuredWidth(), (Object)measuredView.getMeasuredHeight());
        }
        return null;
    }

    private void postInflateProcess(View view, LayoutlibCallback layoutlibCallback, View skip) throws PostInflateException {
        block12: {
            block14: {
                AdapterBinding binding;
                ResourceReference listRef;
                block15: {
                    block13: {
                        block11: {
                            if (view == skip) {
                                return;
                            }
                            if (!(view instanceof TabHost)) break block11;
                            this.setupTabHost((TabHost)view, layoutlibCallback);
                            break block12;
                        }
                        if (!(view instanceof QuickContactBadge)) break block13;
                        QuickContactBadge badge = (QuickContactBadge)view;
                        badge.setImageToDefault();
                        break block12;
                    }
                    if (!(view instanceof AdapterView)) break block14;
                    int id2 = view.getId();
                    BridgeContext context = this.getContext();
                    listRef = context.resolveId(id2);
                    if (listRef == null) break block12;
                    SessionParams params = (SessionParams)this.getParams();
                    binding = (AdapterBinding)params.getAdapterBindings().get(listRef);
                    if (binding == null) {
                        binding = layoutlibCallback.getAdapterBinding(listRef, context.getViewKey(view), (Object)view);
                    }
                    if (binding == null) break block12;
                    if (!(view instanceof AbsListView)) break block15;
                    if ((binding.getFooterCount() > 0 || binding.getHeaderCount() > 0) && view instanceof ListView) {
                        Pair<View, Boolean> pair;
                        int i;
                        ListView list = (ListView)view;
                        boolean skipCallbackParser = false;
                        int count = binding.getHeaderCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getHeaderAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addHeaderView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                        count = binding.getFooterCount();
                        for (i = 0; i < count; ++i) {
                            pair = context.inflateView(binding.getFooterAt(i), list, false, skipCallbackParser);
                            if (pair.getFirst() != null) {
                                list.addFooterView((View)pair.getFirst());
                            }
                            skipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
                        }
                    }
                    if (view instanceof ExpandableListView) {
                        ((ExpandableListView)view).setAdapter(new FakeExpandableAdapter(listRef, binding, layoutlibCallback));
                    } else {
                        ((AbsListView)view).setAdapter(new FakeAdapter(listRef, binding, layoutlibCallback));
                    }
                    break block12;
                }
                if (!(view instanceof AbsSpinner)) break block12;
                ((AbsSpinner)view).setAdapter(new FakeAdapter(listRef, binding, layoutlibCallback));
                break block12;
            }
            if (view instanceof ViewGroup) {
                this.mInflater.postInflateProcess(view);
                ViewGroup group = (ViewGroup)view;
                int count = group.getChildCount();
                for (int c = 0; c < count; ++c) {
                    View child = group.getChildAt(c);
                    this.postInflateProcess(child, layoutlibCallback, skip);
                }
            }
        }
    }

    private void setActiveToolbar(View view, BridgeContext context, SessionParams params) {
        View coordinatorLayout = this.findChildView(view, DesignLibUtil.CN_COORDINATOR_LAYOUT);
        if (coordinatorLayout == null) {
            return;
        }
        View appBar = this.findChildView(coordinatorLayout, DesignLibUtil.CN_APPBAR_LAYOUT);
        if (appBar == null) {
            return;
        }
        ViewGroup collapsingToolbar = (ViewGroup)this.findChildView(appBar, DesignLibUtil.CN_COLLAPSING_TOOLBAR_LAYOUT);
        if (collapsingToolbar == null) {
            return;
        }
        if (!this.hasToolbar(collapsingToolbar)) {
            return;
        }
        String title = params.getAppLabel();
        DesignLibUtil.setTitle(collapsingToolbar, title);
    }

    private View findChildView(View view, String[] className) {
        if (!(view instanceof ViewGroup)) {
            return null;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), className)) continue;
            return group.getChildAt(i);
        }
        return null;
    }

    private boolean hasToolbar(View collapsingToolbar) {
        if (!(collapsingToolbar instanceof ViewGroup)) {
            return false;
        }
        ViewGroup group = (ViewGroup)collapsingToolbar;
        for (int i = 0; i < group.getChildCount(); ++i) {
            if (!ReflectionUtils.isInstanceOf((Object)group.getChildAt(i), DesignLibUtil.CN_TOOLBAR)) continue;
            return true;
        }
        return false;
    }

    private static void handleScrolling(BridgeContext context, View view) {
        int scrollPosX = context.getScrollXPos(view);
        int scrollPosY = context.getScrollYPos(view);
        if (scrollPosX != 0 || scrollPosY != 0) {
            if (view.isNestedScrollingEnabled()) {
                int[] consumed = new int[2];
                int axis = scrollPosX != 0 ? 1 : 0;
                if (view.startNestedScroll(axis |= scrollPosY != 0 ? 2 : 0)) {
                    view.dispatchNestedPreScroll(scrollPosX, scrollPosY, consumed, null);
                    view.dispatchNestedScroll(consumed[0], consumed[1], scrollPosX, scrollPosY, null);
                    view.stopNestedScroll();
                    scrollPosX -= consumed[0];
                    scrollPosY -= consumed[1];
                }
            }
            if (scrollPosX != 0 || scrollPosY != 0) {
                view.scrollTo(scrollPosX, scrollPosY);
            }
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup group = (ViewGroup)view;
        for (int i = 0; i < group.getChildCount(); ++i) {
            View child = group.getChildAt(i);
            RenderSessionImpl.handleScrolling(context, child);
        }
    }

    private void setupTabHost(TabHost tabHost, LayoutlibCallback layoutlibCallback) throws PostInflateException {
        Object v = tabHost.findViewById(16908307);
        if (v == null) {
            throw new PostInflateException("TabHost requires a TabWidget with id \"android:id/tabs\".\n");
        }
        if (!(v instanceof TabWidget)) {
            throw new PostInflateException(String.format("TabHost requires a TabWidget with id \"android:id/tabs\".\nView found with id 'tabs' is '%s'", v.getClass().getCanonicalName()));
        }
        v = tabHost.findViewById(0x1020011);
        if (v == null) {
            throw new PostInflateException("TabHost requires a FrameLayout with id \"android:id/tabcontent\".");
        }
        if (!(v instanceof FrameLayout)) {
            throw new PostInflateException(String.format("TabHost requires a FrameLayout with id \"android:id/tabcontent\".\nView found with id 'tabcontent' is '%s'", v.getClass().getCanonicalName()));
        }
        FrameLayout content = (FrameLayout)v;
        int count = content.getChildCount();
        if (ReflectionUtils.isInstanceOf((Object)tabHost, FragmentTabHostUtil.CN_FRAGMENT_TAB_HOST)) {
            FragmentTabHostUtil.setup(tabHost, this.getContext());
        } else {
            tabHost.setup();
        }
        if (count == 0) {
            TabHost.TabSpec spec = tabHost.newTabSpec("tag").setIndicator("Tab Label", tabHost.getResources().getDrawable(17301569, null)).setContent(tag -> new LinearLayout(this.getContext()));
            tabHost.addTab(spec);
        } else {
            for (int i = 0; i < count; ++i) {
                View child = content.getChildAt(i);
                String tabSpec = String.format("tab_spec%d", i + 1);
                int id2 = child.getId();
                ResourceReference resource = layoutlibCallback.resolveResourceId(id2);
                String name = resource != null ? resource.getName() : String.format("Tab %d", i + 1);
                tabHost.addTab(tabHost.newTabSpec(tabSpec).setIndicator(name).setContent(id2));
            }
        }
    }

    private ViewInfo visit(View view, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        ViewInfo result = this.createViewInfo(view, hOffset, vOffset, setExtendedInfo, isContentFrame);
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            result.setChildren(this.visitAllChildren(group, isContentFrame ? 0 : hOffset, isContentFrame ? 0 : vOffset, setExtendedInfo, isContentFrame));
        }
        return result;
    }

    private List<ViewInfo> visitAllChildren(ViewGroup viewGroup, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        if (viewGroup == null) {
            return null;
        }
        if (!isContentFrame) {
            vOffset += viewGroup.getTop();
            hOffset += viewGroup.getLeft();
        }
        int childCount = viewGroup.getChildCount();
        if (viewGroup == this.mContentRoot) {
            ArrayList<ViewInfo> childrenWithoutOffset = new ArrayList<ViewInfo>(childCount);
            ArrayList<ViewInfo> childrenWithOffset = new ArrayList<ViewInfo>(childCount);
            for (int i = 0; i < childCount; ++i) {
                ViewInfo[] childViewInfo = this.visitContentRoot(viewGroup.getChildAt(i), hOffset, vOffset, setExtendedInfo);
                childrenWithoutOffset.add(childViewInfo[0]);
                childrenWithOffset.add(childViewInfo[1]);
            }
            this.mViewInfoList = childrenWithOffset;
            return childrenWithoutOffset;
        }
        ArrayList<ViewInfo> children = new ArrayList<ViewInfo>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add(this.visit(viewGroup.getChildAt(i), hOffset, vOffset, setExtendedInfo, isContentFrame));
        }
        return children;
    }

    private ViewInfo[] visitContentRoot(View view, int hOffset, int vOffset, boolean setExtendedInfo) {
        ViewInfo[] result = new ViewInfo[2];
        if (view == null) {
            return result;
        }
        result[0] = this.createViewInfo(view, 0, 0, setExtendedInfo, true);
        result[1] = this.createViewInfo(view, hOffset, vOffset, setExtendedInfo, true);
        if (view instanceof ViewGroup) {
            List<ViewInfo> children = this.visitAllChildren((ViewGroup)view, 0, 0, setExtendedInfo, true);
            result[0].setChildren(children);
            result[1].setChildren(children);
        }
        return result;
    }

    private ViewInfo createViewInfo(View view, int hOffset, int vOffset, boolean setExtendedInfo, boolean isContentFrame) {
        SystemViewInfo result;
        ViewParent parent;
        if (view == null) {
            return null;
        }
        if (isContentFrame) {
            int scrollX = parent != null ? ((View)((Object)parent)).getScrollX() : 0;
            int scrollY = parent != null ? ((View)((Object)parent)).getScrollY() : 0;
            int shiftX = -scrollX + Math.round(view.getTranslationX()) + hOffset;
            int shiftY = -scrollY + Math.round(view.getTranslationY()) + vOffset;
            result = new ViewInfo(view.getClass().getName(), this.getContext().getViewKey(view), shiftX + view.getLeft(), shiftY + view.getTop(), shiftX + view.getRight(), shiftY + view.getBottom(), (Object)view, (Object)view.getLayoutParams());
        } else {
            SystemViewInfo r;
            result = r = new SystemViewInfo(view.getClass().getName(), this.getViewKey(view), view.getLeft(), view.getTop(), view.getRight(), view.getBottom(), view, view.getLayoutParams());
            if (view instanceof ListMenuItemView) {
                r.setViewType(ViewType.ACTION_BAR_OVERFLOW_MENU);
            } else {
                ViewGroup.LayoutParams lp = view.getLayoutParams();
                if (lp instanceof ActionMenuView.LayoutParams && ((ActionMenuView.LayoutParams)lp).isOverflowButton) {
                    r.setViewType(ViewType.ACTION_BAR_OVERFLOW);
                } else {
                    for (parent = view.getParent(); parent != this.mViewRoot && parent instanceof ViewGroup; parent = parent.getParent()) {
                        if (!(parent instanceof ActionMenuView)) continue;
                        r.setViewType(ViewType.ACTION_BAR_MENU);
                        break;
                    }
                }
            }
        }
        if (setExtendedInfo) {
            ViewGroup.MarginLayoutParams marginParams = null;
            ViewGroup.LayoutParams params = view.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                marginParams = (ViewGroup.MarginLayoutParams)params;
            }
            result.setExtendedInfo(view.getBaseline(), marginParams != null ? marginParams.leftMargin : 0, marginParams != null ? marginParams.topMargin : 0, marginParams != null ? marginParams.rightMargin : 0, marginParams != null ? marginParams.bottomMargin : 0);
        }
        return result;
    }

    private Object getViewKey(View view) {
        BridgeContext context = this.getContext();
        if (!(view instanceof MenuView.ItemView)) {
            return context.getViewKey(view);
        }
        MenuItemImpl menuItem = view instanceof ActionMenuItemView ? ((ActionMenuItemView)view).getItemData() : (view instanceof ListMenuItemView ? ((ListMenuItemView)view).getItemData() : (view instanceof IconMenuItemView ? ((IconMenuItemView)view).getItemData() : null));
        if (menuItem instanceof BridgeMenuItemImpl) {
            return ((BridgeMenuItemImpl)menuItem).getViewCookie();
        }
        return null;
    }

    public void invalidateRenderingSize() {
        this.mMeasuredScreenHeight = -1;
        this.mMeasuredScreenWidth = -1;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public List<ViewInfo> getViewInfos() {
        return this.mViewInfoList;
    }

    public List<ViewInfo> getSystemViewInfos() {
        return this.mSystemViewInfoList;
    }

    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultNamespacedProperties() {
        return this.getContext().getDefaultProperties();
    }

    public Map<Object, String> getDefaultStyles() {
        IdentityHashMap<Object, String> defaultStyles = new IdentityHashMap<Object, String>();
        Map<Object, ResourceReference> namespacedStyles = this.getDefaultNamespacedStyles();
        for (Object key : namespacedStyles.keySet()) {
            ResourceReference style2 = namespacedStyles.get(key);
            defaultStyles.put(key, style2.getQualifiedName());
        }
        return defaultStyles;
    }

    public Map<Object, ResourceReference> getDefaultNamespacedStyles() {
        return this.getContext().getDefaultNamespacedStyles();
    }

    public ValidatorResult getValidatorResult() {
        return this.mValidatorResult;
    }

    public void setValidatorResult(ValidatorResult result) {
        this.mValidatorResult = result;
    }

    public boolean isLayoutValidatorOptimizationEnabled() {
        return Boolean.TRUE.equals(((SessionParams)this.getParams()).getFlag(RenderParamsFlags.FLAG_ENABLE_LAYOUT_VALIDATOR_OPTIMIZATION));
    }

    public ValidatorHierarchy getValidatorHierarchy() {
        return this.mValidatorHierarchy;
    }

    public void setValidatorHierarchy(ValidatorHierarchy validatorHierarchy) {
        this.mValidatorHierarchy = validatorHierarchy;
    }

    public void setScene(RenderSession session) {
        this.mScene = session;
    }

    public RenderSession getSession() {
        return this.mScene;
    }

    public void dispatchTouchEvent(int motionEventType, long currentTimeNanos, float x, float y) {
        if (this.mViewRoot == null) {
            return;
        }
        if (motionEventType == 0) {
            this.mLastActionDownTimeNanos = currentTimeNanos;
        }
        if (this.mLastActionDownTimeNanos == -1L) {
            return;
        }
        MotionEvent event = MotionEvent.obtain(this.mLastActionDownTimeNanos, currentTimeNanos, motionEventType, x, y, 0);
        this.mViewRoot.dispatchTouchEvent(event);
    }

    private void disposeImageSurface() {
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
    }

    public void dispose() {
        try {
            this.mRenderer.destroy();
            this.disposeImageSurface();
            this.mImage = null;
            AttachInfo_Accessor.detachFromWindow(this.mViewRoot);
            this.getContext().getSessionInteractiveData().dispose();
            if (this.mViewInfoList != null) {
                this.mViewInfoList.clear();
            }
            if (this.mSystemViewInfoList != null) {
                this.mSystemViewInfoList.clear();
            }
            this.mValidatorResult = null;
            this.mValidatorHierarchy = null;
            this.mViewRoot = null;
            this.mContentRoot = null;
        }
        catch (Throwable t) {
            this.getContext().error("Error while disposing a RenderSession", t);
        }
    }

    private static final class PostInflateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PostInflateException(String message) {
            super(message);
        }
    }
}

