/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionInspector;
import android.view.inputmethod.InputContentInfo;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.ICharSequenceResultCallback;
import com.android.internal.inputmethod.IExtractedTextResultCallback;
import com.android.internal.inputmethod.IIntResultCallback;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputContext;

public abstract class IInputConnectionWrapper
extends IInputContext.Stub {
    private static final String TAG = "IInputConnectionWrapper";
    private static final boolean DEBUG = false;
    private static final int DO_GET_TEXT_AFTER_CURSOR = 10;
    private static final int DO_GET_TEXT_BEFORE_CURSOR = 20;
    private static final int DO_GET_SELECTED_TEXT = 25;
    private static final int DO_GET_CURSOR_CAPS_MODE = 30;
    private static final int DO_GET_EXTRACTED_TEXT = 40;
    private static final int DO_COMMIT_TEXT = 50;
    private static final int DO_COMMIT_COMPLETION = 55;
    private static final int DO_COMMIT_CORRECTION = 56;
    private static final int DO_SET_SELECTION = 57;
    private static final int DO_PERFORM_EDITOR_ACTION = 58;
    private static final int DO_PERFORM_CONTEXT_MENU_ACTION = 59;
    private static final int DO_SET_COMPOSING_TEXT = 60;
    private static final int DO_SET_COMPOSING_REGION = 63;
    private static final int DO_FINISH_COMPOSING_TEXT = 65;
    private static final int DO_SEND_KEY_EVENT = 70;
    private static final int DO_DELETE_SURROUNDING_TEXT = 80;
    private static final int DO_DELETE_SURROUNDING_TEXT_IN_CODE_POINTS = 81;
    private static final int DO_BEGIN_BATCH_EDIT = 90;
    private static final int DO_END_BATCH_EDIT = 95;
    private static final int DO_PERFORM_PRIVATE_COMMAND = 120;
    private static final int DO_CLEAR_META_KEY_STATES = 130;
    private static final int DO_REQUEST_UPDATE_CURSOR_ANCHOR_INFO = 140;
    private static final int DO_CLOSE_CONNECTION = 150;
    private static final int DO_COMMIT_CONTENT = 160;
    @GuardedBy(value={"mLock"})
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private InputConnection mInputConnection;
    private Looper mMainLooper;
    private Handler mH;
    @UnsupportedAppUsage
    private Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mFinished = false;

    public IInputConnectionWrapper(Looper mainLooper, InputConnection inputConnection) {
        this.mInputConnection = inputConnection;
        this.mMainLooper = mainLooper;
        this.mH = new MyHandler(this.mMainLooper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputConnection getInputConnection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFinished() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFinished;
        }
    }

    protected abstract boolean isActive();

    @Override
    public void getTextAfterCursor(int length, int flags, ICharSequenceResultCallback callback) {
        this.dispatchMessage(this.mH.obtainMessage(10, length, flags, callback));
    }

    @Override
    public void getTextBeforeCursor(int length, int flags, ICharSequenceResultCallback callback) {
        this.dispatchMessage(this.mH.obtainMessage(20, length, flags, callback));
    }

    @Override
    public void getSelectedText(int flags, ICharSequenceResultCallback callback) {
        this.dispatchMessage(this.mH.obtainMessage(25, flags, 0, callback));
    }

    @Override
    public void getCursorCapsMode(int reqModes, IIntResultCallback callback) {
        this.dispatchMessage(this.mH.obtainMessage(30, reqModes, 0, callback));
    }

    @Override
    public void getExtractedText(ExtractedTextRequest request, int flags, IExtractedTextResultCallback callback) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = request;
        args.arg2 = callback;
        this.dispatchMessage(this.mH.obtainMessage(40, flags, 0, args));
    }

    @Override
    public void commitText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(50, newCursorPosition, text));
    }

    @Override
    public void commitCompletion(CompletionInfo text) {
        this.dispatchMessage(this.obtainMessageO(55, text));
    }

    @Override
    public void commitCorrection(CorrectionInfo info) {
        this.dispatchMessage(this.obtainMessageO(56, info));
    }

    @Override
    public void setSelection(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(57, start, end));
    }

    @Override
    public void performEditorAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(58, id2, 0));
    }

    @Override
    public void performContextMenuAction(int id2) {
        this.dispatchMessage(this.obtainMessageII(59, id2, 0));
    }

    @Override
    public void setComposingRegion(int start, int end) {
        this.dispatchMessage(this.obtainMessageII(63, start, end));
    }

    @Override
    public void setComposingText(CharSequence text, int newCursorPosition) {
        this.dispatchMessage(this.obtainMessageIO(60, newCursorPosition, text));
    }

    @Override
    public void finishComposingText() {
        this.dispatchMessage(this.obtainMessage(65));
    }

    @Override
    public void sendKeyEvent(KeyEvent event) {
        this.dispatchMessage(this.obtainMessageO(70, event));
    }

    @Override
    public void clearMetaKeyStates(int states) {
        this.dispatchMessage(this.obtainMessageII(130, states, 0));
    }

    @Override
    public void deleteSurroundingText(int beforeLength, int afterLength) {
        this.dispatchMessage(this.obtainMessageII(80, beforeLength, afterLength));
    }

    @Override
    public void deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        this.dispatchMessage(this.obtainMessageII(81, beforeLength, afterLength));
    }

    @Override
    public void beginBatchEdit() {
        this.dispatchMessage(this.obtainMessage(90));
    }

    @Override
    public void endBatchEdit() {
        this.dispatchMessage(this.obtainMessage(95));
    }

    @Override
    public void performPrivateCommand(String action, Bundle data) {
        this.dispatchMessage(this.obtainMessageOO(120, action, data));
    }

    @Override
    public void requestUpdateCursorAnchorInfo(int cursorUpdateMode, IIntResultCallback callback) {
        this.dispatchMessage(this.mH.obtainMessage(140, cursorUpdateMode, 0, callback));
    }

    public void closeConnection() {
        this.dispatchMessage(this.obtainMessage(150));
    }

    @Override
    public void commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts, IIntResultCallback callback) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = inputContentInfo;
        args.arg2 = opts;
        args.arg3 = callback;
        this.dispatchMessage(this.mH.obtainMessage(160, flags, 0, args));
    }

    void dispatchMessage(Message msg) {
        if (Looper.myLooper() == this.mMainLooper) {
            this.executeMessage(msg);
            msg.recycle();
            return;
        }
        this.mH.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeMessage(Message msg) {
        switch (msg.what) {
            case 10: {
                CharSequence result;
                ICharSequenceResultCallback callback = (ICharSequenceResultCallback)msg.obj;
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "getTextAfterCursor on inactive InputConnection");
                    result = null;
                } else {
                    result = ic.getTextAfterCursor(msg.arg1, msg.arg2);
                }
                try {
                    callback.onResult(result);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to return the result to getTextAfterCursor(). result=" + result, e);
                }
                return;
            }
            case 20: {
                CharSequence result;
                ICharSequenceResultCallback callback = (ICharSequenceResultCallback)msg.obj;
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "getTextBeforeCursor on inactive InputConnection");
                    result = null;
                } else {
                    result = ic.getTextBeforeCursor(msg.arg1, msg.arg2);
                }
                try {
                    callback.onResult(result);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to return the result to getTextBeforeCursor(). result=" + result, e);
                }
                return;
            }
            case 25: {
                CharSequence result;
                ICharSequenceResultCallback callback = (ICharSequenceResultCallback)msg.obj;
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "getSelectedText on inactive InputConnection");
                    result = null;
                } else {
                    result = ic.getSelectedText(msg.arg1);
                }
                try {
                    callback.onResult(result);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to return the result to getSelectedText(). result=" + result, e);
                }
                return;
            }
            case 30: {
                int result;
                IIntResultCallback callback = (IIntResultCallback)msg.obj;
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "getCursorCapsMode on inactive InputConnection");
                    result = 0;
                } else {
                    result = ic.getCursorCapsMode(msg.arg1);
                }
                try {
                    callback.onResult(result);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to return the result to getCursorCapsMode(). result=" + result, e);
                }
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    ExtractedText result;
                    ExtractedTextRequest request = (ExtractedTextRequest)args.arg1;
                    IExtractedTextResultCallback callback = (IExtractedTextResultCallback)args.arg2;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "getExtractedText on inactive InputConnection");
                        result = null;
                    } else {
                        result = ic.getExtractedText(request, msg.arg1);
                    }
                    try {
                        callback.onResult(result);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to getExtractedText(). result=" + result, e);
                    }
                }
                finally {
                    args.recycle();
                }
                return;
            }
            case 50: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitText on inactive InputConnection");
                    return;
                }
                ic.commitText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 57: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setSelection on inactive InputConnection");
                    return;
                }
                ic.setSelection(msg.arg1, msg.arg2);
                return;
            }
            case 58: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "performEditorAction on inactive InputConnection");
                    return;
                }
                ic.performEditorAction(msg.arg1);
                return;
            }
            case 59: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "performContextMenuAction on inactive InputConnection");
                    return;
                }
                ic.performContextMenuAction(msg.arg1);
                return;
            }
            case 55: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitCompletion on inactive InputConnection");
                    return;
                }
                ic.commitCompletion((CompletionInfo)msg.obj);
                return;
            }
            case 56: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "commitCorrection on inactive InputConnection");
                    return;
                }
                ic.commitCorrection((CorrectionInfo)msg.obj);
                return;
            }
            case 60: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setComposingText on inactive InputConnection");
                    return;
                }
                ic.setComposingText((CharSequence)msg.obj, msg.arg1);
                return;
            }
            case 63: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "setComposingRegion on inactive InputConnection");
                    return;
                }
                ic.setComposingRegion(msg.arg1, msg.arg2);
                return;
            }
            case 65: {
                if (this.isFinished()) {
                    return;
                }
                InputConnection ic = this.getInputConnection();
                if (ic == null) {
                    Log.w(TAG, "finishComposingText on inactive InputConnection");
                    return;
                }
                ic.finishComposingText();
                return;
            }
            case 70: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "sendKeyEvent on inactive InputConnection");
                    return;
                }
                ic.sendKeyEvent((KeyEvent)msg.obj);
                return;
            }
            case 130: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "clearMetaKeyStates on inactive InputConnection");
                    return;
                }
                ic.clearMetaKeyStates(msg.arg1);
                return;
            }
            case 80: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "deleteSurroundingText on inactive InputConnection");
                    return;
                }
                ic.deleteSurroundingText(msg.arg1, msg.arg2);
                return;
            }
            case 81: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "deleteSurroundingTextInCodePoints on inactive InputConnection");
                    return;
                }
                ic.deleteSurroundingTextInCodePoints(msg.arg1, msg.arg2);
                return;
            }
            case 90: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "beginBatchEdit on inactive InputConnection");
                    return;
                }
                ic.beginBatchEdit();
                return;
            }
            case 95: {
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "endBatchEdit on inactive InputConnection");
                    return;
                }
                ic.endBatchEdit();
                return;
            }
            case 120: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    String action = (String)args.arg1;
                    Bundle data = (Bundle)args.arg2;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "performPrivateCommand on inactive InputConnection");
                        return;
                    }
                    ic.performPrivateCommand(action, data);
                }
                finally {
                    args.recycle();
                }
                return;
            }
            case 140: {
                boolean result;
                IIntResultCallback callback = (IIntResultCallback)msg.obj;
                InputConnection ic = this.getInputConnection();
                if (ic == null || !this.isActive()) {
                    Log.w(TAG, "requestCursorAnchorInfo on inactive InputConnection");
                    result = false;
                } else {
                    result = ic.requestCursorUpdates(msg.arg1);
                }
                try {
                    callback.onResult(result ? 1 : 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to return the result to requestCursorUpdates(). result=" + result, e);
                }
                return;
            }
            case 150: {
                if (this.isFinished()) {
                    return;
                }
                try {
                    InputConnection ic = this.getInputConnection();
                    if (ic == null) {
                        return;
                    }
                    int missingMethods = InputConnectionInspector.getMissingMethodFlags(ic);
                    if ((missingMethods & 0x40) == 0) {
                        ic.closeConnection();
                    }
                }
                finally {
                    Object ic = this.mLock;
                    synchronized (ic) {
                        this.mInputConnection = null;
                        this.mFinished = true;
                    }
                }
                return;
            }
            case 160: {
                int flags = msg.arg1;
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    boolean result;
                    IIntResultCallback callback = (IIntResultCallback)args.arg3;
                    InputConnection ic = this.getInputConnection();
                    if (ic == null || !this.isActive()) {
                        Log.w(TAG, "commitContent on inactive InputConnection");
                        result = false;
                    } else {
                        InputContentInfo inputContentInfo = (InputContentInfo)args.arg1;
                        if (inputContentInfo == null || !inputContentInfo.validate()) {
                            Log.w(TAG, "commitContent with invalid inputContentInfo=" + inputContentInfo);
                            result = false;
                        } else {
                            result = ic.commitContent(inputContentInfo, flags, (Bundle)args.arg2);
                        }
                    }
                    try {
                        callback.onResult(result ? 1 : 0);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Failed to return the result to commitContent(). result=" + result, e);
                    }
                }
                finally {
                    args.recycle();
                }
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    Message obtainMessage(int what) {
        return this.mH.obtainMessage(what);
    }

    Message obtainMessageII(int what, int arg1, int arg2) {
        return this.mH.obtainMessage(what, arg1, arg2);
    }

    Message obtainMessageO(int what, Object arg1) {
        return this.mH.obtainMessage(what, 0, 0, arg1);
    }

    Message obtainMessageIO(int what, int arg1, Object arg2) {
        return this.mH.obtainMessage(what, arg1, 0, arg2);
    }

    Message obtainMessageOO(int what, Object arg1, Object arg2) {
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = arg1;
        args.arg2 = arg2;
        return this.mH.obtainMessage(what, 0, 0, args);
    }

    class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            IInputConnectionWrapper.this.executeMessage(msg);
        }
    }
}

