/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.os.Binder;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LocationPermissionChecker {
    private static final String TAG = "LocationPermissionChecker";
    public static final int SUCCEEDED = 0;
    public static final int ERROR_LOCATION_MODE_OFF = 1;
    public static final int ERROR_LOCATION_PERMISSION_MISSING = 2;
    private final Context mContext;
    private final AppOpsManager mAppOpsManager;

    public LocationPermissionChecker(Context context) {
        this.mContext = context;
        this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
    }

    public boolean checkLocationPermission(String pkgName, String featureId, int uid, String message) {
        return this.checkLocationPermissionInternal(pkgName, featureId, uid, message) == 0;
    }

    public int checkLocationPermissionWithDetailInfo(String pkgName, String featureId, int uid, String message) {
        int result = this.checkLocationPermissionInternal(pkgName, featureId, uid, message);
        switch (result) {
            case 1: {
                Log.e(TAG, "Location mode is disabled for the device");
                break;
            }
            case 2: {
                Log.e(TAG, "UID " + uid + " has no location permission");
            }
        }
        return result;
    }

    public void enforceLocationPermission(String pkgName, String featureId, int uid, String message) throws SecurityException {
        int result = this.checkLocationPermissionInternal(pkgName, featureId, uid, message);
        switch (result) {
            case 1: {
                throw new SecurityException("Location mode is disabled for the device");
            }
            case 2: {
                throw new SecurityException("UID " + uid + " has no location permission");
            }
        }
    }

    private int checkLocationPermissionInternal(String pkgName, String featureId, int uid, String message) {
        this.checkPackage(uid, pkgName);
        if (!this.isLocationModeEnabled()) {
            return 1;
        }
        if (!this.checkCallersLocationPermission(pkgName, featureId, uid, true, message)) {
            return 2;
        }
        return 0;
    }

    public boolean checkCallersLocationPermission(String pkgName, String featureId, int uid, boolean coarseForTargetSdkLessThanQ, String message) {
        boolean isTargetSdkLessThanQ = this.isTargetSdkLessThan(pkgName, 29, uid);
        String permissionType = "android.permission.ACCESS_FINE_LOCATION";
        if (coarseForTargetSdkLessThanQ && isTargetSdkLessThanQ) {
            permissionType = "android.permission.ACCESS_COARSE_LOCATION";
        }
        if (this.getUidPermission(permissionType, uid) == -1) {
            return false;
        }
        boolean isFineLocationAllowed = this.noteAppOpAllowed("android:fine_location", pkgName, featureId, uid, message);
        if (isFineLocationAllowed) {
            return true;
        }
        if (coarseForTargetSdkLessThanQ && isTargetSdkLessThanQ) {
            return this.noteAppOpAllowed("android:coarse_location", pkgName, featureId, uid, message);
        }
        return false;
    }

    public boolean isLocationModeEnabled() {
        LocationManager LocationManager2 = (LocationManager)this.mContext.getSystemService("location");
        try {
            return LocationManager2.isLocationEnabledForUser(UserHandle.of(this.getCurrentUser()));
        }
        catch (Exception e) {
            Log.e(TAG, "Failure to get location mode via API, falling back to settings", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTargetSdkLessThan(String packageName, int versionCode, int callingUid) {
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.mContext.getPackageManager().getApplicationInfoAsUser((String)packageName, (int)0, (UserHandle)UserHandle.getUserHandleForUid((int)callingUid)).targetSdkVersion < versionCode) {
                boolean bl = true;
                return bl;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return false;
    }

    private boolean noteAppOpAllowed(String op, String pkgName, String featureId, int uid, String message) {
        return this.mAppOpsManager.noteOp(op, uid, pkgName, featureId, message) == 0;
    }

    private void checkPackage(int uid, String pkgName) throws SecurityException {
        if (pkgName == null) {
            throw new SecurityException("Checking UID " + uid + " but Package Name is Null");
        }
        this.mAppOpsManager.checkPackage(uid, pkgName);
    }

    @VisibleForTesting
    protected int getCurrentUser() {
        return ActivityManager.getCurrentUser();
    }

    private int getUidPermission(String permissionType, int uid) {
        return this.mContext.checkPermission(permissionType, -1, uid);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationPermissionCheckStatus {
    }
}

