/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class KernelCpuUidBpfMapReader {
    private static final int ERROR_THRESHOLD = 5;
    private static final long FRESHNESS_MS = 500L;
    private static final KernelCpuUidBpfMapReader FREQ_TIME_READER = new KernelCpuUidFreqTimeBpfMapReader();
    private static final KernelCpuUidBpfMapReader ACTIVE_TIME_READER = new KernelCpuUidActiveTimeBpfMapReader();
    private static final KernelCpuUidBpfMapReader CLUSTER_TIME_READER = new KernelCpuUidClusterTimeBpfMapReader();
    final String mTag = this.getClass().getSimpleName();
    private int mErrors = 0;
    private boolean mTracking = false;
    protected SparseArray<long[]> mData = new SparseArray();
    private long mLastReadTime = 0L;
    protected final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    protected final ReentrantReadWriteLock.ReadLock mReadLock = this.mLock.readLock();
    protected final ReentrantReadWriteLock.WriteLock mWriteLock = this.mLock.writeLock();

    static KernelCpuUidBpfMapReader getFreqTimeReaderInstance() {
        return FREQ_TIME_READER;
    }

    static KernelCpuUidBpfMapReader getActiveTimeReaderInstance() {
        return ACTIVE_TIME_READER;
    }

    static KernelCpuUidBpfMapReader getClusterTimeReaderInstance() {
        return CLUSTER_TIME_READER;
    }

    public boolean startTrackingBpfTimes() {
        return OverrideMethod.invokeI("com.android.internal.os.KernelCpuUidBpfMapReader#startTrackingBpfTimes()Z", true, this) != 0;
    }

    protected abstract boolean readBpfData();

    public abstract long[] getDataDimensions();

    public void removeUidsInRange(int startUid, int endUid) {
        if (this.mErrors > 5) {
            return;
        }
        this.mWriteLock.lock();
        int firstIndex = this.mData.indexOfKey(startUid);
        int lastIndex = this.mData.indexOfKey(endUid);
        this.mData.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
        this.mWriteLock.unlock();
    }

    public BpfMapIterator open() {
        return this.open(false);
    }

    public BpfMapIterator open(boolean ignoreCache) {
        if (this.mErrors > 5) {
            return null;
        }
        if (!this.mTracking && !this.startTrackingBpfTimes()) {
            Slog.w(this.mTag, "Failed to start tracking");
            ++this.mErrors;
            return null;
        }
        if (ignoreCache) {
            this.mWriteLock.lock();
        } else {
            this.mReadLock.lock();
            if (this.dataValid()) {
                return new BpfMapIterator();
            }
            this.mReadLock.unlock();
            this.mWriteLock.lock();
            if (this.dataValid()) {
                this.mReadLock.lock();
                this.mWriteLock.unlock();
                return new BpfMapIterator();
            }
        }
        if (this.readBpfData()) {
            this.mLastReadTime = SystemClock.elapsedRealtime();
            this.mReadLock.lock();
            this.mWriteLock.unlock();
            return new BpfMapIterator();
        }
        this.mWriteLock.unlock();
        ++this.mErrors;
        Slog.w(this.mTag, "Failed to read bpf times");
        return null;
    }

    private boolean dataValid() {
        return this.mData.size() > 0 && SystemClock.elapsedRealtime() - this.mLastReadTime < 500L;
    }

    public static class KernelCpuUidClusterTimeBpfMapReader
    extends KernelCpuUidBpfMapReader {
        @Override
        protected boolean readBpfData() {
            return OverrideMethod.invokeI("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidClusterTimeBpfMapReader#readBpfData()Z", true, this) != 0;
        }

        @Override
        public long[] getDataDimensions() {
            return (long[])OverrideMethod.invokeA("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidClusterTimeBpfMapReader#getDataDimensions()[J", true, this);
        }
    }

    public static class KernelCpuUidActiveTimeBpfMapReader
    extends KernelCpuUidBpfMapReader {
        @Override
        protected boolean readBpfData() {
            return OverrideMethod.invokeI("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidActiveTimeBpfMapReader#readBpfData()Z", true, this) != 0;
        }

        @Override
        public long[] getDataDimensions() {
            return (long[])OverrideMethod.invokeA("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidActiveTimeBpfMapReader#getDataDimensions()[J", true, this);
        }
    }

    public static class KernelCpuUidFreqTimeBpfMapReader
    extends KernelCpuUidBpfMapReader {
        private boolean removeUidRange(int n, int n2) {
            return OverrideMethod.invokeI("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidFreqTimeBpfMapReader#removeUidRange(II)Z", true, this) != 0;
        }

        @Override
        protected boolean readBpfData() {
            return OverrideMethod.invokeI("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidFreqTimeBpfMapReader#readBpfData()Z", true, this) != 0;
        }

        @Override
        public long[] getDataDimensions() {
            return (long[])OverrideMethod.invokeA("com.android.internal.os.KernelCpuUidBpfMapReader$KernelCpuUidFreqTimeBpfMapReader#getDataDimensions()[J", true, this);
        }

        @Override
        public void removeUidsInRange(int startUid, int endUid) {
            this.mWriteLock.lock();
            super.removeUidsInRange(startUid, endUid);
            this.removeUidRange(startUid, endUid);
            this.mWriteLock.unlock();
        }
    }

    public class BpfMapIterator
    implements AutoCloseable {
        private int mPos;

        public boolean getNextUid(long[] buf) {
            if (this.mPos >= KernelCpuUidBpfMapReader.this.mData.size()) {
                return false;
            }
            buf[0] = KernelCpuUidBpfMapReader.this.mData.keyAt(this.mPos);
            System.arraycopy(KernelCpuUidBpfMapReader.this.mData.valueAt(this.mPos), 0, buf, 1, KernelCpuUidBpfMapReader.this.mData.valueAt(this.mPos).length);
            ++this.mPos;
            return true;
        }

        @Override
        public void close() {
            KernelCpuUidBpfMapReader.this.mReadLock.unlock();
        }
    }
}

