/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityOptions;
import android.app.ActivityTaskManager;
import android.app.IActivityTaskManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutInfo;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.os.UserHandle;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.SurfaceControl;
import android.view.WindowManagerGlobal;
import dalvik.system.CloseGuard;

public abstract class TaskEmbedder {
    private static final String TAG = "TaskEmbedder";
    protected IActivityTaskManager mActivityTaskManager = ActivityTaskManager.getService();
    protected final Context mContext;
    protected Host mHost;
    protected SurfaceControl.Transaction mTransaction;
    protected SurfaceControl mSurfaceControl;
    protected Listener mListener;
    protected boolean mOpened;
    private final CloseGuard mGuard = CloseGuard.get();

    public TaskEmbedder(Context context, Host host) {
        this.mContext = context;
        this.mHost = host;
    }

    public boolean initialize(SurfaceControl parent) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Trying to initialize for the second time.");
        }
        this.mTransaction = new SurfaceControl.Transaction();
        String name = "TaskEmbedder - " + Integer.toHexString(System.identityHashCode(this));
        this.mSurfaceControl = new SurfaceControl.Builder().setContainerLayer().setParent(parent).setName(name).setCallsite("TaskEmbedder.initialize").build();
        if (!this.onInitialize()) {
            return false;
        }
        if (this.mListener != null && this.isInitialized()) {
            this.mListener.onInitialized();
        }
        this.mOpened = true;
        this.mGuard.open("release");
        this.mTransaction.show(this.getSurfaceControl()).apply();
        return true;
    }

    public abstract boolean isInitialized();

    public boolean onInitialize() {
        this.updateLocationAndTapExcludeRegion();
        return true;
    }

    protected boolean onRelease() {
        this.clearTapExcludeRegion();
        return true;
    }

    public void start() {
        this.updateLocationAndTapExcludeRegion();
    }

    public void stop() {
        this.clearTapExcludeRegion();
    }

    public void notifyBoundsChanged() {
        this.updateLocationAndTapExcludeRegion();
    }

    public void resizeTask(int width, int height) {
    }

    public abstract void performBackPress();

    public abstract int getId();

    public boolean gatherTransparentRegion(Region region) {
        return false;
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    public int getDisplayId() {
        return -1;
    }

    public VirtualDisplay getVirtualDisplay() {
        return null;
    }

    public void setForwardedInsets(Insets insets) {
    }

    protected void updateLocationAndTapExcludeRegion() {
        if (!this.isInitialized() || this.mHost.getWindow() == null) {
            return;
        }
        this.applyTapExcludeRegion(this.mHost.getWindow(), this.mHost.getTapExcludeRegion());
    }

    private void applyTapExcludeRegion(IWindow window, Region tapExcludeRegion) {
        try {
            IWindowSession session = WindowManagerGlobal.getWindowSession();
            session.updateTapExcludeRegion(window, tapExcludeRegion);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void clearTapExcludeRegion() {
        if (!this.isInitialized() || this.mHost.getWindow() == null) {
            return;
        }
        this.applyTapExcludeRegion(this.mHost.getWindow(), null);
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
        if (this.mListener != null && this.isInitialized()) {
            this.mListener.onInitialized();
        }
    }

    public void startActivity(Intent intent) {
        ActivityOptions options = this.prepareActivityOptions(null);
        this.mContext.startActivity(intent, options.toBundle());
    }

    public void startActivity(Intent intent, UserHandle user) {
        ActivityOptions options = this.prepareActivityOptions(null);
        this.mContext.startActivityAsUser(intent, options.toBundle(), user);
    }

    public void startActivity(PendingIntent pendingIntent) {
        ActivityOptions options = this.prepareActivityOptions(null);
        try {
            pendingIntent.send(null, 0, null, null, null, null, options.toBundle());
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    public void startActivity(PendingIntent pendingIntent, Intent fillInIntent, ActivityOptions options) {
        this.prepareActivityOptions(options);
        try {
            pendingIntent.send(this.mContext, 0, fillInIntent, null, null, null, options.toBundle());
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    public void startShortcutActivity(ShortcutInfo shortcut, ActivityOptions options, Rect sourceBounds) {
        LauncherApps service = (LauncherApps)this.mContext.getSystemService("launcherapps");
        this.prepareActivityOptions(options);
        service.startShortcut(shortcut, sourceBounds, options.toBundle());
    }

    protected ActivityOptions prepareActivityOptions(ActivityOptions options) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Trying to start activity before ActivityView is ready.");
        }
        if (options == null) {
            options = ActivityOptions.makeBasic();
        }
        return options;
    }

    public void release() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Trying to release container that is not initialized.");
        }
        this.performRelease();
    }

    private boolean performRelease() {
        if (!this.mOpened) {
            return false;
        }
        this.mTransaction.reparent(this.mSurfaceControl, null).apply();
        this.mSurfaceControl.release();
        boolean reportReleased = this.onRelease();
        if (this.mListener != null && reportReleased) {
            this.mListener.onReleased();
        }
        this.mOpened = false;
        this.mGuard.close();
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.performRelease();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static interface Listener {
        default public void onInitialized() {
        }

        default public void onReleased() {
        }

        default public void onTaskCreated(int taskId, ComponentName name) {
        }

        default public void onTaskVisibilityChanged(int taskId, boolean visible) {
        }

        default public void onTaskMovedToFront(int taskId) {
        }

        default public void onTaskRemovalStarted(int taskId) {
        }

        default public void onBackPressedOnTaskRoot(int taskId) {
        }
    }

    public static interface Host {
        public Region getTapExcludeRegion();

        public Matrix getScreenToTaskMatrix();

        public IWindow getWindow();

        public Point getPositionInWindow();

        public Rect getScreenBounds();

        public boolean canReceivePointerEvents();

        public int getWidth();

        public int getHeight();

        public void onTaskBackgroundColorChanged(TaskEmbedder var1, int var2);

        public boolean post(Runnable var1);
    }
}

