/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Resources;
import android.graphics.Insets;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.proto.ProtoOutputStream;
import android.view.CutoutSpecification;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DisplayCutout {
    private static final String TAG = "DisplayCutout";
    public static final String EMULATION_OVERLAY_CATEGORY = "com.android.internal.display_cutout_emulation";
    private static final Rect ZERO_RECT = new Rect();
    public static final DisplayCutout NO_CUTOUT = new DisplayCutout(ZERO_RECT, Insets.NONE, ZERO_RECT, ZERO_RECT, ZERO_RECT, ZERO_RECT, false);
    private static final Pair<Path, DisplayCutout> NULL_PAIR = new Pair<Object, Object>(null, null);
    private static final Object CACHE_LOCK = new Object();
    @GuardedBy(value={"CACHE_LOCK"})
    private static String sCachedSpec;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayWidth;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayHeight;
    @GuardedBy(value={"CACHE_LOCK"})
    private static float sCachedDensity;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Pair<Path, DisplayCutout> sCachedCutout;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Insets sCachedWaterfallInsets;
    private final Rect mSafeInsets;
    private final Insets mWaterfallInsets;
    public static final int BOUNDS_POSITION_LEFT = 0;
    public static final int BOUNDS_POSITION_TOP = 1;
    public static final int BOUNDS_POSITION_RIGHT = 2;
    public static final int BOUNDS_POSITION_BOTTOM = 3;
    public static final int BOUNDS_POSITION_LENGTH = 4;
    private final Bounds mBounds;

    public DisplayCutout(Insets safeInsets, Rect boundLeft, Rect boundTop, Rect boundRight, Rect boundBottom) {
        this(safeInsets.toRect(), Insets.NONE, boundLeft, boundTop, boundRight, boundBottom, true);
    }

    public DisplayCutout(Insets safeInsets, Rect boundLeft, Rect boundTop, Rect boundRight, Rect boundBottom, Insets waterfallInsets) {
        this(safeInsets.toRect(), waterfallInsets, boundLeft, boundTop, boundRight, boundBottom, true);
    }

    @Deprecated
    public DisplayCutout(Rect safeInsets, List<Rect> boundingRects) {
        this(safeInsets, Insets.NONE, DisplayCutout.extractBoundsFromList(safeInsets, boundingRects), true);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Rect boundLeft, Rect boundTop, Rect boundRight, Rect boundBottom, boolean copyArguments) {
        this.mSafeInsets = DisplayCutout.getCopyOrRef(safeInsets, copyArguments);
        this.mWaterfallInsets = waterfallInsets == null ? Insets.NONE : waterfallInsets;
        this.mBounds = new Bounds(boundLeft, boundTop, boundRight, boundBottom, copyArguments);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Rect[] bounds, boolean copyArguments) {
        this.mSafeInsets = DisplayCutout.getCopyOrRef(safeInsets, copyArguments);
        this.mWaterfallInsets = waterfallInsets == null ? Insets.NONE : waterfallInsets;
        this.mBounds = new Bounds(bounds, copyArguments);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Bounds bounds) {
        this.mSafeInsets = safeInsets;
        this.mWaterfallInsets = waterfallInsets == null ? Insets.NONE : waterfallInsets;
        this.mBounds = bounds;
    }

    private static Rect getCopyOrRef(Rect r, boolean copyArguments) {
        if (r == null) {
            return ZERO_RECT;
        }
        if (copyArguments) {
            return new Rect(r);
        }
        return r;
    }

    public Insets getWaterfallInsets() {
        return this.mWaterfallInsets;
    }

    public static Rect[] extractBoundsFromList(Rect safeInsets, List<Rect> boundingRects) {
        Rect[] sortedBounds = new Rect[4];
        for (int i = 0; i < sortedBounds.length; ++i) {
            sortedBounds[i] = ZERO_RECT;
        }
        if (safeInsets != null && boundingRects != null) {
            boolean topBottomInset = safeInsets.top > 0 || safeInsets.bottom > 0;
            for (Rect bound : boundingRects) {
                if (topBottomInset) {
                    if (bound.top == 0) {
                        sortedBounds[1] = bound;
                        continue;
                    }
                    sortedBounds[3] = bound;
                    continue;
                }
                if (bound.left == 0) {
                    sortedBounds[0] = bound;
                    continue;
                }
                sortedBounds[2] = bound;
            }
        }
        return sortedBounds;
    }

    public boolean isBoundsEmpty() {
        return this.mBounds.isEmpty();
    }

    public boolean isEmpty() {
        return this.mSafeInsets.equals(ZERO_RECT);
    }

    public int getSafeInsetTop() {
        return this.mSafeInsets.top;
    }

    public int getSafeInsetBottom() {
        return this.mSafeInsets.bottom;
    }

    public int getSafeInsetLeft() {
        return this.mSafeInsets.left;
    }

    public int getSafeInsetRight() {
        return this.mSafeInsets.right;
    }

    public Rect getSafeInsets() {
        return new Rect(this.mSafeInsets);
    }

    public List<Rect> getBoundingRects() {
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (Rect bound : this.getBoundingRectsAll()) {
            if (bound.isEmpty()) continue;
            result.add(new Rect(bound));
        }
        return result;
    }

    public Rect[] getBoundingRectsAll() {
        return this.mBounds.getRects();
    }

    public Rect getBoundingRectLeft() {
        return this.mBounds.getRect(0);
    }

    public Rect getBoundingRectTop() {
        return this.mBounds.getRect(1);
    }

    public Rect getBoundingRectRight() {
        return this.mBounds.getRect(2);
    }

    public Rect getBoundingRectBottom() {
        return this.mBounds.getRect(3);
    }

    public int hashCode() {
        return (this.mSafeInsets.hashCode() * 48271 + this.mBounds.hashCode()) * 48271 + this.mWaterfallInsets.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayCutout) {
            DisplayCutout c = (DisplayCutout)o;
            return this.mSafeInsets.equals(c.mSafeInsets) && this.mBounds.equals(c.mBounds) && this.mWaterfallInsets.equals(c.mWaterfallInsets);
        }
        return false;
    }

    public String toString() {
        return "DisplayCutout{insets=" + this.mSafeInsets + " waterfall=" + this.mWaterfallInsets + " boundingRect={" + this.mBounds + "}}";
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mSafeInsets.dumpDebug(proto, 0x10B00000001L);
        this.mBounds.getRect(0).dumpDebug(proto, 1146756268035L);
        this.mBounds.getRect(1).dumpDebug(proto, 1146756268036L);
        this.mBounds.getRect(2).dumpDebug(proto, 1146756268037L);
        this.mBounds.getRect(3).dumpDebug(proto, 1146756268038L);
        this.mWaterfallInsets.toRect().dumpDebug(proto, 0x10B00000001L);
        proto.end(token);
    }

    public DisplayCutout inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        if (insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0 || this.isBoundsEmpty() && this.mWaterfallInsets.equals(Insets.NONE)) {
            return this;
        }
        Rect safeInsets = this.insetInsets(insetLeft, insetTop, insetRight, insetBottom, new Rect(this.mSafeInsets));
        if (insetLeft == 0 && insetTop == 0 && this.mSafeInsets.equals(safeInsets)) {
            return this;
        }
        Rect waterfallInsets = this.insetInsets(insetLeft, insetTop, insetRight, insetBottom, this.mWaterfallInsets.toRect());
        Rect[] bounds = this.mBounds.getRects();
        for (int i = 0; i < bounds.length; ++i) {
            if (bounds[i].equals(ZERO_RECT)) continue;
            bounds[i].offset(-insetLeft, -insetTop);
        }
        return new DisplayCutout(safeInsets, Insets.of(waterfallInsets), bounds, false);
    }

    private Rect insetInsets(int insetLeft, int insetTop, int insetRight, int insetBottom, Rect insets) {
        if (insetTop > 0 || insets.top > 0) {
            insets.top = DisplayCutout.atLeastZero(insets.top - insetTop);
        }
        if (insetBottom > 0 || insets.bottom > 0) {
            insets.bottom = DisplayCutout.atLeastZero(insets.bottom - insetBottom);
        }
        if (insetLeft > 0 || insets.left > 0) {
            insets.left = DisplayCutout.atLeastZero(insets.left - insetLeft);
        }
        if (insetRight > 0 || insets.right > 0) {
            insets.right = DisplayCutout.atLeastZero(insets.right - insetRight);
        }
        return insets;
    }

    public DisplayCutout replaceSafeInsets(Rect safeInsets) {
        return new DisplayCutout(new Rect(safeInsets), this.mWaterfallInsets, this.mBounds);
    }

    private static int atLeastZero(int value) {
        return value < 0 ? 0 : value;
    }

    @VisibleForTesting
    public static DisplayCutout fromBoundingRect(int left, int top, int right, int bottom, int pos) {
        Rect[] bounds = new Rect[4];
        for (int i = 0; i < 4; ++i) {
            bounds[i] = pos == i ? new Rect(left, top, right, bottom) : new Rect();
        }
        return new DisplayCutout(ZERO_RECT, Insets.NONE, bounds, false);
    }

    public static DisplayCutout fromBoundsAndWaterfall(Rect[] bounds, Insets waterfallInsets) {
        return new DisplayCutout(ZERO_RECT, waterfallInsets, bounds, false);
    }

    public static DisplayCutout fromBounds(Rect[] bounds) {
        return new DisplayCutout(ZERO_RECT, Insets.NONE, bounds, false);
    }

    public static DisplayCutout fromResourcesRectApproximation(Resources res, int displayWidth, int displayHeight) {
        return DisplayCutout.fromSpec(res.getString(17039924), displayWidth, displayHeight, (float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f, DisplayCutout.loadWaterfallInset(res));
    }

    public static Path pathFromResources(Resources res, int displayWidth, int displayHeight) {
        return (Path)DisplayCutout.pathAndDisplayCutoutFromSpec((String)res.getString((int)17039923), (int)displayWidth, (int)displayHeight, (float)((float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f), (Insets)DisplayCutout.loadWaterfallInset((Resources)res)).first;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static DisplayCutout fromSpec(String spec, int displayWidth, int displayHeight, float density, Insets waterfallInsets) {
        return (DisplayCutout)DisplayCutout.pathAndDisplayCutoutFromSpec((String)spec, (int)displayWidth, (int)displayHeight, (float)density, (Insets)waterfallInsets).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Path, DisplayCutout> pathAndDisplayCutoutFromSpec(String spec, int displayWidth, int displayHeight, float density, Insets waterfallInsets) {
        if (TextUtils.isEmpty(spec) && waterfallInsets.equals(Insets.NONE)) {
            return NULL_PAIR;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (spec.equals(sCachedSpec) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight && sCachedDensity == density && waterfallInsets.equals(sCachedWaterfallInsets)) {
                return sCachedCutout;
            }
        }
        spec = spec.trim();
        CutoutSpecification cutoutSpec = new CutoutSpecification.Parser(density, displayWidth, displayHeight).parse(spec);
        Rect safeInset = cutoutSpec.getSafeInset();
        Rect boundLeft = cutoutSpec.getLeftBound();
        Rect boundTop = cutoutSpec.getTopBound();
        Rect boundRight = cutoutSpec.getRightBound();
        Rect boundBottom = cutoutSpec.getBottomBound();
        if (!waterfallInsets.equals(Insets.NONE)) {
            safeInset.set(Math.max(waterfallInsets.left, safeInset.left), Math.max(waterfallInsets.top, safeInset.top), Math.max(waterfallInsets.right, safeInset.right), Math.max(waterfallInsets.bottom, safeInset.bottom));
        }
        DisplayCutout cutout = new DisplayCutout(safeInset, waterfallInsets, boundLeft, boundTop, boundRight, boundBottom, false);
        Pair<Path, DisplayCutout> result = new Pair<Path, DisplayCutout>(cutoutSpec.getPath(), cutout);
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedSpec = spec;
            sCachedDisplayWidth = displayWidth;
            sCachedDisplayHeight = displayHeight;
            sCachedDensity = density;
            sCachedCutout = result;
            sCachedWaterfallInsets = waterfallInsets;
        }
        return result;
    }

    private static Insets loadWaterfallInset(Resources res) {
        return Insets.of(res.getDimensionPixelSize(17105545), res.getDimensionPixelSize(17105547), res.getDimensionPixelSize(17105546), res.getDimensionPixelSize(17105544));
    }

    static {
        sCachedCutout = NULL_PAIR;
    }

    public static class ParcelableWrapper
    implements Parcelable {
        private DisplayCutout mInner;
        public static final Parcelable.Creator<ParcelableWrapper> CREATOR = new Parcelable.Creator<ParcelableWrapper>(){

            @Override
            public ParcelableWrapper createFromParcel(Parcel in) {
                return new ParcelableWrapper(ParcelableWrapper.readCutoutFromParcel(in));
            }

            public ParcelableWrapper[] newArray(int size) {
                return new ParcelableWrapper[size];
            }
        };

        public ParcelableWrapper() {
            this(NO_CUTOUT);
        }

        public ParcelableWrapper(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            ParcelableWrapper.writeCutoutToParcel(this.mInner, out, flags);
        }

        public static void writeCutoutToParcel(DisplayCutout cutout, Parcel out, int flags) {
            if (cutout == null) {
                out.writeInt(-1);
            } else if (cutout == NO_CUTOUT) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeTypedObject(cutout.mSafeInsets, flags);
                out.writeTypedArray(cutout.mBounds.getRects(), flags);
                out.writeTypedObject(cutout.mWaterfallInsets, flags);
            }
        }

        public void readFromParcel(Parcel in) {
            this.mInner = ParcelableWrapper.readCutoutFromParcel(in);
        }

        public static DisplayCutout readCutoutFromParcel(Parcel in) {
            int variant = in.readInt();
            if (variant == -1) {
                return null;
            }
            if (variant == 0) {
                return NO_CUTOUT;
            }
            Rect safeInsets = in.readTypedObject(Rect.CREATOR);
            Rect[] bounds = new Rect[4];
            in.readTypedArray(bounds, Rect.CREATOR);
            Insets waterfallInsets = in.readTypedObject(Insets.CREATOR);
            return new DisplayCutout(safeInsets, waterfallInsets, bounds, false);
        }

        public DisplayCutout get() {
            return this.mInner;
        }

        public void set(ParcelableWrapper cutout) {
            this.mInner = cutout.get();
        }

        public void set(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        public int hashCode() {
            return this.mInner.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ParcelableWrapper && this.mInner.equals(((ParcelableWrapper)o).mInner);
        }

        public String toString() {
            return String.valueOf(this.mInner);
        }
    }

    private static class Bounds {
        private final Rect[] mRects;

        private Bounds(Rect left, Rect top, Rect right, Rect bottom, boolean copyArguments) {
            this.mRects = new Rect[4];
            this.mRects[0] = DisplayCutout.getCopyOrRef(left, copyArguments);
            this.mRects[1] = DisplayCutout.getCopyOrRef(top, copyArguments);
            this.mRects[2] = DisplayCutout.getCopyOrRef(right, copyArguments);
            this.mRects[3] = DisplayCutout.getCopyOrRef(bottom, copyArguments);
        }

        private Bounds(Rect[] rects, boolean copyArguments) {
            if (rects.length != 4) {
                throw new IllegalArgumentException("rects must have exactly 4 elements: rects=" + Arrays.toString(rects));
            }
            if (copyArguments) {
                this.mRects = new Rect[4];
                for (int i = 0; i < 4; ++i) {
                    this.mRects[i] = new Rect(rects[i]);
                }
            } else {
                for (Rect rect : rects) {
                    if (rect != null) continue;
                    throw new IllegalArgumentException("rects must have non-null elements: rects=" + Arrays.toString(rects));
                }
                this.mRects = rects;
            }
        }

        private boolean isEmpty() {
            for (Rect rect : this.mRects) {
                if (rect.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private Rect getRect(int pos) {
            return new Rect(this.mRects[pos]);
        }

        private Rect[] getRects() {
            Rect[] rects = new Rect[4];
            for (int i = 0; i < 4; ++i) {
                rects[i] = new Rect(this.mRects[i]);
            }
            return rects;
        }

        public int hashCode() {
            int result = 0;
            for (Rect rect : this.mRects) {
                result = result * 48271 + rect.hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Bounds) {
                Bounds b = (Bounds)o;
                return Arrays.deepEquals(this.mRects, b.mRects);
            }
            return false;
        }

        public String toString() {
            return "Bounds=" + Arrays.toString(this.mRects);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoundsPosition {
    }
}

