/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.util.proto.ProtoParseException;
import android.util.proto.ProtoStream;
import android.util.proto.WireTypeMismatchException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class ProtoInputStream
extends ProtoStream {
    public static final int NO_MORE_FIELDS = -1;
    private InputStream mStream;
    private int mFieldNumber;
    private int mWireType;
    private static final byte STATE_STARTED_FIELD_READ = 1;
    private static final byte STATE_READING_PACKED = 2;
    private static final byte STATE_FIELD_MISS = 4;
    private byte mState = 0;
    private ArrayList<Long> mExpectedObjectTokenStack = null;
    private int mDepth = -1;
    private byte[] mBuffer;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final int mBufferSize;
    private int mDiscardedBytes = 0;
    private int mOffset = 0;
    private int mEnd = 0;
    private int mPackedEnd = 0;

    public ProtoInputStream(InputStream stream, int bufferSize) {
        this.mStream = stream;
        this.mBufferSize = bufferSize > 0 ? bufferSize : 8192;
        this.mBuffer = new byte[this.mBufferSize];
    }

    public ProtoInputStream(InputStream stream) {
        this(stream, 8192);
    }

    public ProtoInputStream(byte[] buffer) {
        this.mBufferSize = buffer.length;
        this.mEnd = buffer.length;
        this.mBuffer = buffer;
        this.mStream = null;
    }

    public int getFieldNumber() {
        return this.mFieldNumber;
    }

    public int getWireType() {
        if ((this.mState & 2) == 2) {
            return 2;
        }
        return this.mWireType;
    }

    public int getOffset() {
        return this.mOffset + this.mDiscardedBytes;
    }

    public int nextField() throws IOException {
        if ((this.mState & 4) == 4) {
            this.mState = (byte)(this.mState & 0xFFFFFFFB);
            return this.mFieldNumber;
        }
        if ((this.mState & 1) == 1) {
            this.skip();
            this.mState = (byte)(this.mState & 0xFFFFFFFE);
        }
        if ((this.mState & 2) == 2) {
            if (this.getOffset() < this.mPackedEnd) {
                this.mState = (byte)(this.mState | 1);
                return this.mFieldNumber;
            }
            if (this.getOffset() == this.mPackedEnd) {
                this.mState = (byte)(this.mState & 0xFFFFFFFD);
            } else {
                throw new ProtoParseException("Unexpectedly reached end of packed field at offset 0x" + Integer.toHexString(this.mPackedEnd) + this.dumpDebugData());
            }
        }
        if (this.mDepth >= 0 && this.getOffset() == ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth))) {
            this.mFieldNumber = -1;
        } else {
            this.readTag();
        }
        return this.mFieldNumber;
    }

    public boolean nextField(long fieldId) throws IOException {
        if (this.nextField() == (int)fieldId) {
            return true;
        }
        this.mState = (byte)(this.mState | 4);
        return false;
    }

    public double readDouble(long fieldId) throws IOException {
        double value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.checkPacked(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 1: {
                this.assertWireType(1);
                value = Double.longBitsToDouble(this.readFixed64());
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") cannot be read as a double" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public float readFloat(long fieldId) throws IOException {
        float value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.checkPacked(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 2: {
                this.assertWireType(5);
                value = Float.intBitsToFloat(this.readFixed32());
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") is not a float" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public int readInt(long fieldId) throws IOException {
        int value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.checkPacked(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 7: 
            case 15: {
                this.assertWireType(5);
                value = this.readFixed32();
                break;
            }
            case 17: {
                this.assertWireType(0);
                value = this.decodeZigZag32((int)this.readVarint());
                break;
            }
            case 5: 
            case 13: 
            case 14: {
                this.assertWireType(0);
                value = (int)this.readVarint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") is not an int" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public long readLong(long fieldId) throws IOException {
        long value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.checkPacked(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 6: 
            case 16: {
                this.assertWireType(1);
                value = this.readFixed64();
                break;
            }
            case 18: {
                this.assertWireType(0);
                value = this.decodeZigZag64(this.readVarint());
                break;
            }
            case 3: 
            case 4: {
                this.assertWireType(0);
                value = this.readVarint();
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") is not an long" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public boolean readBoolean(long fieldId) throws IOException {
        boolean value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.checkPacked(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 8: {
                this.assertWireType(0);
                value = this.readVarint() != 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") is not an boolean" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public String readString(long fieldId) throws IOException {
        String value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 9: {
                this.assertWireType(2);
                int len = (int)this.readVarint();
                value = this.readRawString(len);
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field id(" + ProtoInputStream.getFieldIdString(fieldId) + ") is not an string" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public byte[] readBytes(long fieldId) throws IOException {
        byte[] value;
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
            case 11: 
            case 12: {
                this.assertWireType(2);
                int len = (int)this.readVarint();
                value = this.readRawBytes(len);
                break;
            }
            default: {
                throw new IllegalArgumentException("Requested field type (" + ProtoInputStream.getFieldIdString(fieldId) + ") cannot be read as raw bytes" + this.dumpDebugData());
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return value;
    }

    public long start(long fieldId) throws IOException {
        this.assertFreshData();
        this.assertFieldNumber(fieldId);
        this.assertWireType(2);
        int messageSize = (int)this.readVarint();
        if (this.mExpectedObjectTokenStack == null) {
            this.mExpectedObjectTokenStack = new ArrayList();
        }
        if (++this.mDepth == this.mExpectedObjectTokenStack.size()) {
            this.mExpectedObjectTokenStack.add(ProtoInputStream.makeToken(0, (fieldId & 0x20000000000L) == 0x20000000000L, this.mDepth, (int)fieldId, this.getOffset() + messageSize));
        } else {
            this.mExpectedObjectTokenStack.set(this.mDepth, ProtoInputStream.makeToken(0, (fieldId & 0x20000000000L) == 0x20000000000L, this.mDepth, (int)fieldId, this.getOffset() + messageSize));
        }
        if (this.mDepth > 0 && ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth)) > ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth - 1))) {
            throw new ProtoParseException("Embedded Object (" + ProtoInputStream.token2String(this.mExpectedObjectTokenStack.get(this.mDepth)) + ") ends after of parent Objects's (" + ProtoInputStream.token2String(this.mExpectedObjectTokenStack.get(this.mDepth - 1)) + ") end" + this.dumpDebugData());
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
        return this.mExpectedObjectTokenStack.get(this.mDepth);
    }

    public void end(long token) {
        if (this.mExpectedObjectTokenStack.get(this.mDepth) != token) {
            throw new ProtoParseException("end token " + token + " does not match current message token " + this.mExpectedObjectTokenStack.get(this.mDepth) + this.dumpDebugData());
        }
        if (ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth)) > this.getOffset()) {
            this.incOffset(ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth)) - this.getOffset());
        }
        --this.mDepth;
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
    }

    private void readTag() throws IOException {
        this.fillBuffer();
        if (this.mOffset >= this.mEnd) {
            this.mFieldNumber = -1;
            return;
        }
        int tag = (int)this.readVarint();
        this.mFieldNumber = tag >>> 3;
        this.mWireType = tag & 7;
        this.mState = (byte)(this.mState | 1);
    }

    public int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private long readVarint() throws IOException {
        long value = 0L;
        int shift = 0;
        while (true) {
            this.fillBuffer();
            int fragment = this.mEnd - this.mOffset;
            if (fragment < 0) {
                throw new ProtoParseException("Incomplete varint at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
            }
            for (int i = 0; i < fragment; ++i) {
                byte b = this.mBuffer[this.mOffset + i];
                value |= ((long)b & 0x7FL) << shift;
                if ((b & 0x80) == 0) {
                    this.incOffset(i + 1);
                    return value;
                }
                if ((shift += 7) <= 63) continue;
                throw new ProtoParseException("Varint is too large at offset 0x" + Integer.toHexString(this.getOffset() + i) + this.dumpDebugData());
            }
            this.incOffset(fragment);
        }
    }

    private int readFixed32() throws IOException {
        if (this.mOffset + 4 <= this.mEnd) {
            this.incOffset(4);
            return this.mBuffer[this.mOffset - 4] & 0xFF | (this.mBuffer[this.mOffset - 3] & 0xFF) << 8 | (this.mBuffer[this.mOffset - 2] & 0xFF) << 16 | (this.mBuffer[this.mOffset - 1] & 0xFF) << 24;
        }
        int value = 0;
        int shift = 0;
        int bytesLeft = 4;
        while (bytesLeft > 0) {
            int fragment;
            this.fillBuffer();
            int n = fragment = this.mEnd - this.mOffset < bytesLeft ? this.mEnd - this.mOffset : bytesLeft;
            if (fragment < 0) {
                throw new ProtoParseException("Incomplete fixed32 at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
            }
            this.incOffset(fragment);
            bytesLeft -= fragment;
            while (fragment > 0) {
                value |= (this.mBuffer[this.mOffset - fragment] & 0xFF) << shift;
                --fragment;
                shift += 8;
            }
        }
        return value;
    }

    private long readFixed64() throws IOException {
        if (this.mOffset + 8 <= this.mEnd) {
            this.incOffset(8);
            return (long)this.mBuffer[this.mOffset - 8] & 0xFFL | ((long)this.mBuffer[this.mOffset - 7] & 0xFFL) << 8 | ((long)this.mBuffer[this.mOffset - 6] & 0xFFL) << 16 | ((long)this.mBuffer[this.mOffset - 5] & 0xFFL) << 24 | ((long)this.mBuffer[this.mOffset - 4] & 0xFFL) << 32 | ((long)this.mBuffer[this.mOffset - 3] & 0xFFL) << 40 | ((long)this.mBuffer[this.mOffset - 2] & 0xFFL) << 48 | ((long)this.mBuffer[this.mOffset - 1] & 0xFFL) << 56;
        }
        long value = 0L;
        int shift = 0;
        int bytesLeft = 8;
        while (bytesLeft > 0) {
            int fragment;
            this.fillBuffer();
            int n = fragment = this.mEnd - this.mOffset < bytesLeft ? this.mEnd - this.mOffset : bytesLeft;
            if (fragment < 0) {
                throw new ProtoParseException("Incomplete fixed64 at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
            }
            this.incOffset(fragment);
            bytesLeft -= fragment;
            while (fragment > 0) {
                value |= ((long)this.mBuffer[this.mOffset - fragment] & 0xFFL) << shift;
                --fragment;
                shift += 8;
            }
        }
        return value;
    }

    private byte[] readRawBytes(int n) throws IOException {
        byte[] buffer = new byte[n];
        int pos = 0;
        while (this.mOffset + n - pos > this.mEnd) {
            int fragment = this.mEnd - this.mOffset;
            if (fragment > 0) {
                System.arraycopy(this.mBuffer, this.mOffset, buffer, pos, fragment);
                this.incOffset(fragment);
                pos += fragment;
            }
            this.fillBuffer();
            if (this.mOffset < this.mEnd) continue;
            throw new ProtoParseException("Unexpectedly reached end of the InputStream at offset 0x" + Integer.toHexString(this.mEnd) + this.dumpDebugData());
        }
        System.arraycopy(this.mBuffer, this.mOffset, buffer, pos, n - pos);
        this.incOffset(n - pos);
        return buffer;
    }

    private String readRawString(int n) throws IOException {
        this.fillBuffer();
        if (this.mOffset + n <= this.mEnd) {
            String value = new String(this.mBuffer, this.mOffset, n, StandardCharsets.UTF_8);
            this.incOffset(n);
            return value;
        }
        if (n <= this.mBufferSize) {
            int stringHead = this.mEnd - this.mOffset;
            System.arraycopy(this.mBuffer, this.mOffset, this.mBuffer, 0, stringHead);
            this.mEnd = stringHead + this.mStream.read(this.mBuffer, stringHead, n - stringHead);
            this.mDiscardedBytes += this.mOffset;
            this.mOffset = 0;
            String value = new String(this.mBuffer, this.mOffset, n, StandardCharsets.UTF_8);
            this.incOffset(n);
            return value;
        }
        return new String(this.readRawBytes(n), 0, n, StandardCharsets.UTF_8);
    }

    private void fillBuffer() throws IOException {
        if (this.mOffset >= this.mEnd && this.mStream != null) {
            this.mOffset -= this.mEnd;
            this.mDiscardedBytes += this.mEnd;
            if (this.mOffset >= this.mBufferSize) {
                int skipped = (int)this.mStream.skip(this.mOffset / this.mBufferSize * this.mBufferSize);
                this.mDiscardedBytes += skipped;
                this.mOffset -= skipped;
            }
            this.mEnd = this.mStream.read(this.mBuffer);
        }
    }

    public void skip() throws IOException {
        if ((this.mState & 2) == 2) {
            this.incOffset(this.mPackedEnd - this.getOffset());
        } else {
            switch (this.mWireType) {
                case 0: {
                    byte b;
                    do {
                        this.fillBuffer();
                        b = this.mBuffer[this.mOffset];
                        this.incOffset(1);
                    } while ((b & 0x80) != 0);
                    break;
                }
                case 1: {
                    this.incOffset(8);
                    break;
                }
                case 2: {
                    this.fillBuffer();
                    int length = (int)this.readVarint();
                    this.incOffset(length);
                    break;
                }
                case 5: {
                    this.incOffset(4);
                    break;
                }
                default: {
                    throw new ProtoParseException("Unexpected wire type: " + this.mWireType + " at offset 0x" + Integer.toHexString(this.mOffset) + this.dumpDebugData());
                }
            }
        }
        this.mState = (byte)(this.mState & 0xFFFFFFFE);
    }

    private void incOffset(int n) {
        this.mOffset += n;
        if (this.mDepth >= 0 && this.getOffset() > ProtoInputStream.getOffsetFromToken(this.mExpectedObjectTokenStack.get(this.mDepth))) {
            throw new ProtoParseException("Unexpectedly reached end of embedded object.  " + ProtoInputStream.token2String(this.mExpectedObjectTokenStack.get(this.mDepth)) + this.dumpDebugData());
        }
    }

    private void checkPacked(long fieldId) throws IOException {
        if (this.mWireType == 2) {
            int length = (int)this.readVarint();
            this.mPackedEnd = this.getOffset() + length;
            this.mState = (byte)(this.mState | 2);
            switch ((int)((fieldId & 0xFF00000000L) >>> 32)) {
                case 2: 
                case 7: 
                case 15: {
                    if (length % 4 != 0) {
                        throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") packed length " + length + " is not aligned for fixed32" + this.dumpDebugData());
                    }
                    this.mWireType = 5;
                    break;
                }
                case 1: 
                case 6: 
                case 16: {
                    if (length % 8 != 0) {
                        throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") packed length " + length + " is not aligned for fixed64" + this.dumpDebugData());
                    }
                    this.mWireType = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    this.mWireType = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") is not a packable field" + this.dumpDebugData());
                }
            }
        }
    }

    private void assertFieldNumber(long fieldId) {
        if ((int)fieldId != this.mFieldNumber) {
            throw new IllegalArgumentException("Requested field id (" + ProtoInputStream.getFieldIdString(fieldId) + ") does not match current field number (0x" + Integer.toHexString(this.mFieldNumber) + ") at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
        }
    }

    private void assertWireType(int wireType) {
        if (wireType != this.mWireType) {
            throw new WireTypeMismatchException("Current wire type " + ProtoInputStream.getWireTypeString(this.mWireType) + " does not match expected wire type " + ProtoInputStream.getWireTypeString(wireType) + " at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
        }
    }

    private void assertFreshData() {
        if ((this.mState & 1) != 1) {
            throw new ProtoParseException("Attempting to read already read field at offset 0x" + Integer.toHexString(this.getOffset()) + this.dumpDebugData());
        }
    }

    public String dumpDebugData() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmFieldNumber : 0x" + Integer.toHexString(this.mFieldNumber));
        sb.append("\nmWireType : 0x" + Integer.toHexString(this.mWireType));
        sb.append("\nmState : 0x" + Integer.toHexString(this.mState));
        sb.append("\nmDiscardedBytes : 0x" + Integer.toHexString(this.mDiscardedBytes));
        sb.append("\nmOffset : 0x" + Integer.toHexString(this.mOffset));
        sb.append("\nmExpectedObjectTokenStack : ");
        if (this.mExpectedObjectTokenStack == null) {
            sb.append("null");
        } else {
            sb.append(this.mExpectedObjectTokenStack);
        }
        sb.append("\nmDepth : 0x" + Integer.toHexString(this.mDepth));
        sb.append("\nmBuffer : ");
        if (this.mBuffer == null) {
            sb.append("null");
        } else {
            sb.append(this.mBuffer);
        }
        sb.append("\nmBufferSize : 0x" + Integer.toHexString(this.mBufferSize));
        sb.append("\nmEnd : 0x" + Integer.toHexString(this.mEnd));
        return sb.toString();
    }
}

