/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.RcsContactUceCapability;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IRcsFeatureListener;
import android.telephony.ims.feature.CapabilityChangeRequest;
import java.util.ArrayList;
import java.util.List;

public interface IImsRcsFeature
extends IInterface {
    public void setListener(IRcsFeatureListener var1) throws RemoteException;

    public int queryCapabilityStatus() throws RemoteException;

    public int getFeatureState() throws RemoteException;

    public void addCapabilityCallback(IImsCapabilityCallback var1) throws RemoteException;

    public void removeCapabilityCallback(IImsCapabilityCallback var1) throws RemoteException;

    public void changeCapabilitiesConfiguration(CapabilityChangeRequest var1, IImsCapabilityCallback var2) throws RemoteException;

    public void queryCapabilityConfiguration(int var1, int var2, IImsCapabilityCallback var3) throws RemoteException;

    public void requestCapabilities(List<Uri> var1, int var2) throws RemoteException;

    public void updateCapabilities(RcsContactUceCapability var1, int var2) throws RemoteException;

    public void sendCapabilityRequest(Uri var1, RcsContactUceCapability var2, int var3) throws RemoteException;

    public void respondToCapabilityRequest(String var1, RcsContactUceCapability var2, int var3) throws RemoteException;

    public void respondToCapabilityRequestWithError(Uri var1, int var2, String var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsRcsFeature {
        private static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsRcsFeature";
        static final int TRANSACTION_setListener = 1;
        static final int TRANSACTION_queryCapabilityStatus = 2;
        static final int TRANSACTION_getFeatureState = 3;
        static final int TRANSACTION_addCapabilityCallback = 4;
        static final int TRANSACTION_removeCapabilityCallback = 5;
        static final int TRANSACTION_changeCapabilitiesConfiguration = 6;
        static final int TRANSACTION_queryCapabilityConfiguration = 7;
        static final int TRANSACTION_requestCapabilities = 8;
        static final int TRANSACTION_updateCapabilities = 9;
        static final int TRANSACTION_sendCapabilityRequest = 10;
        static final int TRANSACTION_respondToCapabilityRequest = 11;
        static final int TRANSACTION_respondToCapabilityRequestWithError = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsRcsFeature asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsRcsFeature) {
                return (IImsRcsFeature)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setListener";
                }
                case 2: {
                    return "queryCapabilityStatus";
                }
                case 3: {
                    return "getFeatureState";
                }
                case 4: {
                    return "addCapabilityCallback";
                }
                case 5: {
                    return "removeCapabilityCallback";
                }
                case 6: {
                    return "changeCapabilitiesConfiguration";
                }
                case 7: {
                    return "queryCapabilityConfiguration";
                }
                case 8: {
                    return "requestCapabilities";
                }
                case 9: {
                    return "updateCapabilities";
                }
                case 10: {
                    return "sendCapabilityRequest";
                }
                case 11: {
                    return "respondToCapabilityRequest";
                }
                case 12: {
                    return "respondToCapabilityRequestWithError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IRcsFeatureListener _arg0 = IRcsFeatureListener.Stub.asInterface(data.readStrongBinder());
                    this.setListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _result = this.queryCapabilityStatus();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _result = this.getFeatureState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IImsCapabilityCallback _arg0 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.addCapabilityCallback(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    IImsCapabilityCallback _arg0 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.removeCapabilityCallback(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    CapabilityChangeRequest _arg0 = 0 != data.readInt() ? CapabilityChangeRequest.CREATOR.createFromParcel(data) : null;
                    IImsCapabilityCallback _arg1 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.changeCapabilitiesConfiguration(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IImsCapabilityCallback _arg2 = IImsCapabilityCallback.Stub.asInterface(data.readStrongBinder());
                    this.queryCapabilityConfiguration(_arg0, _arg1, _arg2);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    ArrayList<Uri> _arg0 = data.createTypedArrayList(Uri.CREATOR);
                    int _arg1 = data.readInt();
                    this.requestCapabilities(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    RcsContactUceCapability _arg0 = 0 != data.readInt() ? RcsContactUceCapability.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    this.updateCapabilities(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    RcsContactUceCapability _arg1 = 0 != data.readInt() ? RcsContactUceCapability.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.sendCapabilityRequest(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    RcsContactUceCapability _arg1 = 0 != data.readInt() ? RcsContactUceCapability.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    this.respondToCapabilityRequest(_arg0, _arg1, _arg2);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    this.respondToCapabilityRequestWithError(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IImsRcsFeature impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IImsRcsFeature getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IImsRcsFeature {
            private IBinder mRemote;
            public static IImsRcsFeature sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setListener(IRcsFeatureListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int queryCapabilityStatus() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().queryCapabilityStatus();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFeatureState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getFeatureState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addCapabilityCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeCapabilityCallback(c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeCapabilitiesConfiguration(CapabilityChangeRequest r, IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (r != null) {
                        _data.writeInt(1);
                        r.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().changeCapabilitiesConfiguration(r, c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(capability);
                    _data.writeInt(radioTech);
                    _data.writeStrongBinder(c != null ? c.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().queryCapabilityConfiguration(capability, radioTech, c);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCapabilities(List<Uri> uris, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(uris);
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestCapabilities(uris, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCapabilities(RcsContactUceCapability capabilities, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (capabilities != null) {
                        _data.writeInt(1);
                        capabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateCapabilities(capabilities, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCapabilityRequest(Uri contactUri, RcsContactUceCapability capabilities, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (contactUri != null) {
                        _data.writeInt(1);
                        contactUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (capabilities != null) {
                        _data.writeInt(1);
                        capabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendCapabilityRequest(contactUri, capabilities, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void respondToCapabilityRequest(String contactUri, RcsContactUceCapability ownCapabilities, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(contactUri);
                    if (ownCapabilities != null) {
                        _data.writeInt(1);
                        ownCapabilities.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().respondToCapabilityRequest(contactUri, ownCapabilities, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void respondToCapabilityRequestWithError(Uri contactUri, int code, String reason, int operationToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (contactUri != null) {
                        _data.writeInt(1);
                        contactUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(code);
                    _data.writeString(reason);
                    _data.writeInt(operationToken);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().respondToCapabilityRequestWithError(contactUri, code, reason, operationToken);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsRcsFeature {
        @Override
        public void setListener(IRcsFeatureListener listener) throws RemoteException {
        }

        @Override
        public int queryCapabilityStatus() throws RemoteException {
            return 0;
        }

        @Override
        public int getFeatureState() throws RemoteException {
            return 0;
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest r, IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) throws RemoteException {
        }

        @Override
        public void requestCapabilities(List<Uri> uris, int operationToken) throws RemoteException {
        }

        @Override
        public void updateCapabilities(RcsContactUceCapability capabilities, int operationToken) throws RemoteException {
        }

        @Override
        public void sendCapabilityRequest(Uri contactUri, RcsContactUceCapability capabilities, int operationToken) throws RemoteException {
        }

        @Override
        public void respondToCapabilityRequest(String contactUri, RcsContactUceCapability ownCapabilities, int operationToken) throws RemoteException {
        }

        @Override
        public void respondToCapabilityRequestWithError(Uri contactUri, int code, String reason, int operationToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

