/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telecom.Log;
import android.telecom.Logging.Session;
import android.util.Base64;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private static final long SESSION_ID_ROLLOVER_THRESHOLD = 262144L;
    private static final long DEFAULT_SESSION_TIMEOUT_MS = 30000L;
    private static final String LOGGING_TAG = "Logging";
    private static final String TIMEOUTS_PREFIX = "telecom.";
    private int sCodeEntryCounter = 0;
    private Context mContext;
    @VisibleForTesting
    public ConcurrentHashMap<Integer, Session> mSessionMapper = new ConcurrentHashMap(100);
    @VisibleForTesting
    public Runnable mCleanStaleSessions = () -> this.cleanupStaleSessions(this.getSessionCleanupTimeoutMs());
    private Handler mSessionCleanupHandler = new Handler(Looper.getMainLooper());
    @VisibleForTesting
    public ICurrentThreadId mCurrentThreadId = Process::myTid;
    private ISessionCleanupTimeoutMs mSessionCleanupTimeoutMs = () -> {
        if (this.mContext == null) {
            return 30000L;
        }
        return this.getCleanupTimeout(this.mContext);
    };
    private List<ISessionListener> mSessionListeners = new ArrayList<ISessionListener>();

    public void setContext(Context context) {
        this.mContext = context;
    }

    private long getSessionCleanupTimeoutMs() {
        return this.mSessionCleanupTimeoutMs.get();
    }

    private synchronized void resetStaleSessionTimer() {
        this.mSessionCleanupHandler.removeCallbacksAndMessages(null);
        if (this.mCleanStaleSessions != null) {
            this.mSessionCleanupHandler.postDelayed(this.mCleanStaleSessions, this.getSessionCleanupTimeoutMs());
        }
    }

    public synchronized void startSession(Session.Info info, String shortMethodName, String callerIdentification) {
        if (info == null) {
            this.startSession(shortMethodName, callerIdentification);
        } else {
            this.startExternalSession(info, shortMethodName);
        }
    }

    public synchronized void startSession(String shortMethodName, String callerIdentification) {
        this.resetStaleSessionTimer();
        int threadId = this.getCallingThreadId();
        Session activeSession = this.mSessionMapper.get(threadId);
        if (activeSession != null) {
            Session childSession = this.createSubsession(true);
            this.continueSession(childSession, shortMethodName);
            return;
        }
        Log.d(LOGGING_TAG, "START_SESSION", new Object[0]);
        Session newSession = new Session(this.getNextSessionID(), shortMethodName, System_Delegate.currentTimeMillis(), false, callerIdentification);
        this.mSessionMapper.put(threadId, newSession);
    }

    public synchronized void startExternalSession(Session.Info sessionInfo, String shortMethodName) {
        if (sessionInfo == null) {
            return;
        }
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession != null) {
            Log.w(LOGGING_TAG, "trying to start an external session with a session already active.", new Object[0]);
            return;
        }
        Log.d(LOGGING_TAG, "START_EXTERNAL_SESSION", new Object[0]);
        Session externalSession = new Session("E-" + sessionInfo.sessionId, sessionInfo.methodPath, System_Delegate.currentTimeMillis(), false, sessionInfo.ownerInfo);
        externalSession.setIsExternal(true);
        externalSession.markSessionCompleted(-1L);
        this.mSessionMapper.put(threadId, externalSession);
        Session childSession = this.createSubsession();
        this.continueSession(childSession, shortMethodName);
    }

    public Session createSubsession() {
        return this.createSubsession(false);
    }

    @VisibleForTesting
    public synchronized Session createSubsession(boolean isStartedFromActiveSession) {
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession == null) {
            Log.d(LOGGING_TAG, "Log.createSubsession was called with no session active.", new Object[0]);
            return null;
        }
        Session newSubsession = new Session(threadSession.getNextChildId(), threadSession.getShortMethodName(), System_Delegate.currentTimeMillis(), isStartedFromActiveSession, threadSession.getOwnerInfo());
        threadSession.addChild(newSubsession);
        newSubsession.setParentSession(threadSession);
        if (!isStartedFromActiveSession) {
            Log.v(LOGGING_TAG, "CREATE_SUBSESSION " + newSubsession.toString(), new Object[0]);
        } else {
            Log.v(LOGGING_TAG, "CREATE_SUBSESSION (Invisible subsession)", new Object[0]);
        }
        return newSubsession;
    }

    public synchronized Session.Info getExternalSession() {
        return this.getExternalSession(null);
    }

    public synchronized Session.Info getExternalSession(String ownerInfo) {
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession == null) {
            Log.d(LOGGING_TAG, "Log.getExternalSession was called with no session active.", new Object[0]);
            return null;
        }
        return threadSession.getExternalInfo(ownerInfo);
    }

    public synchronized void cancelSubsession(Session subsession) {
        if (subsession == null) {
            return;
        }
        subsession.markSessionCompleted(-1L);
        this.endParentSessions(subsession);
    }

    public synchronized void continueSession(Session subsession, String shortMethodName) {
        if (subsession == null) {
            return;
        }
        this.resetStaleSessionTimer();
        subsession.setShortMethodName(shortMethodName);
        subsession.setExecutionStartTimeMs(System_Delegate.currentTimeMillis());
        Session parentSession = subsession.getParentSession();
        if (parentSession == null) {
            Log.i(LOGGING_TAG, "Log.continueSession was called with no session active for method " + shortMethodName, new Object[0]);
            return;
        }
        this.mSessionMapper.put(this.getCallingThreadId(), subsession);
        if (!subsession.isStartedFromActiveSession()) {
            Log.v(LOGGING_TAG, "CONTINUE_SUBSESSION", new Object[0]);
        } else {
            Log.v(LOGGING_TAG, "CONTINUE_SUBSESSION (Invisible Subsession) with Method " + shortMethodName, new Object[0]);
        }
    }

    public synchronized void endSession() {
        int threadId = this.getCallingThreadId();
        Session completedSession = this.mSessionMapper.get(threadId);
        if (completedSession == null) {
            Log.w(LOGGING_TAG, "Log.endSession was called with no session active.", new Object[0]);
            return;
        }
        completedSession.markSessionCompleted(System_Delegate.currentTimeMillis());
        if (!completedSession.isStartedFromActiveSession()) {
            Log.v(LOGGING_TAG, "END_SUBSESSION (dur: " + completedSession.getLocalExecutionTime() + " mS)", new Object[0]);
        } else {
            Log.v(LOGGING_TAG, "END_SUBSESSION (Invisible Subsession) (dur: " + completedSession.getLocalExecutionTime() + " ms)", new Object[0]);
        }
        Session parentSession = completedSession.getParentSession();
        this.mSessionMapper.remove(threadId);
        this.endParentSessions(completedSession);
        if (parentSession != null && !parentSession.isSessionCompleted() && completedSession.isStartedFromActiveSession()) {
            this.mSessionMapper.put(threadId, parentSession);
        }
    }

    private void endParentSessions(Session subsession) {
        if (!subsession.isSessionCompleted() || subsession.getChildSessions().size() != 0) {
            return;
        }
        Session parentSession = subsession.getParentSession();
        if (parentSession != null) {
            subsession.setParentSession(null);
            parentSession.removeChild(subsession);
            if (parentSession.isExternal()) {
                long fullSessionTimeMs = System_Delegate.currentTimeMillis() - subsession.getExecutionStartTimeMilliseconds();
                this.notifySessionCompleteListeners(subsession.getShortMethodName(), fullSessionTimeMs);
            }
            this.endParentSessions(parentSession);
        } else {
            long fullSessionTimeMs = System_Delegate.currentTimeMillis() - subsession.getExecutionStartTimeMilliseconds();
            Log.d(LOGGING_TAG, "END_SESSION (dur: " + fullSessionTimeMs + " ms): " + subsession.toString(), new Object[0]);
            if (!subsession.isExternal()) {
                this.notifySessionCompleteListeners(subsession.getShortMethodName(), fullSessionTimeMs);
            }
        }
    }

    private void notifySessionCompleteListeners(String methodName, long sessionTimeMs) {
        for (ISessionListener l : this.mSessionListeners) {
            l.sessionComplete(methodName, sessionTimeMs);
        }
    }

    public String getSessionId() {
        Session currentSession = this.mSessionMapper.get(this.getCallingThreadId());
        return currentSession != null ? currentSession.toString() : "";
    }

    public synchronized void registerSessionListener(ISessionListener l) {
        if (l != null) {
            this.mSessionListeners.add(l);
        }
    }

    private synchronized String getNextSessionID() {
        Integer nextId;
        if ((long)(nextId = Integer.valueOf(this.sCodeEntryCounter++)).intValue() >= 262144L) {
            this.restartSessionCounter();
            nextId = this.sCodeEntryCounter++;
        }
        return this.getBase64Encoding(nextId);
    }

    private synchronized void restartSessionCounter() {
        this.sCodeEntryCounter = 0;
    }

    private String getBase64Encoding(int number) {
        byte[] idByteArray = ByteBuffer.allocate(4).putInt(number).array();
        idByteArray = Arrays.copyOfRange(idByteArray, 2, 4);
        return Base64.encodeToString(idByteArray, 3);
    }

    private int getCallingThreadId() {
        return this.mCurrentThreadId.get();
    }

    @VisibleForTesting
    public synchronized String printActiveSessions() {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<Integer, Session> entry : this.mSessionMapper.entrySet()) {
            message.append(entry.getValue().printFullSessionTree());
            message.append("\n");
        }
        return message.toString();
    }

    @VisibleForTesting
    public synchronized void cleanupStaleSessions(long timeoutMs) {
        String logMessage = "Stale Sessions Cleaned:\n";
        boolean isSessionsStale = false;
        long currentTimeMs = System_Delegate.currentTimeMillis();
        Iterator<Map.Entry<Integer, Session>> it = this.mSessionMapper.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Session> entry = it.next();
            Session session = entry.getValue();
            if (currentTimeMs - session.getExecutionStartTimeMilliseconds() <= timeoutMs) continue;
            it.remove();
            logMessage = logMessage + session.printFullSessionTree() + "\n";
            isSessionsStale = true;
        }
        if (isSessionsStale) {
            Log.w(LOGGING_TAG, logMessage, new Object[0]);
        } else {
            Log.v(LOGGING_TAG, "No stale logging sessions needed to be cleaned...", new Object[0]);
        }
    }

    private long getCleanupTimeout(Context context) {
        return Settings.Secure.getLong(context.getContentResolver(), "telecom.stale_session_cleanup_timeout_millis", 30000L);
    }

    public static interface ISessionIdQueryHandler {
        public String getSessionId();
    }

    public static interface ISessionListener {
        public void sessionComplete(String var1, long var2);
    }

    public static interface ICurrentThreadId {
        public int get();
    }

    private static interface ISessionCleanupTimeoutMs {
        public long get();
    }
}

