/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.BugreportParams;
import android.os.Handler;
import android.os.IDumpstate;
import android.os.IDumpstateListener;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import libcore.io.IoUtils;

@SystemApi
public class BugreportManager {
    private static final String TAG = "BugreportManager";
    private static final String INTENT_UI_INTENSIVE_BUGREPORT_DUMPS_FINISHED = "com.android.internal.intent.action.UI_INTENSIVE_BUGREPORT_DUMPS_FINISHED";
    private final Context mContext;
    private final IDumpstate mBinder;

    public BugreportManager(Context context, IDumpstate binder) {
        this.mContext = context;
        this.mBinder = binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBugreport(ParcelFileDescriptor bugreportFd, ParcelFileDescriptor screenshotFd, BugreportParams params, Executor executor, BugreportCallback callback) {
        try {
            boolean isScreenshotRequested;
            Preconditions.checkNotNull(bugreportFd);
            Preconditions.checkNotNull(params);
            Preconditions.checkNotNull(executor);
            Preconditions.checkNotNull(callback);
            boolean bl = isScreenshotRequested = screenshotFd != null;
            if (screenshotFd == null) {
                screenshotFd = ParcelFileDescriptor.open(new File("/dev/null"), 0x10000000);
            }
            DumpstateListener dsListener = new DumpstateListener(executor, callback, isScreenshotRequested);
            this.mBinder.startBugreport(-1, this.mContext.getOpPackageName(), bugreportFd.getFileDescriptor(), screenshotFd.getFileDescriptor(), params.getMode(), dsListener, isScreenshotRequested);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (FileNotFoundException e) {
            Log.wtf(TAG, "Not able to find /dev/null file: ", e);
        }
        finally {
            IoUtils.closeQuietly(bugreportFd);
            if (screenshotFd != null) {
                IoUtils.closeQuietly(screenshotFd);
            }
        }
    }

    public void cancelBugreport() {
        try {
            this.mBinder.cancelBugreport();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void requestBugreport(BugreportParams params, CharSequence shareTitle, CharSequence shareDescription) {
        try {
            String title = shareTitle == null ? null : shareTitle.toString();
            String description = shareDescription == null ? null : shareDescription.toString();
            ActivityManager.getService().requestBugReportWithDescription(title, description, params.getMode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class DumpstateListener
    extends IDumpstateListener.Stub {
        private final Executor mExecutor;
        private final BugreportCallback mCallback;
        private final boolean mIsScreenshotRequested;

        DumpstateListener(Executor executor, BugreportCallback callback, boolean isScreenshotRequested) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mIsScreenshotRequested = isScreenshotRequested;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProgress(int progress) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onProgress(progress));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int errorCode) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onError(errorCode));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onFinished() throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> this.mCallback.onFinished());
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void onScreenshotTaken(boolean success) throws RemoteException {
            if (!this.mIsScreenshotRequested) {
                return;
            }
            Handler mainThreadHandler = new Handler(Looper.getMainLooper());
            mainThreadHandler.post(() -> {
                int message = success ? 17039782 : 17039781;
                Toast.makeText(BugreportManager.this.mContext, message, 1).show();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUiIntensiveBugreportDumpsFinished(String callingPackage) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(() -> {
                    Intent intent = new Intent(BugreportManager.INTENT_UI_INTENSIVE_BUGREPORT_DUMPS_FINISHED);
                    intent.setPackage(callingPackage);
                    intent.addFlags(0x10000000);
                    intent.addFlags(0x1000000);
                    BugreportManager.this.mContext.sendBroadcast(intent, "android.permission.DUMP");
                });
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static abstract class BugreportCallback {
        public static final int BUGREPORT_ERROR_INVALID_INPUT = 1;
        public static final int BUGREPORT_ERROR_RUNTIME = 2;
        public static final int BUGREPORT_ERROR_USER_DENIED_CONSENT = 3;
        public static final int BUGREPORT_ERROR_USER_CONSENT_TIMED_OUT = 4;
        public static final int BUGREPORT_ERROR_ANOTHER_REPORT_IN_PROGRESS = 5;

        public void onProgress(float progress) {
        }

        public void onError(int errorCode) {
        }

        public void onFinished() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BugreportErrorCode {
        }
    }
}

