/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.net.module.util.Inet4AddressUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.Locale;

public class WifiInfo
implements Parcelable {
    private static final String TAG = "WifiInfo";
    private static final EnumMap<SupplicantState, NetworkInfo.DetailedState> stateMap = new EnumMap(SupplicantState.class);
    @SystemApi
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    private SupplicantState mSupplicantState;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private String mBSSID;
    @UnsupportedAppUsage
    private WifiSsid mWifiSsid;
    private int mNetworkId;
    @SystemApi
    public static final int INVALID_RSSI = -127;
    public static final int MIN_RSSI = -126;
    public static final int MAX_RSSI = 200;
    private int mRssi;
    private int mWifiStandard;
    public static final String LINK_SPEED_UNITS = "Mbps";
    private int mLinkSpeed;
    public static final int LINK_SPEED_UNKNOWN = -1;
    private int mTxLinkSpeed;
    private int mMaxSupportedTxLinkSpeed;
    private int mRxLinkSpeed;
    private int mMaxSupportedRxLinkSpeed;
    public static final String FREQUENCY_UNITS = "MHz";
    private int mFrequency;
    @UnsupportedAppUsage
    private InetAddress mIpAddress;
    @UnsupportedAppUsage
    private String mMacAddress = "02:00:00:00:00:00";
    private boolean mEphemeral;
    private boolean mTrusted;
    private boolean mOsuAp;
    private String mFqdn;
    private String mProviderFriendlyName;
    private String mRequestingPackageName;
    public long txBad;
    public long txRetries;
    public long txSuccess;
    public long rxSuccess;
    private double mLostTxPacketsPerSecond;
    private double mTxRetriedTxPacketsPerSecond;
    private double mSuccessfulTxPacketsPerSecond;
    private double mSuccessfulRxPacketsPerSecond;
    @UnsupportedAppUsage
    public int score;
    private boolean mMeteredHint;
    private String mPasspointUniqueId;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<WifiInfo> CREATOR;

    @SystemApi
    public double getLostTxPacketsPerSecond() {
        return this.mLostTxPacketsPerSecond;
    }

    public void setLostTxPacketsPerSecond(double lostTxPacketsPerSecond) {
        this.mLostTxPacketsPerSecond = lostTxPacketsPerSecond;
    }

    @SystemApi
    public double getRetriedTxPacketsPerSecond() {
        return this.mTxRetriedTxPacketsPerSecond;
    }

    public void setRetriedTxPacketsRate(double txRetriedTxPacketsPerSecond) {
        this.mTxRetriedTxPacketsPerSecond = txRetriedTxPacketsPerSecond;
    }

    @SystemApi
    public double getSuccessfulTxPacketsPerSecond() {
        return this.mSuccessfulTxPacketsPerSecond;
    }

    public void setSuccessfulTxPacketsPerSecond(double successfulTxPacketsPerSecond) {
        this.mSuccessfulTxPacketsPerSecond = successfulTxPacketsPerSecond;
    }

    @SystemApi
    public double getSuccessfulRxPacketsPerSecond() {
        return this.mSuccessfulRxPacketsPerSecond;
    }

    public void setSuccessfulRxPacketsPerSecond(double successfulRxPacketsPerSecond) {
        this.mSuccessfulRxPacketsPerSecond = successfulRxPacketsPerSecond;
    }

    @SystemApi
    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    @UnsupportedAppUsage
    public WifiInfo() {
        this.mWifiSsid = null;
        this.mBSSID = null;
        this.mNetworkId = -1;
        this.mSupplicantState = SupplicantState.UNINITIALIZED;
        this.mRssi = -127;
        this.mLinkSpeed = -1;
        this.mFrequency = -1;
    }

    public void reset() {
        this.setInetAddress(null);
        this.setBSSID(null);
        this.setSSID(null);
        this.setNetworkId(-1);
        this.setRssi(-127);
        this.setLinkSpeed(-1);
        this.setTxLinkSpeedMbps(-1);
        this.setRxLinkSpeedMbps(-1);
        this.setMaxSupportedTxLinkSpeedMbps(-1);
        this.setMaxSupportedRxLinkSpeedMbps(-1);
        this.setFrequency(-1);
        this.setMeteredHint(false);
        this.setEphemeral(false);
        this.setOsuAp(false);
        this.setRequestingPackageName(null);
        this.setFQDN(null);
        this.setProviderFriendlyName(null);
        this.setPasspointUniqueId(null);
        this.txBad = 0L;
        this.txSuccess = 0L;
        this.rxSuccess = 0L;
        this.txRetries = 0L;
        this.mLostTxPacketsPerSecond = 0.0;
        this.mSuccessfulTxPacketsPerSecond = 0.0;
        this.mSuccessfulRxPacketsPerSecond = 0.0;
        this.mTxRetriedTxPacketsPerSecond = 0.0;
        this.score = 0;
    }

    public WifiInfo(WifiInfo source) {
        if (source != null) {
            this.mSupplicantState = source.mSupplicantState;
            this.mBSSID = source.mBSSID;
            this.mWifiSsid = source.mWifiSsid;
            this.mNetworkId = source.mNetworkId;
            this.mRssi = source.mRssi;
            this.mLinkSpeed = source.mLinkSpeed;
            this.mTxLinkSpeed = source.mTxLinkSpeed;
            this.mRxLinkSpeed = source.mRxLinkSpeed;
            this.mFrequency = source.mFrequency;
            this.mIpAddress = source.mIpAddress;
            this.mMacAddress = source.mMacAddress;
            this.mMeteredHint = source.mMeteredHint;
            this.mEphemeral = source.mEphemeral;
            this.mTrusted = source.mTrusted;
            this.mRequestingPackageName = source.mRequestingPackageName;
            this.mOsuAp = source.mOsuAp;
            this.mFqdn = source.mFqdn;
            this.mProviderFriendlyName = source.mProviderFriendlyName;
            this.txBad = source.txBad;
            this.txRetries = source.txRetries;
            this.txSuccess = source.txSuccess;
            this.rxSuccess = source.rxSuccess;
            this.mLostTxPacketsPerSecond = source.mLostTxPacketsPerSecond;
            this.mTxRetriedTxPacketsPerSecond = source.mTxRetriedTxPacketsPerSecond;
            this.mSuccessfulTxPacketsPerSecond = source.mSuccessfulTxPacketsPerSecond;
            this.mSuccessfulRxPacketsPerSecond = source.mSuccessfulRxPacketsPerSecond;
            this.score = source.score;
            this.mWifiStandard = source.mWifiStandard;
            this.mMaxSupportedTxLinkSpeed = source.mMaxSupportedTxLinkSpeed;
            this.mMaxSupportedRxLinkSpeed = source.mMaxSupportedRxLinkSpeed;
            this.mPasspointUniqueId = source.mPasspointUniqueId;
        }
    }

    public void setSSID(WifiSsid wifiSsid) {
        this.mWifiSsid = wifiSsid;
    }

    public String getSSID() {
        if (this.mWifiSsid != null) {
            String unicode = this.mWifiSsid.toString();
            if (!TextUtils.isEmpty(unicode)) {
                return "\"" + unicode + "\"";
            }
            String hex = this.mWifiSsid.getHexString();
            return hex != null ? hex : "<unknown ssid>";
        }
        return "<unknown ssid>";
    }

    @UnsupportedAppUsage
    public WifiSsid getWifiSsid() {
        return this.mWifiSsid;
    }

    @UnsupportedAppUsage
    public void setBSSID(String BSSID) {
        this.mBSSID = BSSID;
    }

    public String getBSSID() {
        return this.mBSSID;
    }

    public int getRssi() {
        return this.mRssi;
    }

    @UnsupportedAppUsage
    public void setRssi(int rssi) {
        if (rssi < -127) {
            rssi = -127;
        }
        if (rssi > 200) {
            rssi = 200;
        }
        this.mRssi = rssi;
    }

    public void setWifiStandard(int wifiStandard) {
        this.mWifiStandard = wifiStandard;
    }

    public int getWifiStandard() {
        return this.mWifiStandard;
    }

    public int getLinkSpeed() {
        return this.mLinkSpeed;
    }

    @UnsupportedAppUsage
    public void setLinkSpeed(int linkSpeed) {
        this.mLinkSpeed = linkSpeed;
    }

    public int getTxLinkSpeedMbps() {
        return this.mTxLinkSpeed;
    }

    public int getMaxSupportedTxLinkSpeedMbps() {
        return this.mMaxSupportedTxLinkSpeed;
    }

    public void setTxLinkSpeedMbps(int txLinkSpeed) {
        this.mTxLinkSpeed = txLinkSpeed;
    }

    public void setMaxSupportedTxLinkSpeedMbps(int maxSupportedTxLinkSpeed) {
        this.mMaxSupportedTxLinkSpeed = maxSupportedTxLinkSpeed;
    }

    public int getRxLinkSpeedMbps() {
        return this.mRxLinkSpeed;
    }

    public int getMaxSupportedRxLinkSpeedMbps() {
        return this.mMaxSupportedRxLinkSpeed;
    }

    public void setRxLinkSpeedMbps(int rxLinkSpeed) {
        this.mRxLinkSpeed = rxLinkSpeed;
    }

    public void setMaxSupportedRxLinkSpeedMbps(int maxSupportedRxLinkSpeed) {
        this.mMaxSupportedRxLinkSpeed = maxSupportedRxLinkSpeed;
    }

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int frequency) {
        this.mFrequency = frequency;
    }

    public boolean is24GHz() {
        return ScanResult.is24GHz(this.mFrequency);
    }

    @UnsupportedAppUsage
    public boolean is5GHz() {
        return ScanResult.is5GHz(this.mFrequency);
    }

    public boolean is6GHz() {
        return ScanResult.is6GHz(this.mFrequency);
    }

    @UnsupportedAppUsage
    public void setMacAddress(String macAddress) {
        this.mMacAddress = macAddress;
    }

    public String getMacAddress() {
        return this.mMacAddress;
    }

    public boolean hasRealMacAddress() {
        return this.mMacAddress != null && !DEFAULT_MAC_ADDRESS.equals(this.mMacAddress);
    }

    public void setMeteredHint(boolean meteredHint) {
        this.mMeteredHint = meteredHint;
    }

    @UnsupportedAppUsage
    public boolean getMeteredHint() {
        return this.mMeteredHint;
    }

    public void setEphemeral(boolean ephemeral) {
        this.mEphemeral = ephemeral;
    }

    @SystemApi
    public boolean isEphemeral() {
        return this.mEphemeral;
    }

    public void setTrusted(boolean trusted) {
        this.mTrusted = trusted;
    }

    public boolean isTrusted() {
        return this.mTrusted;
    }

    public void setOsuAp(boolean osuAp) {
        this.mOsuAp = osuAp;
    }

    @SystemApi
    public boolean isOsuAp() {
        return this.mOsuAp;
    }

    @SystemApi
    public boolean isPasspointAp() {
        return this.mFqdn != null && this.mProviderFriendlyName != null;
    }

    public void setFQDN(String fqdn) {
        this.mFqdn = fqdn;
    }

    public String getPasspointFqdn() {
        return this.mFqdn;
    }

    public void setProviderFriendlyName(String providerFriendlyName) {
        this.mProviderFriendlyName = providerFriendlyName;
    }

    public String getPasspointProviderFriendlyName() {
        return this.mProviderFriendlyName;
    }

    public void setRequestingPackageName(String packageName) {
        this.mRequestingPackageName = packageName;
    }

    @SystemApi
    public String getRequestingPackageName() {
        return this.mRequestingPackageName;
    }

    @UnsupportedAppUsage
    public void setNetworkId(int id2) {
        this.mNetworkId = id2;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public SupplicantState getSupplicantState() {
        return this.mSupplicantState;
    }

    @UnsupportedAppUsage
    public void setSupplicantState(SupplicantState state) {
        this.mSupplicantState = state;
    }

    public void setInetAddress(InetAddress address) {
        this.mIpAddress = address;
    }

    public int getIpAddress() {
        int result = 0;
        if (this.mIpAddress instanceof Inet4Address) {
            result = Inet4AddressUtils.inet4AddressToIntHTL((Inet4Address)this.mIpAddress);
        }
        return result;
    }

    public boolean getHiddenSSID() {
        if (this.mWifiSsid == null) {
            return false;
        }
        return this.mWifiSsid.isHidden();
    }

    public static NetworkInfo.DetailedState getDetailedStateOf(SupplicantState suppState) {
        return stateMap.get(suppState);
    }

    @UnsupportedAppUsage
    void setSupplicantState(String stateName) {
        this.mSupplicantState = WifiInfo.valueOf(stateName);
    }

    static SupplicantState valueOf(String stateName) {
        if ("4WAY_HANDSHAKE".equalsIgnoreCase(stateName)) {
            return SupplicantState.FOUR_WAY_HANDSHAKE;
        }
        try {
            return SupplicantState.valueOf(stateName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return SupplicantState.INVALID;
        }
    }

    @SystemApi
    public static String sanitizeSsid(String string2) {
        return WifiInfo.removeDoubleQuotes(string2);
    }

    @UnsupportedAppUsage
    public static String removeDoubleQuotes(String string2) {
        if (string2 == null) {
            return null;
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.mWifiSsid == null ? "<unknown ssid>" : this.mWifiSsid).append(", BSSID: ").append(this.mBSSID == null ? none : this.mBSSID).append(", MAC: ").append(this.mMacAddress == null ? none : this.mMacAddress).append(", Supplicant state: ").append(this.mSupplicantState == null ? none : this.mSupplicantState).append(", Wi-Fi standard: ").append(this.mWifiStandard).append(", RSSI: ").append(this.mRssi).append(", Link speed: ").append(this.mLinkSpeed).append(LINK_SPEED_UNITS).append(", Tx Link speed: ").append(this.mTxLinkSpeed).append(LINK_SPEED_UNITS).append(", Max Supported Tx Link speed: ").append(this.mMaxSupportedTxLinkSpeed).append(LINK_SPEED_UNITS).append(", Rx Link speed: ").append(this.mRxLinkSpeed).append(LINK_SPEED_UNITS).append(", Max Supported Rx Link speed: ").append(this.mMaxSupportedRxLinkSpeed).append(LINK_SPEED_UNITS).append(", Frequency: ").append(this.mFrequency).append(FREQUENCY_UNITS).append(", Net ID: ").append(this.mNetworkId).append(", Metered hint: ").append(this.mMeteredHint).append(", score: ").append(Integer.toString(this.score));
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkId);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mLinkSpeed);
        dest.writeInt(this.mTxLinkSpeed);
        dest.writeInt(this.mRxLinkSpeed);
        dest.writeInt(this.mFrequency);
        if (this.mIpAddress != null) {
            dest.writeByte((byte)1);
            dest.writeByteArray(this.mIpAddress.getAddress());
        } else {
            dest.writeByte((byte)0);
        }
        if (this.mWifiSsid != null) {
            dest.writeInt(1);
            this.mWifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.mBSSID);
        dest.writeString(this.mMacAddress);
        dest.writeInt(this.mMeteredHint ? 1 : 0);
        dest.writeInt(this.mEphemeral ? 1 : 0);
        dest.writeInt(this.mTrusted ? 1 : 0);
        dest.writeInt(this.score);
        dest.writeLong(this.txSuccess);
        dest.writeDouble(this.mSuccessfulTxPacketsPerSecond);
        dest.writeLong(this.txRetries);
        dest.writeDouble(this.mTxRetriedTxPacketsPerSecond);
        dest.writeLong(this.txBad);
        dest.writeDouble(this.mLostTxPacketsPerSecond);
        dest.writeLong(this.rxSuccess);
        dest.writeDouble(this.mSuccessfulRxPacketsPerSecond);
        this.mSupplicantState.writeToParcel(dest, flags);
        dest.writeInt(this.mOsuAp ? 1 : 0);
        dest.writeString(this.mRequestingPackageName);
        dest.writeString(this.mFqdn);
        dest.writeString(this.mProviderFriendlyName);
        dest.writeInt(this.mWifiStandard);
        dest.writeInt(this.mMaxSupportedTxLinkSpeed);
        dest.writeInt(this.mMaxSupportedRxLinkSpeed);
        dest.writeString(this.mPasspointUniqueId);
    }

    public void setPasspointUniqueId(String passpointUniqueId) {
        this.mPasspointUniqueId = passpointUniqueId;
    }

    public String getPasspointUniqueId() {
        return this.mPasspointUniqueId;
    }

    static {
        stateMap.put(SupplicantState.DISCONNECTED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INTERFACE_DISABLED, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.INACTIVE, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.SCANNING, NetworkInfo.DetailedState.SCANNING);
        stateMap.put(SupplicantState.AUTHENTICATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATING, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.ASSOCIATED, NetworkInfo.DetailedState.CONNECTING);
        stateMap.put(SupplicantState.FOUR_WAY_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.GROUP_HANDSHAKE, NetworkInfo.DetailedState.AUTHENTICATING);
        stateMap.put(SupplicantState.COMPLETED, NetworkInfo.DetailedState.OBTAINING_IPADDR);
        stateMap.put(SupplicantState.DORMANT, NetworkInfo.DetailedState.DISCONNECTED);
        stateMap.put(SupplicantState.UNINITIALIZED, NetworkInfo.DetailedState.IDLE);
        stateMap.put(SupplicantState.INVALID, NetworkInfo.DetailedState.FAILED);
        CREATOR = new Parcelable.Creator<WifiInfo>(){

            @Override
            public WifiInfo createFromParcel(Parcel in) {
                WifiInfo info = new WifiInfo();
                info.setNetworkId(in.readInt());
                info.setRssi(in.readInt());
                info.setLinkSpeed(in.readInt());
                info.setTxLinkSpeedMbps(in.readInt());
                info.setRxLinkSpeedMbps(in.readInt());
                info.setFrequency(in.readInt());
                if (in.readByte() == 1) {
                    try {
                        info.setInetAddress(InetAddress.getByAddress(in.createByteArray()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                if (in.readInt() == 1) {
                    info.mWifiSsid = WifiSsid.CREATOR.createFromParcel(in);
                }
                info.mBSSID = in.readString();
                info.mMacAddress = in.readString();
                info.mMeteredHint = in.readInt() != 0;
                info.mEphemeral = in.readInt() != 0;
                info.mTrusted = in.readInt() != 0;
                info.score = in.readInt();
                info.txSuccess = in.readLong();
                info.mSuccessfulTxPacketsPerSecond = in.readDouble();
                info.txRetries = in.readLong();
                info.mTxRetriedTxPacketsPerSecond = in.readDouble();
                info.txBad = in.readLong();
                info.mLostTxPacketsPerSecond = in.readDouble();
                info.rxSuccess = in.readLong();
                info.mSuccessfulRxPacketsPerSecond = in.readDouble();
                info.mSupplicantState = SupplicantState.CREATOR.createFromParcel(in);
                info.mOsuAp = in.readInt() != 0;
                info.mRequestingPackageName = in.readString();
                info.mFqdn = in.readString();
                info.mProviderFriendlyName = in.readString();
                info.mWifiStandard = in.readInt();
                info.mMaxSupportedTxLinkSpeed = in.readInt();
                info.mMaxSupportedRxLinkSpeed = in.readInt();
                info.mPasspointUniqueId = in.readString();
                return info;
            }

            public WifiInfo[] newArray(int size) {
                return new WifiInfo[size];
            }
        };
    }

    public static class Builder {
        private final WifiInfo mWifiInfo = new WifiInfo();

        public Builder setSsid(byte[] ssid) {
            this.mWifiInfo.setSSID(WifiSsid.createFromByteArray(ssid));
            return this;
        }

        public Builder setBssid(String bssid) {
            this.mWifiInfo.setBSSID(bssid);
            return this;
        }

        public Builder setRssi(int rssi) {
            this.mWifiInfo.setRssi(rssi);
            return this;
        }

        public Builder setNetworkId(int networkId) {
            this.mWifiInfo.setNetworkId(networkId);
            return this;
        }

        public WifiInfo build() {
            return new WifiInfo(this.mWifiInfo);
        }
    }
}

