/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class SoftApCapability
implements Parcelable {
    public static final long SOFTAP_FEATURE_ACS_OFFLOAD = 1L;
    public static final long SOFTAP_FEATURE_CLIENT_FORCE_DISCONNECT = 2L;
    public static final long SOFTAP_FEATURE_WPA3_SAE = 4L;
    private long mSupportedFeatures = 0L;
    private int mMaximumSupportedClientNumber;
    public static final Parcelable.Creator<SoftApCapability> CREATOR = new Parcelable.Creator<SoftApCapability>(){

        @Override
        public SoftApCapability createFromParcel(Parcel in) {
            long supportedFeatures = in.readLong();
            SoftApCapability capability = new SoftApCapability(supportedFeatures);
            capability.mMaximumSupportedClientNumber = in.readInt();
            return capability;
        }

        public SoftApCapability[] newArray(int size) {
            return new SoftApCapability[size];
        }
    };

    public int getMaxSupportedClients() {
        return this.mMaximumSupportedClientNumber;
    }

    public void setMaxSupportedClients(int maxClient) {
        this.mMaximumSupportedClientNumber = maxClient;
    }

    public boolean areFeaturesSupported(long features) {
        return (this.mSupportedFeatures & features) == features;
    }

    public SoftApCapability(SoftApCapability source) {
        if (source != null) {
            this.mSupportedFeatures = source.mSupportedFeatures;
            this.mMaximumSupportedClientNumber = source.mMaximumSupportedClientNumber;
        }
    }

    public SoftApCapability(long features) {
        this.mSupportedFeatures = features;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mSupportedFeatures);
        dest.writeInt(this.mMaximumSupportedClientNumber);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("SupportedFeatures=").append(this.mSupportedFeatures);
        sbuf.append("MaximumSupportedClientNumber=").append(this.mMaximumSupportedClientNumber);
        return sbuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApCapability)) {
            return false;
        }
        SoftApCapability capability = (SoftApCapability)o;
        return this.mSupportedFeatures == capability.mSupportedFeatures && this.mMaximumSupportedClientNumber == capability.mMaximumSupportedClientNumber;
    }

    public int hashCode() {
        return Objects.hash(this.mSupportedFeatures, this.mMaximumSupportedClientNumber);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HotspotFeatures {
    }
}

