/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ScoredNetwork;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface INetworkScoreCache
extends IInterface {
    public void updateScores(List<ScoredNetwork> var1) throws RemoteException;

    public void clearScores() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkScoreCache {
        private static final String DESCRIPTOR = "android.net.INetworkScoreCache";
        static final int TRANSACTION_updateScores = 1;
        static final int TRANSACTION_clearScores = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkScoreCache asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkScoreCache) {
                return (INetworkScoreCache)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateScores";
                }
                case 2: {
                    return "clearScores";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScoredNetwork> _arg0 = data.createTypedArrayList(ScoredNetwork.CREATOR);
                    this.updateScores(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.clearScores();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkScoreCache impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkScoreCache getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkScoreCache {
            private IBinder mRemote;
            public static INetworkScoreCache sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateScores(List<ScoredNetwork> networks) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networks);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateScores(networks);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void clearScores() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearScores();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkScoreCache {
        @Override
        public void updateScores(List<ScoredNetwork> networks) throws RemoteException {
        }

        @Override
        public void clearScores() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

