/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.media.AudioPresentation;
import android.media.AudioSystem;
import android.media.Image;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaDescrambler;
import android.media.MediaFormat;
import android.media.Utils;
import android.os.Bundle;
import android.os.Handler;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.view.Surface;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import com.android.tools.layoutlib.java.NioUtils_Delegate;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MediaCodec {
    public static final int BUFFER_FLAG_SYNC_FRAME = 1;
    public static final int BUFFER_FLAG_KEY_FRAME = 1;
    public static final int BUFFER_FLAG_CODEC_CONFIG = 2;
    public static final int BUFFER_FLAG_END_OF_STREAM = 4;
    public static final int BUFFER_FLAG_PARTIAL_FRAME = 8;
    public static final int BUFFER_FLAG_MUXER_DATA = 16;
    private EventHandler mEventHandler;
    private EventHandler mOnFrameRenderedHandler;
    private EventHandler mCallbackHandler;
    private Callback mCallback;
    private OnFrameRenderedListener mOnFrameRenderedListener;
    private final Object mListenerLock = new Object();
    private MediaCodecInfo mCodecInfo;
    private final Object mCodecInfoLock = new Object();
    private MediaCrypto mCrypto;
    private static final int EVENT_CALLBACK = 1;
    private static final int EVENT_SET_CALLBACK = 2;
    private static final int EVENT_FRAME_RENDERED = 3;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_ERROR = 3;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    private boolean mHasSurface = false;
    private String mNameAtCreation;
    public static final int CONFIGURE_FLAG_ENCODE = 1;
    public static final int CONFIGURE_FLAG_USE_BLOCK_MODEL = 2;
    private static final int BUFFER_MODE_INVALID = -1;
    private static final int BUFFER_MODE_LEGACY = 0;
    private static final int BUFFER_MODE_BLOCK = 1;
    private int mBufferMode = -1;
    public static final int CRYPTO_MODE_UNENCRYPTED = 0;
    public static final int CRYPTO_MODE_AES_CTR = 1;
    public static final int CRYPTO_MODE_AES_CBC = 2;
    private final ArrayList<QueueRequest> mQueueRequests = new ArrayList();
    public static final int INFO_TRY_AGAIN_LATER = -1;
    public static final int INFO_OUTPUT_FORMAT_CHANGED = -2;
    public static final int INFO_OUTPUT_BUFFERS_CHANGED = -3;
    private ByteBuffer[] mCachedInputBuffers;
    private ByteBuffer[] mCachedOutputBuffers;
    private final BufferMap mDequeuedInputBuffers = new BufferMap();
    private final BufferMap mDequeuedOutputBuffers = new BufferMap();
    private final Map<Integer, BufferInfo> mDequeuedOutputInfos = new HashMap<Integer, BufferInfo>();
    private final Object mBufferLock;
    private final ArrayList<OutputFrame> mOutputFrames = new ArrayList();
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT = 1;
    public static final int VIDEO_SCALING_MODE_SCALE_TO_FIT_WITH_CROPPING = 2;
    public static final String PARAMETER_KEY_VIDEO_BITRATE = "video-bitrate";
    public static final String PARAMETER_KEY_SUSPEND = "drop-input-frames";
    public static final String PARAMETER_KEY_SUSPEND_TIME = "drop-start-time-us";
    public static final String PARAMETER_KEY_OFFSET_TIME = "time-offset-us";
    public static final String PARAMETER_KEY_REQUEST_SYNC_FRAME = "request-sync";
    public static final String PARAMETER_KEY_HDR10_PLUS_INFO = "hdr10-plus-info";
    public static final String PARAMETER_KEY_LOW_LATENCY = "low-latency";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private long mNativeContext = 0L;
    private final Lock mNativeContextLock = new ReentrantLock();

    public static MediaCodec createDecoderByType(String type) throws IOException {
        return new MediaCodec(type, true, false);
    }

    public static MediaCodec createEncoderByType(String type) throws IOException {
        return new MediaCodec(type, true, true);
    }

    public static MediaCodec createByCodecName(String name) throws IOException {
        return new MediaCodec(name, false, false);
    }

    private MediaCodec(String name, boolean nameIsType, boolean encoder) {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mCallbackHandler = this.mEventHandler;
        this.mOnFrameRenderedHandler = this.mEventHandler;
        this.mBufferLock = new Object();
        this.mNameAtCreation = nameIsType ? null : name;
        this.native_setup(name, nameIsType, encoder);
    }

    protected void finalize() {
        this.native_finalize();
        this.mCrypto = null;
    }

    public void reset() {
        this.freeAllTrackedBuffers();
        this.native_reset();
        this.mCrypto = null;
    }

    private void native_reset() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_reset()V", true, this);
    }

    public void release() {
        this.freeAllTrackedBuffers();
        this.native_release();
        this.mCrypto = null;
    }

    private void native_release() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_release()V", true, this);
    }

    public void configure(MediaFormat format, Surface surface, MediaCrypto crypto, int flags) {
        this.configure(format, surface, crypto, null, flags);
    }

    public void configure(MediaFormat format, Surface surface, int flags, MediaDescrambler descrambler) {
        this.configure(format, surface, null, descrambler != null ? descrambler.getBinder() : null, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(MediaFormat format, Surface surface, MediaCrypto crypto, IHwBinder descramblerBinder, int flags) {
        if (crypto != null && descramblerBinder != null) {
            throw new IllegalArgumentException("Can't use crypto and descrambler together!");
        }
        String[] keys = null;
        Object[] values = null;
        if (format != null) {
            Map<String, Object> formatMap = format.getMap();
            keys = new String[formatMap.size()];
            values = new Object[formatMap.size()];
            int i = 0;
            for (Map.Entry<String, Object> entry : formatMap.entrySet()) {
                if (entry.getKey().equals("audio-session-id")) {
                    int sessionId = 0;
                    try {
                        sessionId = (Integer)entry.getValue();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Wrong Session ID Parameter!");
                    }
                    keys[i] = "audio-hw-sync";
                    values[i] = AudioSystem.getAudioHwSyncForSession(sessionId);
                } else {
                    keys[i] = entry.getKey();
                    values[i] = entry.getValue();
                }
                ++i;
            }
        }
        this.mHasSurface = surface != null;
        this.mCrypto = crypto;
        Object object = this.mBufferLock;
        synchronized (object) {
            this.mBufferMode = (flags & 2) != 0 ? 1 : 0;
        }
        this.native_configure(keys, values, surface, crypto, descramblerBinder, flags);
    }

    public void setOutputSurface(Surface surface) {
        if (!this.mHasSurface) {
            throw new IllegalStateException("codec was not configured for an output surface");
        }
        this.native_setSurface(surface);
    }

    private void native_setSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setSurface(Landroid/view/Surface;)V", true, this);
    }

    public static Surface createPersistentInputSurface() {
        return MediaCodec.native_createPersistentInputSurface();
    }

    public void setInputSurface(Surface surface) {
        if (!(surface instanceof PersistentSurface)) {
            throw new IllegalArgumentException("not a PersistentSurface");
        }
        this.native_setInputSurface(surface);
    }

    private static PersistentSurface native_createPersistentInputSurface() {
        return (PersistentSurface)OverrideMethod.invokeA("android.media.MediaCodec#native_createPersistentInputSurface()Landroid/media/MediaCodec$PersistentSurface;", true, null);
    }

    private static void native_releasePersistentInputSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_releasePersistentInputSurface(Landroid/view/Surface;)V", true, null);
    }

    private void native_setInputSurface(Surface surface) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setInputSurface(Landroid/view/Surface;)V", true, this);
    }

    private void native_setCallback(Callback callback) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setCallback(Landroid/media/MediaCodec$Callback;)V", true, this);
    }

    private void native_configure(String[] stringArray, Object[] objectArray, Surface surface, MediaCrypto mediaCrypto, IHwBinder iHwBinder, int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_configure([Ljava/lang/String;[Ljava/lang/Object;Landroid/view/Surface;Landroid/media/MediaCrypto;Landroid/os/IHwBinder;I)V", true, this);
    }

    public Surface createInputSurface() {
        return (Surface)OverrideMethod.invokeA("android.media.MediaCodec#createInputSurface()Landroid/view/Surface;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.native_start();
        Object object = this.mBufferLock;
        synchronized (object) {
            this.cacheBuffers(true);
            this.cacheBuffers(false);
        }
    }

    private void native_start() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_start()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.native_stop();
        this.freeAllTrackedBuffers();
        Object object = this.mListenerLock;
        synchronized (object) {
            if (this.mCallbackHandler != null) {
                this.mCallbackHandler.removeMessages(2);
                this.mCallbackHandler.removeMessages(1);
            }
            if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
        }
    }

    private void native_stop() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_stop()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.invalidateByteBuffers(this.mCachedInputBuffers);
            this.invalidateByteBuffers(this.mCachedOutputBuffers);
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
        }
        this.native_flush();
    }

    private void native_flush() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_flush()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueInputBuffer(index, offset, size, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private void native_queueInputBuffer(int n, int n2, int n3, long l, int n4) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueInputBuffer(IIIJI)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) throws CryptoException {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("queueSecureInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getQueueRequest() to queue buffers");
            }
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.remove(index);
        }
        try {
            this.native_queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
        }
        catch (CryptoException | IllegalStateException e) {
            this.revalidateByteBuffer(this.mCachedInputBuffers, index);
            throw e;
        }
    }

    private void native_queueSecureInputBuffer(int n, int n2, CryptoInfo cryptoInfo, long l, int n3) throws CryptoException {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueSecureInputBuffer(IILandroid/media/MediaCodec$CryptoInfo;JI)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueInputBuffer(long timeoutUs) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("dequeueInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use MediaCodec.Callback objectes to get input buffer slots.");
            }
        }
        int res = this.native_dequeueInputBuffer(timeoutUs);
        if (res >= 0) {
            Object object2 = this.mBufferLock;
            synchronized (object2) {
                this.validateInputByteBuffer(this.mCachedInputBuffers, res);
            }
        }
        return res;
    }

    private int native_dequeueInputBuffer(long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueInputBuffer(J)I", true, this);
    }

    public static Image mapHardwareBuffer(HardwareBuffer hardwareBuffer) {
        return MediaCodec.native_mapHardwareBuffer(hardwareBuffer);
    }

    private static Image native_mapHardwareBuffer(HardwareBuffer hardwareBuffer) {
        return (Image)OverrideMethod.invokeA("android.media.MediaCodec#native_mapHardwareBuffer(Landroid/hardware/HardwareBuffer;)Landroid/media/Image;", true, null);
    }

    private static void native_closeMediaImage(long l) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_closeMediaImage(J)V", true, null);
    }

    private void native_queueLinearBlock(int n, LinearBlock linearBlock, int n2, int n3, CryptoInfo cryptoInfo, long l, int n4, ArrayList<String> arrayList, ArrayList<Object> arrayList2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueLinearBlock(ILandroid/media/MediaCodec$LinearBlock;IILandroid/media/MediaCodec$CryptoInfo;JILjava/util/ArrayList;Ljava/util/ArrayList;)V", true, this);
    }

    private void native_queueHardwareBuffer(int n, HardwareBuffer hardwareBuffer, long l, int n2, ArrayList<String> arrayList, ArrayList<Object> arrayList2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_queueHardwareBuffer(ILandroid/hardware/HardwareBuffer;JILjava/util/ArrayList;Ljava/util/ArrayList;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueRequest getQueueRequest(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode != 1) {
                throw new IllegalStateException("The codec is not configured for block model");
            }
            if (index < 0 || index >= this.mQueueRequests.size()) {
                throw new IndexOutOfBoundsException("Expected range of index: [0," + (this.mQueueRequests.size() - 1) + "]; actual: " + index);
            }
            QueueRequest request = this.mQueueRequests.get(index);
            if (request == null) {
                throw new IllegalArgumentException("Unavailable index: " + index);
            }
            if (!request.isAccessible()) {
                throw new IllegalArgumentException("The request is stale at index " + index);
            }
            return request.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueOutputBuffer(BufferInfo info, long timeoutUs) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("dequeueOutputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use MediaCodec.Callback objects to get output buffer slots.");
            }
        }
        int res = this.native_dequeueOutputBuffer(info, timeoutUs);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            if (res == -3) {
                this.cacheBuffers(false);
            } else if (res >= 0) {
                this.validateOutputByteBuffer(this.mCachedOutputBuffers, res, info);
                if (this.mHasSurface) {
                    this.mDequeuedOutputInfos.put(res, info.dup());
                }
            }
        }
        return res;
    }

    private int native_dequeueOutputBuffer(BufferInfo bufferInfo, long l) {
        return OverrideMethod.invokeI("android.media.MediaCodec#native_dequeueOutputBuffer(Landroid/media/MediaCodec$BufferInfo;J)I", true, this);
    }

    public void releaseOutputBuffer(int index, boolean render) {
        this.releaseOutputBufferInternal(index, render, false, 0L);
    }

    public void releaseOutputBuffer(int index, long renderTimestampNs) {
        this.releaseOutputBufferInternal(index, true, true, renderTimestampNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOutputBufferInternal(int index, boolean render, boolean updatePts, long renderTimestampNs) {
        BufferInfo info = null;
        Object object = this.mBufferLock;
        synchronized (object) {
            switch (this.mBufferMode) {
                case 0: {
                    this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
                    this.mDequeuedOutputBuffers.remove(index);
                    if (!this.mHasSurface) break;
                    info = this.mDequeuedOutputInfos.remove(index);
                    break;
                }
                case 1: {
                    OutputFrame frame = this.mOutputFrames.get(index);
                    frame.setAccessible(false);
                    frame.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized buffer mode: " + this.mBufferMode);
                }
            }
        }
        this.releaseOutputBuffer(index, render, updatePts, renderTimestampNs);
    }

    @UnsupportedAppUsage
    private void releaseOutputBuffer(int n, boolean bl, boolean bl2, long l) {
        OverrideMethod.invokeV("android.media.MediaCodec#releaseOutputBuffer(IZZJ)V", true, this);
    }

    public void signalEndOfInputStream() {
        OverrideMethod.invokeV("android.media.MediaCodec#signalEndOfInputStream()V", true, this);
    }

    public MediaFormat getOutputFormat() {
        return new MediaFormat(this.getFormatNative(false));
    }

    public MediaFormat getInputFormat() {
        return new MediaFormat(this.getFormatNative(true));
    }

    public MediaFormat getOutputFormat(int index) {
        return new MediaFormat(this.getOutputFormatNative(index));
    }

    private Map<String, Object> getFormatNative(boolean bl) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getFormatNative(Z)Ljava/util/Map;", true, this);
    }

    private Map<String, Object> getOutputFormatNative(int n) {
        return (Map)OverrideMethod.invokeA("android.media.MediaCodec#getOutputFormatNative(I)Ljava/util/Map;", true, this);
    }

    private void invalidateByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(false);
        }
    }

    private void validateInputByteBuffer(ByteBuffer[] buffers, int index) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateByteBuffer(ByteBuffer[] buffers, int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            ByteBuffer buffer;
            if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
                buffer.setAccessible(true);
            }
        }
    }

    private void validateOutputByteBuffer(ByteBuffer[] buffers, int index, BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            buffer.setAccessible(true);
            buffer.limit(info.offset + info.size).position(info.offset);
        }
    }

    private void invalidateByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.setAccessible(false);
            }
        }
    }

    private void freeByteBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            NioUtils_Delegate.freeDirectBuffer(buffer);
        }
    }

    private void freeByteBuffers(ByteBuffer[] buffers) {
        if (buffers != null) {
            for (ByteBuffer buffer : buffers) {
                this.freeByteBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeAllTrackedBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.freeByteBuffers(this.mCachedInputBuffers);
            this.freeByteBuffers(this.mCachedOutputBuffers);
            this.mCachedInputBuffers = null;
            this.mCachedOutputBuffers = null;
            this.mDequeuedInputBuffers.clear();
            this.mDequeuedOutputBuffers.clear();
            this.mQueueRequests.clear();
            this.mOutputFrames.clear();
        }
    }

    private void cacheBuffers(boolean input) {
        ByteBuffer[] buffers = null;
        try {
            buffers = this.getBuffers(input);
            this.invalidateByteBuffers(buffers);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (input) {
            this.mCachedInputBuffers = buffers;
        } else {
            this.mCachedOutputBuffers = buffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] getInputBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
            if (this.mCachedInputBuffers == null) {
                throw new IllegalStateException();
            }
            return this.mCachedInputBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] getOutputBuffers() {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputBuffers() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame to get output frames.");
            }
            if (this.mCachedOutputBuffers == null) {
                throw new IllegalStateException();
            }
            return this.mCachedOutputBuffers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getInputBuffer(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
        }
        ByteBuffer newBuffer = this.getBuffer(true, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getInputImage(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getInputImage() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please obtain MediaCodec.LinearBlock or HardwareBuffer objects and attach to QueueRequest objects.");
            }
        }
        Image newImage = this.getImage(true, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBuffer(this.mCachedInputBuffers, index);
            this.mDequeuedInputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getOutputBuffer(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputBuffer() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame() to get output frames.");
            }
        }
        ByteBuffer newBuffer = this.getBuffer(false, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getOutputImage(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode == 1) {
                throw new IncompatibleWithBlockModelException("getOutputImage() is not compatible with CONFIGURE_FLAG_USE_BLOCK_MODEL. Please use getOutputFrame() to get output frames.");
            }
        }
        Image newImage = this.getImage(false, index);
        Object object2 = this.mBufferLock;
        synchronized (object2) {
            this.invalidateByteBuffer(this.mCachedOutputBuffers, index);
            this.mDequeuedOutputBuffers.put(index, newImage);
        }
        return newImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputFrame getOutputFrame(int index) {
        Object object = this.mBufferLock;
        synchronized (object) {
            if (this.mBufferMode != 1) {
                throw new IllegalStateException("The codec is not configured for block model");
            }
            if (index < 0 || index >= this.mOutputFrames.size()) {
                throw new IndexOutOfBoundsException("Expected range of index: [0," + (this.mQueueRequests.size() - 1) + "]; actual: " + index);
            }
            OutputFrame frame = this.mOutputFrames.get(index);
            if (frame == null) {
                throw new IllegalArgumentException("Unavailable index: " + index);
            }
            if (!frame.isAccessible()) {
                throw new IllegalArgumentException("The output frame is stale at index " + index);
            }
            if (!frame.isLoaded()) {
                this.native_getOutputFrame(frame, index);
                frame.setLoaded(true);
            }
            return frame;
        }
    }

    private void native_getOutputFrame(OutputFrame outputFrame, int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_getOutputFrame(Landroid/media/MediaCodec$OutputFrame;I)V", true, this);
    }

    public void setVideoScalingMode(int n) {
        OverrideMethod.invokeV("android.media.MediaCodec#setVideoScalingMode(I)V", true, this);
    }

    public void setAudioPresentation(AudioPresentation presentation) {
        if (presentation == null) {
            throw new NullPointerException("audio presentation is null");
        }
        this.native_setAudioPresentation(presentation.getPresentationId(), presentation.getProgramId());
    }

    private void native_setAudioPresentation(int n, int n2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setAudioPresentation(II)V", true, this);
    }

    public String getName() {
        String canonicalName = this.getCanonicalName();
        return this.mNameAtCreation != null ? this.mNameAtCreation : canonicalName;
    }

    public String getCanonicalName() {
        return (String)OverrideMethod.invokeA("android.media.MediaCodec#getCanonicalName()Ljava/lang/String;", true, this);
    }

    public PersistableBundle getMetrics() {
        PersistableBundle bundle = this.native_getMetrics();
        return bundle;
    }

    private PersistableBundle native_getMetrics() {
        return (PersistableBundle)OverrideMethod.invokeA("android.media.MediaCodec#native_getMetrics()Landroid/os/PersistableBundle;", true, this);
    }

    public void setParameters(Bundle params) {
        if (params == null) {
            return;
        }
        String[] keys = new String[params.size()];
        Object[] values = new Object[params.size()];
        int i = 0;
        Iterator<String> iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            keys[i] = key = iterator.next();
            Object value = params.get(key);
            values[i] = value instanceof byte[] ? ByteBuffer.wrap((byte[])value) : value;
            ++i;
        }
        this.setParameters(keys, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback cb, Handler handler) {
        if (cb != null) {
            Object object = this.mListenerLock;
            synchronized (object) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mCallbackHandler);
                if (newHandler != this.mCallbackHandler) {
                    this.mCallbackHandler.removeMessages(2);
                    this.mCallbackHandler.removeMessages(1);
                    this.mCallbackHandler = newHandler;
                }
            }
        } else if (this.mCallbackHandler != null) {
            this.mCallbackHandler.removeMessages(2);
            this.mCallbackHandler.removeMessages(1);
        }
        if (this.mCallbackHandler != null) {
            Message msg = this.mCallbackHandler.obtainMessage(2, 0, 0, cb);
            this.mCallbackHandler.sendMessage(msg);
            this.native_setCallback(cb);
        }
    }

    public void setCallback(Callback cb) {
        this.setCallback(cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnFrameRenderedListener(OnFrameRenderedListener listener, Handler handler) {
        Object object = this.mListenerLock;
        synchronized (object) {
            this.mOnFrameRenderedListener = listener;
            if (listener != null) {
                EventHandler newHandler = this.getEventHandlerOn(handler, this.mOnFrameRenderedHandler);
                if (newHandler != this.mOnFrameRenderedHandler) {
                    this.mOnFrameRenderedHandler.removeMessages(3);
                }
                this.mOnFrameRenderedHandler = newHandler;
            } else if (this.mOnFrameRenderedHandler != null) {
                this.mOnFrameRenderedHandler.removeMessages(3);
            }
            this.native_enableOnFrameRenderedListener(listener != null);
        }
    }

    private void native_enableOnFrameRenderedListener(boolean bl) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_enableOnFrameRenderedListener(Z)V", true, this);
    }

    private EventHandler getEventHandlerOn(Handler handler, EventHandler lastHandler) {
        if (handler == null) {
            return this.mEventHandler;
        }
        Looper looper = handler.getLooper();
        if (lastHandler.getLooper() == looper) {
            return lastHandler;
        }
        return new EventHandler(this, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postEventFromNative(int what, int arg1, int arg2, Object obj) {
        Object object = this.mListenerLock;
        synchronized (object) {
            EventHandler handler = this.mEventHandler;
            if (what == 1) {
                handler = this.mCallbackHandler;
            } else if (what == 3) {
                handler = this.mOnFrameRenderedHandler;
            }
            if (handler != null) {
                Message msg = handler.obtainMessage(what, arg1, arg2, obj);
                handler.sendMessage(msg);
            }
        }
    }

    @UnsupportedAppUsage
    private void setParameters(String[] stringArray, Object[] objectArray) {
        OverrideMethod.invokeV("android.media.MediaCodec#setParameters([Ljava/lang/String;[Ljava/lang/Object;)V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaCodecInfo getCodecInfo() {
        String name = this.getName();
        Object object = this.mCodecInfoLock;
        synchronized (object) {
            if (this.mCodecInfo == null) {
                this.mCodecInfo = this.getOwnCodecInfo();
                if (this.mCodecInfo == null) {
                    this.mCodecInfo = MediaCodecList.getInfoFor(name);
                }
            }
            return this.mCodecInfo;
        }
    }

    private MediaCodecInfo getOwnCodecInfo() {
        return (MediaCodecInfo)OverrideMethod.invokeA("android.media.MediaCodec#getOwnCodecInfo()Landroid/media/MediaCodecInfo;", true, this);
    }

    @UnsupportedAppUsage
    private ByteBuffer[] getBuffers(boolean bl) {
        return (ByteBuffer[])OverrideMethod.invokeA("android.media.MediaCodec#getBuffers(Z)[Ljava/nio/ByteBuffer;", true, this);
    }

    private ByteBuffer getBuffer(boolean bl, int n) {
        return (ByteBuffer)OverrideMethod.invokeA("android.media.MediaCodec#getBuffer(ZI)Ljava/nio/ByteBuffer;", true, this);
    }

    private Image getImage(boolean bl, int n) {
        return (Image)OverrideMethod.invokeA("android.media.MediaCodec#getImage(ZI)Landroid/media/Image;", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_init()V", true, null);
    }

    private void native_setup(String string2, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.media.MediaCodec#native_setup(Ljava/lang/String;ZZ)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaCodec#native_finalize()V", true, this);
    }

    private long lockAndGetContext() {
        this.mNativeContextLock.lock();
        return this.mNativeContext;
    }

    private void setAndUnlockContext(long context) {
        this.mNativeContext = context;
        this.mNativeContextLock.unlock();
    }

    static {
        System_Delegate.loadLibrary("media_jni");
        MediaCodec.native_init();
    }

    public static class MetricsConstants {
        public static final String CODEC = "android.media.mediacodec.codec";
        public static final String MIME_TYPE = "android.media.mediacodec.mime";
        public static final String MODE = "android.media.mediacodec.mode";
        public static final String MODE_AUDIO = "audio";
        public static final String MODE_VIDEO = "video";
        public static final String ENCODER = "android.media.mediacodec.encoder";
        public static final String SECURE = "android.media.mediacodec.secure";
        public static final String WIDTH = "android.media.mediacodec.width";
        public static final String HEIGHT = "android.media.mediacodec.height";
        public static final String ROTATION = "android.media.mediacodec.rotation";

        private MetricsConstants() {
        }
    }

    public static class MediaImage
    extends Image {
        private final boolean mIsReadOnly;
        private final int mWidth;
        private final int mHeight;
        private final int mFormat;
        private long mTimestamp;
        private final Image.Plane[] mPlanes;
        private final ByteBuffer mBuffer;
        private final ByteBuffer mInfo;
        private final int mXOffset;
        private final int mYOffset;
        private final long mBufferContext;
        private static final int TYPE_YUV = 1;
        private final int mTransform = 0;
        private final int mScalingMode = 0;

        @Override
        public int getFormat() {
            this.throwISEIfImageIsInvalid();
            return this.mFormat;
        }

        @Override
        public int getHeight() {
            this.throwISEIfImageIsInvalid();
            return this.mHeight;
        }

        @Override
        public int getWidth() {
            this.throwISEIfImageIsInvalid();
            return this.mWidth;
        }

        @Override
        public int getTransform() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        @Override
        public int getScalingMode() {
            this.throwISEIfImageIsInvalid();
            return 0;
        }

        @Override
        public long getTimestamp() {
            this.throwISEIfImageIsInvalid();
            return this.mTimestamp;
        }

        @Override
        public Image.Plane[] getPlanes() {
            this.throwISEIfImageIsInvalid();
            return Arrays.copyOf(this.mPlanes, this.mPlanes.length);
        }

        @Override
        public void close() {
            if (this.mIsImageValid) {
                if (this.mBuffer != null) {
                    NioUtils_Delegate.freeDirectBuffer(this.mBuffer);
                }
                if (this.mBufferContext != 0L) {
                    MediaCodec.native_closeMediaImage(this.mBufferContext);
                }
                this.mIsImageValid = false;
            }
        }

        @Override
        public void setCropRect(Rect cropRect) {
            if (this.mIsReadOnly) {
                throw new ReadOnlyBufferException();
            }
            super.setCropRect(cropRect);
        }

        public MediaImage(ByteBuffer buffer, ByteBuffer info, boolean readOnly, long timestamp, int xOffset, int yOffset, Rect cropRect) {
            this.mFormat = 35;
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = buffer.isReadOnly();
            this.mBuffer = buffer.duplicate();
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            this.mInfo = info;
            this.mBufferContext = 0L;
            if (info.remaining() == 104) {
                int type = info.getInt();
                if (type != 1) {
                    throw new UnsupportedOperationException("unsupported type: " + type);
                }
                int numPlanes = info.getInt();
                if (numPlanes != 3) {
                    throw new RuntimeException("unexpected number of planes: " + numPlanes);
                }
                this.mWidth = info.getInt();
                this.mHeight = info.getInt();
                if (this.mWidth < 1 || this.mHeight < 1) {
                    throw new UnsupportedOperationException("unsupported size: " + this.mWidth + "x" + this.mHeight);
                }
                int bitDepth = info.getInt();
                if (bitDepth != 8) {
                    throw new UnsupportedOperationException("unsupported bit depth: " + bitDepth);
                }
                int bitDepthAllocated = info.getInt();
                if (bitDepthAllocated != 8) {
                    throw new UnsupportedOperationException("unsupported allocated bit depth: " + bitDepthAllocated);
                }
                this.mPlanes = new MediaPlane[numPlanes];
                for (int ix = 0; ix < numPlanes; ++ix) {
                    int vert;
                    int planeOffset = info.getInt();
                    int colInc = info.getInt();
                    int rowInc = info.getInt();
                    int horiz = info.getInt();
                    if (horiz != (vert = info.getInt()) || horiz != (ix == 0 ? 1 : 2)) {
                        throw new UnsupportedOperationException("unexpected subsampling: " + horiz + "x" + vert + " on plane " + ix);
                    }
                    if (colInc < 1 || rowInc < 1) {
                        throw new UnsupportedOperationException("unexpected strides: " + colInc + " pixel, " + rowInc + " row on plane " + ix);
                    }
                    buffer.clear();
                    buffer.position(this.mBuffer.position() + planeOffset + xOffset / horiz * colInc + yOffset / vert * rowInc);
                    buffer.limit(buffer.position() + Utils.divUp(bitDepth, 8) + (this.mHeight / vert - 1) * rowInc + (this.mWidth / horiz - 1) * colInc);
                    this.mPlanes[ix] = new MediaPlane(buffer.slice(), rowInc, colInc);
                }
            } else {
                throw new UnsupportedOperationException("unsupported info length: " + info.remaining());
            }
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
        }

        public MediaImage(ByteBuffer[] buffers, int[] rowStrides, int[] pixelStrides, int width, int height, int format, boolean readOnly, long timestamp, int xOffset, int yOffset, Rect cropRect, long context) {
            if (buffers.length != rowStrides.length || buffers.length != pixelStrides.length) {
                throw new IllegalArgumentException("buffers, rowStrides and pixelStrides should have the same length");
            }
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
            this.mTimestamp = timestamp;
            this.mIsImageValid = true;
            this.mIsReadOnly = readOnly;
            this.mBuffer = null;
            this.mInfo = null;
            this.mPlanes = new MediaPlane[buffers.length];
            for (int i = 0; i < buffers.length; ++i) {
                this.mPlanes[i] = new MediaPlane(buffers[i], rowStrides[i], pixelStrides[i]);
            }
            this.mXOffset = xOffset;
            this.mYOffset = yOffset;
            if (cropRect == null) {
                cropRect = new Rect(0, 0, this.mWidth, this.mHeight);
            }
            cropRect.offset(-xOffset, -yOffset);
            super.setCropRect(cropRect);
            this.mBufferContext = context;
        }

        private class MediaPlane
        extends Image.Plane {
            private final int mRowInc;
            private final int mColInc;
            private final ByteBuffer mData;

            public MediaPlane(ByteBuffer buffer, int rowInc, int colInc) {
                this.mData = buffer;
                this.mRowInc = rowInc;
                this.mColInc = colInc;
            }

            @Override
            public int getRowStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mRowInc;
            }

            @Override
            public int getPixelStride() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mColInc;
            }

            @Override
            public ByteBuffer getBuffer() {
                MediaImage.this.throwISEIfImageIsInvalid();
                return this.mData;
            }
        }
    }

    public static abstract class Callback {
        public abstract void onInputBufferAvailable(MediaCodec var1, int var2);

        public abstract void onOutputBufferAvailable(MediaCodec var1, int var2, BufferInfo var3);

        public abstract void onError(MediaCodec var1, CodecException var2);

        public abstract void onOutputFormatChanged(MediaCodec var1, MediaFormat var2);
    }

    public static interface OnFrameRenderedListener {
        public void onFrameRendered(MediaCodec var1, long var2, long var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoScalingMode {
    }

    public static class OutputFrame {
        private final int mIndex;
        private LinearBlock mLinearBlock = null;
        private HardwareBuffer mHardwareBuffer = null;
        private long mPresentationTimeUs = 0L;
        private int mFlags = 0;
        private MediaFormat mFormat = null;
        private final ArrayList<String> mChangedKeys = new ArrayList();
        private final Set<String> mKeySet = new HashSet<String>();
        private boolean mAccessible = false;
        private boolean mLoaded = false;

        OutputFrame(int index) {
            this.mIndex = index;
        }

        public LinearBlock getLinearBlock() {
            if (this.mHardwareBuffer != null) {
                throw new IllegalStateException("This output frame is not linear");
            }
            return this.mLinearBlock;
        }

        public HardwareBuffer getHardwareBuffer() {
            if (this.mLinearBlock != null) {
                throw new IllegalStateException("This output frame is not graphic");
            }
            return this.mHardwareBuffer;
        }

        public long getPresentationTimeUs() {
            return this.mPresentationTimeUs;
        }

        public int getFlags() {
            return this.mFlags;
        }

        public MediaFormat getFormat() {
            return this.mFormat;
        }

        public Set<String> getChangedKeys() {
            if (this.mKeySet.isEmpty() && !this.mChangedKeys.isEmpty()) {
                this.mKeySet.addAll(this.mChangedKeys);
            }
            return Collections.unmodifiableSet(this.mKeySet);
        }

        void clear() {
            this.mLinearBlock = null;
            this.mHardwareBuffer = null;
            this.mFormat = null;
            this.mChangedKeys.clear();
            this.mKeySet.clear();
            this.mLoaded = false;
        }

        boolean isAccessible() {
            return this.mAccessible;
        }

        void setAccessible(boolean accessible) {
            this.mAccessible = accessible;
        }

        void setBufferInfo(BufferInfo info) {
            this.mPresentationTimeUs = info.presentationTimeUs;
            this.mFlags = info.flags;
        }

        boolean isLoaded() {
            return this.mLoaded;
        }

        void setLoaded(boolean loaded) {
            this.mLoaded = loaded;
        }
    }

    private static class BufferMap {
        private final Map<Integer, CodecBuffer> mMap = new HashMap<Integer, CodecBuffer>();

        private BufferMap() {
        }

        public void remove(int index) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer != null) {
                buffer.free();
                this.mMap.remove(index);
            }
        }

        public void put(int index, ByteBuffer newBuffer) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setByteBuffer(newBuffer);
        }

        public void put(int index, Image newImage) {
            CodecBuffer buffer = this.mMap.get(index);
            if (buffer == null) {
                buffer = new CodecBuffer();
                this.mMap.put(index, buffer);
            }
            buffer.setImage(newImage);
        }

        public void clear() {
            for (CodecBuffer buffer : this.mMap.values()) {
                buffer.free();
            }
            this.mMap.clear();
        }

        private static class CodecBuffer {
            private Image mImage;
            private ByteBuffer mByteBuffer;

            private CodecBuffer() {
            }

            public void free() {
                if (this.mByteBuffer != null) {
                    NioUtils_Delegate.freeDirectBuffer(this.mByteBuffer);
                    this.mByteBuffer = null;
                }
                if (this.mImage != null) {
                    this.mImage.close();
                    this.mImage = null;
                }
            }

            public void setImage(Image image) {
                this.free();
                this.mImage = image;
            }

            public void setByteBuffer(ByteBuffer buffer) {
                this.free();
                this.mByteBuffer = buffer;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OutputBufferInfo {
    }

    public class QueueRequest {
        private final MediaCodec mCodec;
        private final int mIndex;
        private LinearBlock mLinearBlock = null;
        private int mOffset = 0;
        private int mSize = 0;
        private CryptoInfo mCryptoInfo = null;
        private HardwareBuffer mHardwareBuffer = null;
        private long mPresentationTimeUs = 0L;
        private int mFlags = 0;
        private final ArrayList<String> mTuningKeys = new ArrayList();
        private final ArrayList<Object> mTuningValues = new ArrayList();
        private boolean mAccessible = false;

        private QueueRequest(MediaCodec codec, int index) {
            this.mCodec = codec;
            this.mIndex = index;
        }

        public QueueRequest setLinearBlock(LinearBlock block, int offset, int size) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mOffset = offset;
            this.mSize = size;
            this.mCryptoInfo = null;
            return this;
        }

        public QueueRequest setEncryptedLinearBlock(LinearBlock block, int offset, int size, CryptoInfo cryptoInfo) {
            Objects.requireNonNull(cryptoInfo);
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mLinearBlock = block;
            this.mOffset = offset;
            this.mSize = size;
            this.mCryptoInfo = cryptoInfo;
            return this;
        }

        public QueueRequest setHardwareBuffer(HardwareBuffer buffer) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock != null || this.mHardwareBuffer != null) {
                throw new IllegalStateException("Cannot set block twice");
            }
            this.mHardwareBuffer = buffer;
            return this;
        }

        public QueueRequest setPresentationTimeUs(long presentationTimeUs) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mPresentationTimeUs = presentationTimeUs;
            return this;
        }

        public QueueRequest setFlags(int flags) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mFlags = flags;
            return this;
        }

        public QueueRequest setIntegerParameter(String key, int value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        public QueueRequest setLongParameter(String key, long value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        public QueueRequest setFloatParameter(String key, float value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(Float.valueOf(value));
            return this;
        }

        public QueueRequest setByteBufferParameter(String key, ByteBuffer value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        public QueueRequest setStringParameter(String key, String value) {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            this.mTuningKeys.add(key);
            this.mTuningValues.add(value);
            return this;
        }

        public void queue() {
            if (!this.isAccessible()) {
                throw new IllegalStateException("The request is stale");
            }
            if (this.mLinearBlock == null && this.mHardwareBuffer == null) {
                throw new IllegalStateException("No block is set");
            }
            this.setAccessible(false);
            if (this.mLinearBlock != null) {
                this.mCodec.native_queueLinearBlock(this.mIndex, this.mLinearBlock, this.mOffset, this.mSize, this.mCryptoInfo, this.mPresentationTimeUs, this.mFlags, this.mTuningKeys, this.mTuningValues);
            } else if (this.mHardwareBuffer != null) {
                this.mCodec.native_queueHardwareBuffer(this.mIndex, this.mHardwareBuffer, this.mPresentationTimeUs, this.mFlags, this.mTuningKeys, this.mTuningValues);
            }
            this.clear();
        }

        QueueRequest clear() {
            this.mLinearBlock = null;
            this.mOffset = 0;
            this.mSize = 0;
            this.mCryptoInfo = null;
            this.mHardwareBuffer = null;
            this.mPresentationTimeUs = 0L;
            this.mFlags = 0;
            this.mTuningKeys.clear();
            this.mTuningValues.clear();
            return this;
        }

        boolean isAccessible() {
            return this.mAccessible;
        }

        QueueRequest setAccessible(boolean accessible) {
            this.mAccessible = accessible;
            return this;
        }
    }

    public static class LinearBlock {
        private static final BlockingQueue<LinearBlock> sPool = new LinkedBlockingQueue<LinearBlock>();
        private final Object mLock = new Object();
        private boolean mValid = false;
        private boolean mMappable = false;
        private ByteBuffer mMapped = null;
        private long mNativeContext = 0L;

        private LinearBlock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isMappable() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                return this.mMappable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer map() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                if (!this.mMappable) {
                    throw new IllegalStateException("The linear block is not mappable");
                }
                if (this.mMapped == null) {
                    this.mMapped = this.native_map();
                }
                return this.mMapped;
            }
        }

        private ByteBuffer native_map() {
            return (ByteBuffer)OverrideMethod.invokeA("android.media.MediaCodec$LinearBlock#native_map()Ljava/nio/ByteBuffer;", true, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recycle() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mValid) {
                    throw new IllegalStateException("The linear block is invalid");
                }
                if (this.mMapped != null) {
                    this.mMapped.setAccessible(false);
                    this.mMapped = null;
                }
                this.native_recycle();
                this.mValid = false;
                this.mNativeContext = 0L;
            }
            sPool.offer(this);
        }

        private void native_recycle() {
            OverrideMethod.invokeV("android.media.MediaCodec$LinearBlock#native_recycle()V", true, this);
        }

        private void native_obtain(int n, String[] stringArray) {
            OverrideMethod.invokeV("android.media.MediaCodec$LinearBlock#native_obtain(I[Ljava/lang/String;)V", true, this);
        }

        protected void finalize() {
            this.native_recycle();
        }

        public static boolean isCodecCopyFreeCompatible(String[] codecNames) {
            return LinearBlock.native_checkCompatible(codecNames);
        }

        private static boolean native_checkCompatible(String[] stringArray) {
            return OverrideMethod.invokeI("android.media.MediaCodec$LinearBlock#native_checkCompatible([Ljava/lang/String;)Z", true, null) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static LinearBlock obtain(int capacity, String[] codecNames) {
            LinearBlock buffer = (LinearBlock)sPool.poll();
            if (buffer == null) {
                buffer = new LinearBlock();
            }
            Object object = buffer.mLock;
            synchronized (object) {
                buffer.native_obtain(capacity, codecNames);
            }
            return buffer;
        }

        private void setInternalStateLocked(long context, boolean isMappable) {
            this.mNativeContext = context;
            this.mMappable = isMappable;
            this.mValid = context != 0L;
        }
    }

    public static class CryptoInfo {
        public int numSubSamples;
        public int[] numBytesOfClearData;
        public int[] numBytesOfEncryptedData;
        public byte[] key;
        public byte[] iv;
        public int mode;
        private final Pattern zeroPattern = new Pattern(0, 0);
        private Pattern pattern;

        public void set(int newNumSubSamples, int[] newNumBytesOfClearData, int[] newNumBytesOfEncryptedData, byte[] newKey, byte[] newIV, int newMode) {
            this.numSubSamples = newNumSubSamples;
            this.numBytesOfClearData = newNumBytesOfClearData;
            this.numBytesOfEncryptedData = newNumBytesOfEncryptedData;
            this.key = newKey;
            this.iv = newIV;
            this.mode = newMode;
            this.pattern = this.zeroPattern;
        }

        public void setPattern(Pattern newPattern) {
            if (newPattern == null) {
                newPattern = this.zeroPattern;
            }
            this.pattern = newPattern;
        }

        private void setPattern(int blocksToEncrypt, int blocksToSkip) {
            this.pattern = new Pattern(blocksToEncrypt, blocksToSkip);
        }

        public String toString() {
            int i;
            StringBuilder builder = new StringBuilder();
            builder.append(this.numSubSamples + " subsamples, key [");
            String hexdigits = "0123456789abcdef";
            for (i = 0; i < this.key.length; ++i) {
                builder.append(hexdigits.charAt((this.key[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.key[i] & 0xF));
            }
            builder.append("], iv [");
            for (i = 0; i < this.iv.length; ++i) {
                builder.append(hexdigits.charAt((this.iv[i] & 0xF0) >> 4));
                builder.append(hexdigits.charAt(this.iv[i] & 0xF));
            }
            builder.append("], clear ");
            builder.append(Arrays.toString(this.numBytesOfClearData));
            builder.append(", encrypted ");
            builder.append(Arrays.toString(this.numBytesOfEncryptedData));
            builder.append(", pattern (encrypt: ");
            builder.append(this.pattern.mEncryptBlocks);
            builder.append(", skip: ");
            builder.append(this.pattern.mSkipBlocks);
            builder.append(")");
            return builder.toString();
        }

        public static class Pattern {
            private int mEncryptBlocks;
            private int mSkipBlocks;

            public Pattern(int blocksToEncrypt, int blocksToSkip) {
                this.set(blocksToEncrypt, blocksToSkip);
            }

            public void set(int blocksToEncrypt, int blocksToSkip) {
                this.mEncryptBlocks = blocksToEncrypt;
                this.mSkipBlocks = blocksToSkip;
            }

            public int getSkipBlocks() {
                return this.mSkipBlocks;
            }

            public int getEncryptBlocks() {
                return this.mEncryptBlocks;
            }
        }
    }

    public static class CryptoException
    extends RuntimeException {
        public static final int ERROR_NO_KEY = 1;
        public static final int ERROR_KEY_EXPIRED = 2;
        public static final int ERROR_RESOURCE_BUSY = 3;
        public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4;
        public static final int ERROR_SESSION_NOT_OPENED = 5;
        public static final int ERROR_UNSUPPORTED_OPERATION = 6;
        public static final int ERROR_INSUFFICIENT_SECURITY = 7;
        public static final int ERROR_FRAME_TOO_LARGE = 8;
        public static final int ERROR_LOST_STATE = 9;
        private int mErrorCode;

        public CryptoException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface CryptoErrorCode {
        }
    }

    public static class CodecException
    extends IllegalStateException {
        public static final int ERROR_INSUFFICIENT_RESOURCE = 1100;
        public static final int ERROR_RECLAIMED = 1101;
        private static final int ACTION_TRANSIENT = 1;
        private static final int ACTION_RECOVERABLE = 2;
        private final String mDiagnosticInfo;
        private final int mErrorCode;
        private final int mActionCode;

        @UnsupportedAppUsage
        CodecException(int errorCode, int actionCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            this.mActionCode = actionCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaCodec.error_" + sign + Math.abs(errorCode);
        }

        public boolean isTransient() {
            return this.mActionCode == 1;
        }

        public boolean isRecoverable() {
            return this.mActionCode == 2;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ReasonCode {
        }
    }

    static class PersistentSurface
    extends Surface {
        private long mPersistentObject;

        PersistentSurface() {
        }

        @Override
        public void release() {
            MediaCodec.native_releasePersistentInputSurface(this);
            super.release();
        }
    }

    public class IncompatibleWithBlockModelException
    extends RuntimeException {
        IncompatibleWithBlockModelException() {
        }

        IncompatibleWithBlockModelException(String message) {
            super(message);
        }

        IncompatibleWithBlockModelException(String message, Throwable cause) {
            super(message, cause);
        }

        IncompatibleWithBlockModelException(Throwable cause) {
            super(cause);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigureFlag {
    }

    private class EventHandler
    extends Handler {
        private MediaCodec mCodec;

        public EventHandler(MediaCodec codec, Looper looper) {
            super(looper);
            this.mCodec = codec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            block2 : switch (msg.what) {
                case 1: {
                    this.handleCallback(msg);
                    break;
                }
                case 2: {
                    MediaCodec.this.mCallback = (Callback)msg.obj;
                    break;
                }
                case 3: {
                    Map map = (Map)msg.obj;
                    int i = 0;
                    while (true) {
                        OnFrameRenderedListener onFrameRenderedListener;
                        Object mediaTimeUs = map.get(i + "-media-time-us");
                        Object systemNano = map.get(i + "-system-nano");
                        Object object = MediaCodec.this.mListenerLock;
                        synchronized (object) {
                            onFrameRenderedListener = MediaCodec.this.mOnFrameRenderedListener;
                        }
                        if (mediaTimeUs == null || systemNano == null || onFrameRenderedListener == null) break block2;
                        onFrameRenderedListener.onFrameRendered(this.mCodec, (Long)mediaTimeUs, (Long)systemNano);
                        ++i;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCallback(Message msg) {
            if (MediaCodec.this.mCallback == null) {
                return;
            }
            switch (msg.arg1) {
                case 1: {
                    int index = msg.arg2;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        switch (MediaCodec.this.mBufferMode) {
                            case 0: {
                                MediaCodec.this.validateInputByteBuffer(MediaCodec.this.mCachedInputBuffers, index);
                                break;
                            }
                            case 1: {
                                while (MediaCodec.this.mQueueRequests.size() <= index) {
                                    MediaCodec.this.mQueueRequests.add(null);
                                }
                                QueueRequest request = (QueueRequest)MediaCodec.this.mQueueRequests.get(index);
                                if (request == null) {
                                    request = new QueueRequest(this.mCodec, index);
                                    MediaCodec.this.mQueueRequests.set(index, request);
                                }
                                request.setAccessible(true);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized buffer mode: " + MediaCodec.this.mBufferMode);
                            }
                        }
                    }
                    MediaCodec.this.mCallback.onInputBufferAvailable(this.mCodec, index);
                    break;
                }
                case 2: {
                    int index = msg.arg2;
                    BufferInfo info = (BufferInfo)msg.obj;
                    Object object = MediaCodec.this.mBufferLock;
                    synchronized (object) {
                        switch (MediaCodec.this.mBufferMode) {
                            case 0: {
                                MediaCodec.this.validateOutputByteBuffer(MediaCodec.this.mCachedOutputBuffers, index, info);
                                break;
                            }
                            case 1: {
                                while (MediaCodec.this.mOutputFrames.size() <= index) {
                                    MediaCodec.this.mOutputFrames.add(null);
                                }
                                OutputFrame frame = (OutputFrame)MediaCodec.this.mOutputFrames.get(index);
                                if (frame == null) {
                                    frame = new OutputFrame(index);
                                    MediaCodec.this.mOutputFrames.set(index, frame);
                                }
                                frame.setBufferInfo(info);
                                frame.setAccessible(true);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unrecognized buffer mode: " + MediaCodec.this.mBufferMode);
                            }
                        }
                    }
                    MediaCodec.this.mCallback.onOutputBufferAvailable(this.mCodec, index, info);
                    break;
                }
                case 3: {
                    MediaCodec.this.mCallback.onError(this.mCodec, (CodecException)msg.obj);
                    break;
                }
                case 4: {
                    MediaCodec.this.mCallback.onOutputFormatChanged(this.mCodec, new MediaFormat((Map)msg.obj));
                    break;
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferFlag {
    }

    public static class BufferInfo {
        public int offset;
        public int size;
        public long presentationTimeUs;
        public int flags;

        public void set(int newOffset, int newSize, long newTimeUs, int newFlags) {
            this.offset = newOffset;
            this.size = newSize;
            this.presentationTimeUs = newTimeUs;
            this.flags = newFlags;
        }

        public BufferInfo dup() {
            BufferInfo copy = new BufferInfo();
            copy.set(this.offset, this.size, this.presentationTimeUs, this.flags);
            return copy;
        }
    }
}

