/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class GsmSignalStrength {
    public int signalStrength = 0;
    public int bitErrorRate = 0;
    public int timingAdvance = 0;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != GsmSignalStrength.class) {
            return false;
        }
        GsmSignalStrength other = (GsmSignalStrength)otherObject;
        if (this.signalStrength != other.signalStrength) {
            return false;
        }
        if (this.bitErrorRate != other.bitErrorRate) {
            return false;
        }
        return this.timingAdvance == other.timingAdvance;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.signalStrength), HidlSupport.deepHashCode(this.bitErrorRate), HidlSupport.deepHashCode(this.timingAdvance));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".signalStrength = ");
        builder.append(this.signalStrength);
        builder.append(", .bitErrorRate = ");
        builder.append(this.bitErrorRate);
        builder.append(", .timingAdvance = ");
        builder.append(this.timingAdvance);
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(12L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<GsmSignalStrength> readVectorFromParcel(HwParcel parcel) {
        ArrayList<GsmSignalStrength> _hidl_vec = new ArrayList<GsmSignalStrength>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 12, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            GsmSignalStrength _hidl_vec_element = new GsmSignalStrength();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 12);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.signalStrength = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.bitErrorRate = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.timingAdvance = _hidl_blob.getInt32(_hidl_offset + 8L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(12);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<GsmSignalStrength> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 12);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 12);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.signalStrength);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.bitErrorRate);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.timingAdvance);
    }
}

