/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TotalCaptureResult
extends CaptureResult {
    private final List<CaptureResult> mPartialResults;
    private final int mSessionId;
    private final HashMap<String, CaptureResult> mPhysicalCaptureResults;

    public TotalCaptureResult(CameraMetadataNative results, CaptureRequest parent, CaptureResultExtras extras, List<CaptureResult> partials, int sessionId, PhysicalCaptureResultInfo[] physicalResults) {
        super(results, parent, extras);
        this.mPartialResults = partials == null ? new ArrayList<CaptureResult>() : partials;
        this.mSessionId = sessionId;
        this.mPhysicalCaptureResults = new HashMap();
        for (PhysicalCaptureResultInfo onePhysicalResult : physicalResults) {
            CaptureResult physicalResult = new CaptureResult(onePhysicalResult.getCameraMetadata(), parent, extras);
            this.mPhysicalCaptureResults.put(onePhysicalResult.getCameraId(), physicalResult);
        }
    }

    public TotalCaptureResult(CameraMetadataNative results, int sequenceId) {
        super(results, sequenceId);
        this.mPartialResults = new ArrayList<CaptureResult>();
        this.mSessionId = -1;
        this.mPhysicalCaptureResults = new HashMap();
    }

    public List<CaptureResult> getPartialResults() {
        return Collections.unmodifiableList(this.mPartialResults);
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public Map<String, CaptureResult> getPhysicalCameraResults() {
        return Collections.unmodifiableMap(this.mPhysicalCaptureResults);
    }
}

