/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.text.MeasuredText;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public class LineBreaker {
    public static int BREAK_STRATEGY_SIMPLE = 0;
    public static int BREAK_STRATEGY_HIGH_QUALITY = 1;
    public static int BREAK_STRATEGY_BALANCED = 2;
    public static int HYPHENATION_FREQUENCY_NONE = 0;
    public static int HYPHENATION_FREQUENCY_NORMAL = 1;
    public static int HYPHENATION_FREQUENCY_FULL = 2;
    public static int JUSTIFICATION_MODE_NONE = 0;
    public static int JUSTIFICATION_MODE_INTER_WORD = 1;
    private static NativeAllocationRegistry sRegistry;
    private final long mNativePtr;

    private LineBreaker(int breakStrategy, int hyphenationFrequency, int justify, int[] indents) {
        this.mNativePtr = LineBreaker.nInit(breakStrategy, hyphenationFrequency, justify == 1, indents);
        sRegistry.registerNativeAllocation(this, this.mNativePtr);
    }

    public Result computeLineBreaks(MeasuredText measuredPara, ParagraphConstraints constraints, int lineNumber) {
        return new Result(LineBreaker.nComputeLineBreaks(this.mNativePtr, measuredPara.getChars(), measuredPara.getNativePtr(), measuredPara.getChars().length, constraints.mFirstWidth, constraints.mFirstWidthLineCount, constraints.mWidth, constraints.mVariableTabStops, constraints.mDefaultTabStop, lineNumber));
    }

    @FastNative
    private static native long nInit(int var0, int var1, boolean var2, int[] var3);

    @CriticalNative
    private static native long nGetReleaseFunc();

    private static native long nComputeLineBreaks(long var0, char[] var2, long var3, int var5, float var6, int var7, float var8, float[] var9, float var10, int var11);

    @CriticalNative
    private static native int nGetLineCount(long var0);

    @CriticalNative
    private static native int nGetLineBreakOffset(long var0, int var2);

    @CriticalNative
    private static native float nGetLineWidth(long var0, int var2);

    @CriticalNative
    private static native float nGetLineAscent(long var0, int var2);

    @CriticalNative
    private static native float nGetLineDescent(long var0, int var2);

    @CriticalNative
    private static native int nGetLineFlag(long var0, int var2);

    @CriticalNative
    private static native long nGetReleaseResultFunc();

    static /* synthetic */ long access$100() {
        return LineBreaker.nGetReleaseResultFunc();
    }

    public static void deferredStaticInitializer() {
        sRegistry = NativeAllocationRegistry.createMalloced(LineBreaker.class.getClassLoader(), LineBreaker.nGetReleaseFunc());
    }

    public static class Result {
        private static final int TAB_MASK = 0x20000000;
        private static final int HYPHEN_MASK = 255;
        private static final int START_HYPHEN_MASK = 24;
        private static final int END_HYPHEN_MASK = 7;
        private static final int START_HYPHEN_BITS_SHIFT = 3;
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(Result.class.getClassLoader(), LineBreaker.access$100());
        private final long mPtr;

        private Result(long ptr) {
            this.mPtr = ptr;
            sRegistry.registerNativeAllocation(this, this.mPtr);
        }

        public int getLineCount() {
            return LineBreaker.nGetLineCount(this.mPtr);
        }

        public int getLineBreakOffset(int lineIndex) {
            return LineBreaker.nGetLineBreakOffset(this.mPtr, lineIndex);
        }

        public float getLineWidth(int lineIndex) {
            return LineBreaker.nGetLineWidth(this.mPtr, lineIndex);
        }

        public float getLineAscent(int lineIndex) {
            return LineBreaker.nGetLineAscent(this.mPtr, lineIndex);
        }

        public float getLineDescent(int lineIndex) {
            return LineBreaker.nGetLineDescent(this.mPtr, lineIndex);
        }

        public boolean hasLineTab(int lineIndex) {
            return (LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 0x20000000) != 0;
        }

        public int getStartLineHyphenEdit(int lineIndex) {
            return (LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 0x18) >> 3;
        }

        public int getEndLineHyphenEdit(int lineIndex) {
            return LineBreaker.nGetLineFlag(this.mPtr, lineIndex) & 7;
        }
    }

    public static class ParagraphConstraints {
        private float mWidth = 0.0f;
        private float mFirstWidth = 0.0f;
        private int mFirstWidthLineCount = 0;
        private float[] mVariableTabStops = null;
        private float mDefaultTabStop = 0.0f;

        public void setWidth(float width) {
            this.mWidth = width;
        }

        public void setIndent(float firstWidth, int firstWidthLineCount) {
            this.mFirstWidth = firstWidth;
            this.mFirstWidthLineCount = firstWidthLineCount;
        }

        public void setTabStops(float[] tabStops, float defaultTabStop) {
            this.mVariableTabStops = tabStops;
            this.mDefaultTabStop = defaultTabStop;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getFirstWidth() {
            return this.mFirstWidth;
        }

        public int getFirstWidthLineCount() {
            return this.mFirstWidthLineCount;
        }

        public float[] getTabStops() {
            return this.mVariableTabStops;
        }

        public float getDefaultTabStop() {
            return this.mDefaultTabStop;
        }
    }

    public static class Builder {
        private int mBreakStrategy = 0;
        private int mHyphenationFrequency = 0;
        private int mJustificationMode = 0;
        private int[] mIndents = null;

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        public Builder setIndents(int[] indents) {
            this.mIndents = indents;
            return this;
        }

        public LineBreaker build() {
            return new LineBreaker(this.mBreakStrategy, this.mHyphenationFrequency, this.mJustificationMode, this.mIndents);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JustificationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HyphenationFrequency {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BreakStrategy {
    }
}

