/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.CanvasProperty;
import android.graphics.Paint;
import android.graphics.RenderNode;
import android.util.Pools;
import android.view.DisplayListCanvas;
import android.view.TextureLayer;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;

public final class RecordingCanvas
extends DisplayListCanvas {
    private static final int POOL_LIMIT = 25;
    public static final int MAX_BITMAP_SIZE = 0x6400000;
    private static final Pools.SynchronizedPool<RecordingCanvas> sPool = new Pools.SynchronizedPool(25);
    public RenderNode mNode;
    private int mWidth;
    private int mHeight;

    static RecordingCanvas obtain(RenderNode node, int width, int height) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        RecordingCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new RecordingCanvas(node, width, height);
        } else {
            RecordingCanvas.nResetDisplayListCanvas(canvas.mNativeCanvasWrapper, node.mNativeRenderNode, width, height);
        }
        canvas.mNode = node;
        canvas.mWidth = width;
        canvas.mHeight = height;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return RecordingCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    protected RecordingCanvas(RenderNode node, int width, int height) {
        super(RecordingCanvas.nCreateDisplayListCanvas(node.mNativeRenderNode, width, height));
        this.mDensity = 0;
    }

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return RecordingCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return RecordingCanvas.nGetMaximumTextureHeight();
    }

    @Override
    public void enableZ() {
        RecordingCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void disableZ() {
        RecordingCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    @Deprecated
    public void callDrawGLFunction2(long drawGLFunction) {
        RecordingCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction, null);
    }

    @Deprecated
    public void drawGLFunctor2(long drawGLFunctor, Runnable releasedCallback) {
        RecordingCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunctor, releasedCallback);
    }

    public void drawWebViewFunctor(int functor) {
        RecordingCanvas.nDrawWebViewFunctor(this.mNativeCanvasWrapper, functor);
    }

    @Override
    public void drawRenderNode(RenderNode renderNode) {
        RecordingCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.mNativeRenderNode);
    }

    public void drawTextureLayer(TextureLayer layer) {
        RecordingCanvas.nDrawTextureLayer(this.mNativeCanvasWrapper, layer.getLayerHandle());
    }

    @Override
    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        RecordingCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    @Override
    protected void throwIfCannotDraw(Bitmap bitmap) {
        super.throwIfCannotDraw(bitmap);
        int bitmapSize = bitmap.getByteCount();
        if (bitmapSize > 0x6400000) {
            throw new RuntimeException("Canvas: trying to draw too large(" + bitmapSize + "bytes) bitmap.");
        }
    }

    @FastNative
    private static native void nCallDrawGLFunction(long var0, long var2, Runnable var4);

    @CriticalNative
    private static native long nCreateDisplayListCanvas(long var0, int var2, int var3);

    @CriticalNative
    private static native void nResetDisplayListCanvas(long var0, long var2, int var4, int var5);

    @CriticalNative
    private static native int nGetMaximumTextureWidth();

    @CriticalNative
    private static native int nGetMaximumTextureHeight();

    @CriticalNative
    private static native void nInsertReorderBarrier(long var0, boolean var2);

    @CriticalNative
    private static native long nFinishRecording(long var0);

    @CriticalNative
    private static native void nDrawRenderNode(long var0, long var2);

    @CriticalNative
    private static native void nDrawTextureLayer(long var0, long var2);

    @CriticalNative
    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    @CriticalNative
    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @CriticalNative
    private static native void nDrawWebViewFunctor(long var0, int var2);
}

