/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.ComponentName;
import android.content.pm.PathPermission;
import android.content.pm.parsing.ParsingPackageImpl;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.text.TextUtils;

public class ParsedProvider
extends ParsedMainComponent {
    private String authority;
    boolean syncable;
    private String readPermission;
    private String writePermission;
    boolean grantUriPermissions;
    boolean forceUriPermissions;
    boolean multiProcess;
    int initOrder;
    PatternMatcher[] uriPermissionPatterns;
    PathPermission[] pathPermissions;
    public static final Parcelable.Creator<ParsedProvider> CREATOR = new Parcelable.Creator<ParsedProvider>(){

        @Override
        public ParsedProvider createFromParcel(Parcel source) {
            return new ParsedProvider(source);
        }

        public ParsedProvider[] newArray(int size) {
            return new ParsedProvider[size];
        }
    };

    public ParsedProvider(ParsedProvider other) {
        super(other);
        this.authority = other.authority;
        this.syncable = other.syncable;
        this.readPermission = other.readPermission;
        this.writePermission = other.writePermission;
        this.grantUriPermissions = other.grantUriPermissions;
        this.forceUriPermissions = other.forceUriPermissions;
        this.multiProcess = other.multiProcess;
        this.initOrder = other.initOrder;
        this.uriPermissionPatterns = other.uriPermissionPatterns;
        this.pathPermissions = other.pathPermissions;
    }

    public void setAuthority(String authority) {
        this.authority = TextUtils.safeIntern(authority);
    }

    public void setSyncable(boolean syncable) {
        this.syncable = syncable;
    }

    public void setReadPermission(String readPermission) {
        this.readPermission = TextUtils.isEmpty(readPermission) ? null : readPermission.intern();
    }

    public void setWritePermission(String writePermission) {
        this.writePermission = TextUtils.isEmpty(writePermission) ? null : writePermission.intern();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Provider{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.authority);
        dest.writeBoolean(this.syncable);
        ParsingPackageImpl.sForInternedString.parcel(this.readPermission, dest, flags);
        ParsingPackageImpl.sForInternedString.parcel(this.writePermission, dest, flags);
        dest.writeBoolean(this.grantUriPermissions);
        dest.writeBoolean(this.forceUriPermissions);
        dest.writeBoolean(this.multiProcess);
        dest.writeInt(this.initOrder);
        dest.writeTypedArray(this.uriPermissionPatterns, flags);
        dest.writeTypedArray(this.pathPermissions, flags);
    }

    public ParsedProvider() {
    }

    protected ParsedProvider(Parcel in) {
        super(in);
        this.authority = in.readString();
        this.syncable = in.readBoolean();
        this.readPermission = ParsingPackageImpl.sForInternedString.unparcel(in);
        this.writePermission = ParsingPackageImpl.sForInternedString.unparcel(in);
        this.grantUriPermissions = in.readBoolean();
        this.forceUriPermissions = in.readBoolean();
        this.multiProcess = in.readBoolean();
        this.initOrder = in.readInt();
        this.uriPermissionPatterns = in.createTypedArray(PatternMatcher.CREATOR);
        this.pathPermissions = in.createTypedArray(PathPermission.CREATOR);
    }

    public String getAuthority() {
        return this.authority;
    }

    public boolean isSyncable() {
        return this.syncable;
    }

    public String getReadPermission() {
        return this.readPermission;
    }

    public String getWritePermission() {
        return this.writePermission;
    }

    public boolean isGrantUriPermissions() {
        return this.grantUriPermissions;
    }

    public boolean isForceUriPermissions() {
        return this.forceUriPermissions;
    }

    public boolean isMultiProcess() {
        return this.multiProcess;
    }

    public int getInitOrder() {
        return this.initOrder;
    }

    public PatternMatcher[] getUriPermissionPatterns() {
        return this.uriPermissionPatterns;
    }

    public PathPermission[] getPathPermissions() {
        return this.pathPermissions;
    }
}

