/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ComponentParseUtils;
import android.content.pm.parsing.component.ParsedProcess;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.R;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedProcessUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<Set<String>> parseDenyPermission(Set<String> perms, Resources res, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestDenyPermission);
        try {
            String perm = sa.getNonConfigurationString(0, 0);
            if (perm != null && perm.equals("android.permission.INTERNET")) {
                perms = CollectionUtils.add(perms, perm);
            }
        }
        finally {
            sa.recycle();
        }
        XmlUtils.skipCurrentTag(parser);
        return input.success(perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<Set<String>> parseAllowPermission(Set<String> perms, Resources res, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestAllowPermission);
        try {
            String perm = sa.getNonConfigurationString(0, 0);
            if (perm != null && perm.equals("android.permission.INTERNET")) {
                perms = CollectionUtils.remove(perms, perm);
            }
        }
        finally {
            sa.recycle();
        }
        XmlUtils.skipCurrentTag(parser);
        return input.success(perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsedProcess> parseProcess(Set<String> perms, String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, ParseInput input) throws IOException, XmlPullParserException {
        int type;
        ParsedProcess proc = new ParsedProcess();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProcess);
        try {
            if (perms != null) {
                proc.deniedPermissions = new ArraySet<String>(perms);
            }
            proc.name = sa.getNonConfigurationString(0, 0);
            ParseResult<String> processNameResult = ComponentParseUtils.buildProcessName(pkg.getPackageName(), pkg.getPackageName(), proc.name, flags, separateProcesses, input);
            if (processNameResult.isError()) {
                ParseResult<ParsedProcess> parseResult = input.error(processNameResult);
                return parseResult;
            }
            proc.name = processNameResult.getResult();
            if (proc.name == null || proc.name.length() <= 0) {
                ParseResult<ParsedProcess> parseResult = input.error("<process> does not specify android:process");
                return parseResult;
            }
            proc.gwpAsanMode = sa.getInt(1, -1);
        }
        finally {
            sa.recycle();
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            ParseResult<Set<String>> result;
            String tagName;
            if (type == 3 || type == 4) continue;
            switch (tagName = parser.getName()) {
                case "deny-permission": {
                    ParseResult<Set<String>> denyResult;
                    result = denyResult = ParsedProcessUtils.parseDenyPermission(proc.deniedPermissions, res, parser, input);
                    if (!denyResult.isSuccess()) break;
                    proc.deniedPermissions = denyResult.getResult();
                    break;
                }
                case "allow-permission": {
                    ParseResult<Set<String>> allowResult = ParsedProcessUtils.parseAllowPermission(proc.deniedPermissions, res, parser, input);
                    result = allowResult;
                    if (!allowResult.isSuccess()) break;
                    proc.deniedPermissions = allowResult.getResult();
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<process>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(proc);
    }

    public static ParseResult<ArrayMap<String, ParsedProcess>> parseProcesses(String[] separateProcesses, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, ParseInput input) throws IOException, XmlPullParserException {
        int type;
        Set<String> deniedPerms = null;
        ArrayMap<String, ParsedProcess> processes = new ArrayMap<String, ParsedProcess>();
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            ParseResult<Object> result;
            String tagName;
            if (type == 3 || type == 4) continue;
            switch (tagName = parser.getName()) {
                case "deny-permission": {
                    ParseResult<Set<String>> denyResult;
                    result = denyResult = ParsedProcessUtils.parseDenyPermission(deniedPerms, res, parser, input);
                    if (!denyResult.isSuccess()) break;
                    deniedPerms = denyResult.getResult();
                    break;
                }
                case "allow-permission": {
                    ParseResult<Set<String>> allowResult = ParsedProcessUtils.parseAllowPermission(deniedPerms, res, parser, input);
                    result = allowResult;
                    if (!allowResult.isSuccess()) break;
                    deniedPerms = allowResult.getResult();
                    break;
                }
                case "process": {
                    ParsedProcess process;
                    ParseResult<ParsedProcess> processResult = ParsedProcessUtils.parseProcess(deniedPerms, separateProcesses, pkg, res, parser, flags, input);
                    result = processResult;
                    if (!processResult.isSuccess() || processes.put(process.name, process = processResult.getResult()) == null) break;
                    result = input.error("<process> specified existing name '" + process.name + "'");
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<processes>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(processes);
    }
}

