/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import java.util.Collections;
import java.util.Set;

public class ParsedProcess
implements Parcelable {
    protected String name;
    protected Set<String> deniedPermissions = Collections.emptySet();
    protected int gwpAsanMode = -1;
    static Parcelling<Set<String>> sParcellingForDeniedPermissions = Parcelling.Cache.get(Parcelling.BuiltIn.ForInternedStringSet.class);
    public static final Parcelable.Creator<ParsedProcess> CREATOR;

    public ParsedProcess() {
    }

    public ParsedProcess(ParsedProcess other) {
        this.name = other.name;
        this.deniedPermissions = new ArraySet<String>(other.deniedPermissions);
    }

    public void addStateFrom(ParsedProcess other) {
        this.deniedPermissions = CollectionUtils.addAll(this.deniedPermissions, other.deniedPermissions);
    }

    public ParsedProcess(String name, Set<String> deniedPermissions, int gwpAsanMode) {
        this.name = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)name);
        this.deniedPermissions = deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, deniedPermissions);
        this.gwpAsanMode = gwpAsanMode;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getDeniedPermissions() {
        return this.deniedPermissions;
    }

    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        sParcellingForDeniedPermissions.parcel(this.deniedPermissions, dest, flags);
        dest.writeInt(this.gwpAsanMode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ParsedProcess(Parcel in) {
        String _name = in.readString();
        Set<String> _deniedPermissions = sParcellingForDeniedPermissions.unparcel(in);
        int _gwpAsanMode = in.readInt();
        this.name = _name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.name);
        this.deniedPermissions = _deniedPermissions;
        AnnotationValidations.validate(NonNull.class, null, this.deniedPermissions);
        this.gwpAsanMode = _gwpAsanMode;
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForDeniedPermissions == null) {
            sParcellingForDeniedPermissions = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInternedStringSet());
        }
        CREATOR = new Parcelable.Creator<ParsedProcess>(){

            public ParsedProcess[] newArray(int size) {
                return new ParsedProcess[size];
            }

            @Override
            public ParsedProcess createFromParcel(Parcel in) {
                return new ParsedProcess(in);
            }
        };
    }
}

