/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.DataLoaderParamsParcel;
import android.content.pm.IDataLoader;
import android.content.pm.IDataLoaderManager;
import android.content.pm.IDataLoaderStatusListener;
import android.os.RemoteException;

public class DataLoaderManager {
    private static final String TAG = "DataLoaderManager";
    private final IDataLoaderManager mService;

    public DataLoaderManager(IDataLoaderManager service) {
        this.mService = service;
    }

    public boolean bindToDataLoader(int dataLoaderId, DataLoaderParamsParcel params, IDataLoaderStatusListener listener) {
        try {
            return this.mService.bindToDataLoader(dataLoaderId, params, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public IDataLoader getDataLoader(int dataLoaderId) {
        try {
            return this.mService.getDataLoader(dataLoaderId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unbindFromDataLoader(int dataLoaderId) {
        try {
            this.mService.unbindFromDataLoader(dataLoaderId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

