/*
 * Decompiled with CFR 0.152.
 */
package android.compat;

import com.android.internal.lang.System_Delegate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Compatibility {
    private static volatile Callbacks sCallbacks = new Callbacks();

    private Compatibility() {
    }

    public static void reportChange(long changeId) {
        sCallbacks.reportChange(changeId);
    }

    public static boolean isChangeEnabled(long changeId) {
        return sCallbacks.isChangeEnabled(changeId);
    }

    public static void setCallbacks(Callbacks callbacks) {
        sCallbacks = Objects.requireNonNull(callbacks);
    }

    public static void setOverrides(ChangeConfig overrides) {
        if (sCallbacks instanceof OverrideCallbacks) {
            throw new IllegalStateException("setOverrides has already been called!");
        }
        sCallbacks = new OverrideCallbacks(sCallbacks, overrides);
    }

    public static void clearOverrides() {
        if (!(sCallbacks instanceof OverrideCallbacks)) {
            throw new IllegalStateException("No overrides set");
        }
        sCallbacks = ((OverrideCallbacks)sCallbacks).delegate;
    }

    private static class OverrideCallbacks
    extends Callbacks {
        private final Callbacks delegate;
        private final ChangeConfig changeConfig;

        private OverrideCallbacks(Callbacks delegate, ChangeConfig changeConfig) {
            this.delegate = Objects.requireNonNull(delegate);
            this.changeConfig = Objects.requireNonNull(changeConfig);
        }

        @Override
        protected boolean isChangeEnabled(long changeId) {
            if (this.changeConfig.isForceEnabled(changeId)) {
                return true;
            }
            if (this.changeConfig.isForceDisabled(changeId)) {
                return false;
            }
            return this.delegate.isChangeEnabled(changeId);
        }
    }

    public static class ChangeConfig {
        private final Set<Long> enabled;
        private final Set<Long> disabled;

        public ChangeConfig(Set<Long> enabled, Set<Long> disabled) {
            this.enabled = Objects.requireNonNull(enabled);
            this.disabled = Objects.requireNonNull(disabled);
            if (enabled.contains(null)) {
                throw new NullPointerException();
            }
            if (disabled.contains(null)) {
                throw new NullPointerException();
            }
            HashSet<Long> intersection = new HashSet<Long>(enabled);
            intersection.retainAll(disabled);
            if (!intersection.isEmpty()) {
                throw new IllegalArgumentException("Cannot have changes " + intersection + " enabled and disabled!");
            }
        }

        public boolean isEmpty() {
            return this.enabled.isEmpty() && this.disabled.isEmpty();
        }

        private static long[] toLongArray(Set<Long> values) {
            long[] result = new long[values.size()];
            int idx = 0;
            for (Long value : values) {
                result[idx++] = value;
            }
            return result;
        }

        public long[] forceEnabledChangesArray() {
            return ChangeConfig.toLongArray(this.enabled);
        }

        public long[] forceDisabledChangesArray() {
            return ChangeConfig.toLongArray(this.disabled);
        }

        public Set<Long> forceEnabledSet() {
            return Collections.unmodifiableSet(this.enabled);
        }

        public Set<Long> forceDisabledSet() {
            return Collections.unmodifiableSet(this.disabled);
        }

        public boolean isForceEnabled(long changeId) {
            return this.enabled.contains(changeId);
        }

        public boolean isForceDisabled(long changeId) {
            return this.disabled.contains(changeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ChangeConfig)) {
                return false;
            }
            ChangeConfig that = (ChangeConfig)o;
            return this.enabled.equals(that.enabled) && this.disabled.equals(that.disabled);
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.disabled);
        }

        public String toString() {
            return "ChangeConfig{enabled=" + this.enabled + ", disabled=" + this.disabled + '}';
        }
    }

    public static class Callbacks {
        protected Callbacks() {
        }

        protected void reportChange(long changeId) {
            System_Delegate.log("No Compatibility callbacks set! Reporting change " + changeId);
        }

        protected boolean isChangeEnabled(long changeId) {
            System_Delegate.log("No Compatibility callbacks set! Querying change " + changeId);
            return true;
        }
    }
}

