/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.app.slice.SliceItem;
import android.app.slice.SliceSpec;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.ArrayUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Slice
implements Parcelable {
    public static final String HINT_TITLE = "title";
    public static final String HINT_LIST = "list";
    public static final String HINT_LIST_ITEM = "list_item";
    public static final String HINT_LARGE = "large";
    public static final String HINT_ACTIONS = "actions";
    public static final String HINT_SELECTED = "selected";
    public static final String HINT_NO_TINT = "no_tint";
    public static final String HINT_SHORTCUT = "shortcut";
    public static final String HINT_SUMMARY = "summary";
    public static final String HINT_TOGGLE = "toggle";
    public static final String HINT_HORIZONTAL = "horizontal";
    public static final String HINT_PARTIAL = "partial";
    public static final String HINT_SEE_MORE = "see_more";
    public static final String HINT_CALLER_NEEDED = "caller_needed";
    public static final String HINT_KEYWORDS = "keywords";
    public static final String HINT_ERROR = "error";
    public static final String HINT_TTL = "ttl";
    public static final String HINT_LAST_UPDATED = "last_updated";
    public static final String HINT_PERMISSION_REQUEST = "permission_request";
    public static final String SUBTYPE_LAYOUT_DIRECTION = "layout_direction";
    public static final String EXTRA_TOGGLE_STATE = "android.app.slice.extra.TOGGLE_STATE";
    @Deprecated
    public static final String EXTRA_SLIDER_VALUE = "android.app.slice.extra.SLIDER_VALUE";
    public static final String EXTRA_RANGE_VALUE = "android.app.slice.extra.RANGE_VALUE";
    public static final String SUBTYPE_MESSAGE = "message";
    public static final String SUBTYPE_SOURCE = "source";
    public static final String SUBTYPE_COLOR = "color";
    @Deprecated
    public static final String SUBTYPE_SLIDER = "slider";
    public static final String SUBTYPE_RANGE = "range";
    public static final String SUBTYPE_MAX = "max";
    public static final String SUBTYPE_VALUE = "value";
    public static final String SUBTYPE_TOGGLE = "toggle";
    public static final String SUBTYPE_PRIORITY = "priority";
    public static final String SUBTYPE_CONTENT_DESCRIPTION = "content_description";
    public static final String SUBTYPE_MILLIS = "millis";
    private final SliceItem[] mItems;
    private final String[] mHints;
    private SliceSpec mSpec;
    private Uri mUri;
    public static final Parcelable.Creator<Slice> CREATOR = new Parcelable.Creator<Slice>(){

        @Override
        public Slice createFromParcel(Parcel in) {
            return new Slice(in);
        }

        public Slice[] newArray(int size) {
            return new Slice[size];
        }
    };

    Slice(ArrayList<SliceItem> items, String[] hints, Uri uri, SliceSpec spec) {
        this.mHints = hints;
        this.mItems = items.toArray(new SliceItem[items.size()]);
        this.mUri = uri;
        this.mSpec = spec;
    }

    protected Slice(Parcel in) {
        this.mHints = in.readStringArray();
        int n = in.readInt();
        this.mItems = new SliceItem[n];
        for (int i = 0; i < n; ++i) {
            this.mItems[i] = SliceItem.CREATOR.createFromParcel(in);
        }
        this.mUri = Uri.CREATOR.createFromParcel(in);
        this.mSpec = in.readTypedObject(SliceSpec.CREATOR);
    }

    public SliceSpec getSpec() {
        return this.mSpec;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public List<SliceItem> getItems() {
        return Arrays.asList(this.mItems);
    }

    public List<String> getHints() {
        return Arrays.asList(this.mHints);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(this.mHints);
        dest.writeInt(this.mItems.length);
        for (int i = 0; i < this.mItems.length; ++i) {
            this.mItems[i].writeToParcel(dest, flags);
        }
        this.mUri.writeToParcel(dest, 0);
        dest.writeTypedObject(this.mSpec, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean hasHint(String hint) {
        return ArrayUtils.contains(this.mHints, hint);
    }

    public boolean isCallerNeeded() {
        return this.hasHint(HINT_CALLER_NEEDED);
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mItems.length; ++i) {
            sb.append(indent);
            if (Objects.equals(this.mItems[i].getFormat(), "slice")) {
                sb.append("slice:\n");
                sb.append(this.mItems[i].getSlice().toString(indent + "   "));
                continue;
            }
            if (Objects.equals(this.mItems[i].getFormat(), "text")) {
                sb.append("text: ");
                sb.append(this.mItems[i].getText());
                sb.append("\n");
                continue;
            }
            sb.append(this.mItems[i].getFormat());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Builder {
        private final Uri mUri;
        private ArrayList<SliceItem> mItems = new ArrayList();
        private ArrayList<String> mHints = new ArrayList();
        private SliceSpec mSpec;

        @Deprecated
        public Builder(Uri uri) {
            this.mUri = uri;
        }

        public Builder(Uri uri, SliceSpec spec) {
            this.mUri = uri;
            this.mSpec = spec;
        }

        public Builder(Builder parent) {
            this.mUri = parent.mUri.buildUpon().appendPath("_gen").appendPath(String.valueOf(this.mItems.size())).build();
        }

        public Builder setCallerNeeded(boolean callerNeeded) {
            if (callerNeeded) {
                this.mHints.add(Slice.HINT_CALLER_NEEDED);
            } else {
                this.mHints.remove(Slice.HINT_CALLER_NEEDED);
            }
            return this;
        }

        public Builder addHints(List<String> hints) {
            this.mHints.addAll(hints);
            return this;
        }

        public Builder setSpec(SliceSpec spec) {
            this.mSpec = spec;
            return this;
        }

        public Builder addSubSlice(Slice slice, String subType) {
            Objects.requireNonNull(slice);
            this.mItems.add(new SliceItem((Object)slice, "slice", subType, slice.getHints().toArray(new String[slice.getHints().size()])));
            return this;
        }

        public Builder addAction(PendingIntent action, Slice s, String subType) {
            Objects.requireNonNull(action);
            Objects.requireNonNull(s);
            List<String> hints = s.getHints();
            s.mSpec = null;
            this.mItems.add(new SliceItem(action, s, "action", subType, hints.toArray(new String[hints.size()])));
            return this;
        }

        public Builder addText(CharSequence text, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)text, "text", subType, hints));
            return this;
        }

        public Builder addIcon(Icon icon, String subType, List<String> hints) {
            Objects.requireNonNull(icon);
            this.mItems.add(new SliceItem((Object)icon, "image", subType, hints));
            return this;
        }

        public Builder addRemoteInput(RemoteInput remoteInput, String subType, List<String> hints) {
            Objects.requireNonNull(remoteInput);
            this.mItems.add(new SliceItem((Object)remoteInput, "input", subType, hints));
            return this;
        }

        public Builder addInt(int value, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)value, "int", subType, hints));
            return this;
        }

        @Deprecated
        public Builder addTimestamp(long time, String subType, List<String> hints) {
            return this.addLong(time, subType, hints);
        }

        public Builder addLong(long value, String subType, List<String> hints) {
            this.mItems.add(new SliceItem((Object)value, "long", subType, hints.toArray(new String[hints.size()])));
            return this;
        }

        public Builder addBundle(Bundle bundle, String subType, List<String> hints) {
            Objects.requireNonNull(bundle);
            this.mItems.add(new SliceItem((Object)bundle, "bundle", subType, hints));
            return this;
        }

        public Slice build() {
            return new Slice(this.mItems, this.mHints.toArray(new String[this.mHints.size()]), this.mUri, this.mSpec);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SliceSubtype {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SliceHint {
    }
}

