/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.app.servertransaction.TransactionExecutorHelper;
import android.os.IBinder;
import android.util.IntArray;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;

public class TransactionExecutor {
    private static final boolean DEBUG_RESOLVER = false;
    private static final String TAG = "TransactionExecutor";
    private ClientTransactionHandler mTransactionHandler;
    private PendingTransactionActions mPendingActions = new PendingTransactionActions();
    private TransactionExecutorHelper mHelper = new TransactionExecutorHelper();

    public TransactionExecutor(ClientTransactionHandler clientTransactionHandler) {
        this.mTransactionHandler = clientTransactionHandler;
    }

    public void execute(ClientTransaction transaction) {
        Map<IBinder, ClientTransactionItem> activitiesToBeDestroyed;
        ClientTransactionItem destroyItem;
        IBinder token = transaction.getActivityToken();
        if (token != null && (destroyItem = (activitiesToBeDestroyed = this.mTransactionHandler.getActivitiesToBeDestroyed()).get(token)) != null) {
            if (transaction.getLifecycleStateRequest() == destroyItem) {
                activitiesToBeDestroyed.remove(token);
            }
            if (this.mTransactionHandler.getActivityClient(token) == null) {
                Slog.w(TAG, TransactionExecutorHelper.tId(transaction) + "Skip pre-destroyed transaction:\n" + TransactionExecutorHelper.transactionToString(transaction, this.mTransactionHandler));
                return;
            }
        }
        this.executeCallbacks(transaction);
        this.executeLifecycleState(transaction);
        this.mPendingActions.clear();
    }

    @VisibleForTesting
    public void executeCallbacks(ClientTransaction transaction) {
        List<ClientTransactionItem> callbacks = transaction.getCallbacks();
        if (callbacks == null || callbacks.isEmpty()) {
            return;
        }
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        ActivityLifecycleItem finalStateRequest = transaction.getLifecycleStateRequest();
        int finalState = finalStateRequest != null ? finalStateRequest.getTargetState() : -1;
        int lastCallbackRequestingState = TransactionExecutorHelper.lastCallbackRequestingState(transaction);
        int size = callbacks.size();
        for (int i = 0; i < size; ++i) {
            ClientTransactionItem item = callbacks.get(i);
            int postExecutionState = item.getPostExecutionState();
            int closestPreExecutionState = this.mHelper.getClosestPreExecutionState(r, item.getPostExecutionState());
            if (closestPreExecutionState != -1) {
                this.cycleToPath(r, closestPreExecutionState, transaction);
            }
            item.execute(this.mTransactionHandler, token, this.mPendingActions);
            item.postExecute(this.mTransactionHandler, token, this.mPendingActions);
            if (r == null) {
                r = this.mTransactionHandler.getActivityClient(token);
            }
            if (postExecutionState == -1 || r == null) continue;
            boolean shouldExcludeLastTransition = i == lastCallbackRequestingState && finalState == postExecutionState;
            this.cycleToPath(r, postExecutionState, shouldExcludeLastTransition, transaction);
        }
    }

    private void executeLifecycleState(ClientTransaction transaction) {
        ActivityLifecycleItem lifecycleItem = transaction.getLifecycleStateRequest();
        if (lifecycleItem == null) {
            return;
        }
        IBinder token = transaction.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        if (r == null) {
            return;
        }
        this.cycleToPath(r, lifecycleItem.getTargetState(), true, transaction);
        lifecycleItem.execute(this.mTransactionHandler, token, this.mPendingActions);
        lifecycleItem.postExecute(this.mTransactionHandler, token, this.mPendingActions);
    }

    @VisibleForTesting
    public void cycleToPath(ActivityThread.ActivityClientRecord r, int finish, ClientTransaction transaction) {
        this.cycleToPath(r, finish, false, transaction);
    }

    private void cycleToPath(ActivityThread.ActivityClientRecord r, int finish, boolean excludeLastState, ClientTransaction transaction) {
        int start = r.getLifecycleState();
        IntArray path = this.mHelper.getLifecyclePath(start, finish, excludeLastState);
        this.performLifecycleSequence(r, path, transaction);
    }

    private void performLifecycleSequence(ActivityThread.ActivityClientRecord r, IntArray path, ClientTransaction transaction) {
        int size = path.size();
        block9: for (int i = 0; i < size; ++i) {
            int state = path.get(i);
            switch (state) {
                case 1: {
                    this.mTransactionHandler.handleLaunchActivity(r, this.mPendingActions, null);
                    continue block9;
                }
                case 2: {
                    this.mTransactionHandler.handleStartActivity(r.token, this.mPendingActions);
                    continue block9;
                }
                case 3: {
                    this.mTransactionHandler.handleResumeActivity(r.token, false, r.isForward, "LIFECYCLER_RESUME_ACTIVITY");
                    continue block9;
                }
                case 4: {
                    this.mTransactionHandler.handlePauseActivity(r.token, false, false, 0, this.mPendingActions, "LIFECYCLER_PAUSE_ACTIVITY");
                    continue block9;
                }
                case 5: {
                    this.mTransactionHandler.handleStopActivity(r.token, 0, this.mPendingActions, false, "LIFECYCLER_STOP_ACTIVITY");
                    continue block9;
                }
                case 6: {
                    this.mTransactionHandler.handleDestroyActivity(r.token, false, 0, false, "performLifecycleSequence. cycling to:" + path.get(size - 1));
                    continue block9;
                }
                case 7: {
                    this.mTransactionHandler.performRestartActivity(r.token, false);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected lifecycle state: " + state);
                }
            }
        }
    }
}

